/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.SmAgentApiCommonConstants;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;

class SmRC2SHA1CryptoProvider
extends SmRC2CryptoProvider
implements SmAgentApiCommonConstants {
    protected MessageDigest m_md = null;

    SmRC2SHA1CryptoProvider(String string, boolean bl) throws SmCryptoProviderException {
        super(string, bl);
        this.m_digestAlg = "SHA";
        this.m_verifyDigest = false;
        try {
            this.m_md = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
            this.m_digestLength = this.getBlockSize();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    protected byte[] makeDigest(byte[] byArray, boolean bl) throws SmCryptoProviderException, GeneralSecurityException {
        return this.makeDigest(byArray, byArray.length, bl);
    }

    protected byte[] makeDigest(byte[] byArray, int n2, boolean bl) throws SmCryptoProviderException, GeneralSecurityException {
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[20];
        long l2 = System.currentTimeMillis() / 1000L;
        byArray2[0] = new Long(l2).byteValue();
        SmSecureRandom.nextBytes(byArray3);
        MessageDigest messageDigest = null;
        try {
            messageDigest = (MessageDigest)this.m_md.clone();
            messageDigest.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            messageDigest = null;
        }
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        messageDigest.update(byArray, 0, n2);
        try {
            messageDigest.update(String.valueOf(l2).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SmCryptoProviderException(unsupportedEncodingException);
        }
        messageDigest.update(byArray3);
        byte[] byArray4 = messageDigest.digest();
        byte[] byArray5 = new byte[this.m_digestLength];
        System.arraycopy(byArray4, 0, byArray5, 0, this.m_digestLength);
        return byArray5;
    }
}

