/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert.crmf;

import com.rsa.cryptoj.c.a;
import com.rsa.cryptoj.c.b;
import com.rsa.cryptoj.c.dc;
import com.rsa.cryptoj.c.dg;
import com.rsa.cryptoj.c.dp;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.InvalidEncodingException;
import com.rsa.jsafe.cert.crmf.ArchiveOptions;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ControlsSpec
implements Cloneable {
    private static final String a = "Input cannot be null.";
    private String b;
    private String c;
    private PublicKey d;
    private GeneralName e;
    private BigInteger f;
    private ArchiveOptions g;
    private boolean h;
    private boolean i;
    private List<SinglePubInfo> j;
    private List<byte[]> k;

    public void setRegistrationToken(String string) {
        if (string == null) {
            throw new IllegalArgumentException(a);
        }
        this.b = string;
    }

    public void setAuthenticator(String string) {
        if (string == null) {
            throw new IllegalArgumentException(a);
        }
        this.c = string;
    }

    public void setPublicationInformation(boolean bl2, List<SinglePubInfo> list) {
        if (!bl2 && list != null && !list.isEmpty()) {
            throw new IllegalArgumentException("Did not expect pubInfos when publish is false");
        }
        if (list != null && list.contains(null)) {
            throw new IllegalArgumentException("pubInfos contained a null entry");
        }
        this.i = true;
        this.h = bl2;
        if (list != null) {
            this.j = Collections.unmodifiableList(new ArrayList<SinglePubInfo>(list));
        }
    }

    public void setArchiveOptions(ArchiveOptions archiveOptions) {
        if (archiveOptions == null) {
            throw new IllegalArgumentException(a);
        }
        this.g = archiveOptions;
    }

    public void setOldCertID(GeneralName generalName, BigInteger bigInteger) {
        if (generalName == null || bigInteger == null) {
            throw new IllegalArgumentException(a);
        }
        this.e = generalName;
        this.f = bigInteger;
    }

    public void setProtocolEncryptionKey(PublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException(a);
        }
        this.d = publicKey;
    }

    public void addControl(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(a);
        }
        try {
            com.rsa.cryptoj.c.a.a("AttributeTypeAndValue", byArray, 0);
        }
        catch (b b2) {
            throw new InvalidEncodingException("Invalid control encoding.");
        }
        if (this.k == null) {
            this.k = new ArrayList<byte[]>();
        }
        this.k.add(dc.a(byArray));
    }

    public String getRegistrationToken() {
        return this.b;
    }

    public String getAuthenticator() {
        return this.c;
    }

    public boolean getPublicationInformationAction() {
        return this.h;
    }

    public boolean isPublicationInformationSpecified() {
        return this.i;
    }

    public List<SinglePubInfo> getPublicationInfos() {
        if (this.j == null) {
            return null;
        }
        return this.j;
    }

    public ArchiveOptions getArchiveOptions() {
        return this.g;
    }

    public GeneralName getOldCertIDIssuer() {
        return this.e;
    }

    public BigInteger getOldCertIDSerialNumber() {
        return this.f;
    }

    public PublicKey getProtocolEncryptionKey() {
        return this.d;
    }

    public List<byte[]> getOtherControls() {
        return dc.a(this.k);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ControlsSpec)) {
            return false;
        }
        ControlsSpec controlsSpec = (ControlsSpec)object;
        return this.b == controlsSpec.b && this.c == controlsSpec.c && this.i == controlsSpec.i && this.h == controlsSpec.h && this.d == null ? controlsSpec.d == null : (this.d.equals(controlsSpec.d) && this.e == null ? controlsSpec.e == null : (this.e.equals(controlsSpec.e) && this.f == null ? controlsSpec.f == null : (this.f.equals(controlsSpec.f) && this.g == null ? controlsSpec.g == null : (((Object)this.g).equals(controlsSpec.g) && this.j == null ? controlsSpec.j == null : (((Object)this.j).equals(controlsSpec.j) && this.k == null ? controlsSpec.k == null : dp.b(this.k, controlsSpec.k))))));
    }

    public int hashCode() {
        int n2 = 7;
        n2 = dg.a(n2, this.b);
        n2 = dg.a(n2, this.c);
        n2 = dg.a(n2, this.i);
        n2 = dg.a(n2, this.h);
        n2 = dg.a(n2, this.d);
        n2 = dg.a(n2, this.e);
        n2 = dg.a(n2, this.f);
        n2 = dg.a(n2, this.g);
        n2 = dg.a(n2, this.j);
        n2 = dg.a(n2, this.k);
        return n2;
    }

    public Object clone() {
        ControlsSpec controlsSpec;
        try {
            controlsSpec = (ControlsSpec)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not clone object.");
        }
        controlsSpec.k = dc.a(this.k);
        return controlsSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ControlsSpec [").append(dp.a);
        if (this.b != null) {
            stringBuffer.append("regToken: ").append(this.b).append(dp.a);
        }
        if (this.c != null) {
            stringBuffer.append("authenticator: ").append(this.c).append(dp.a);
        }
        if (this.e != null) {
            stringBuffer.append("oldCertID [").append(dp.a);
            stringBuffer.append("issuer = ").append(this.e).append(dp.a);
            stringBuffer.append("serialNum = ").append(this.f).append(dp.a);
            stringBuffer.append("]").append(dp.a);
        }
        if (this.i) {
            stringBuffer.append("pubInfo [").append(dp.a);
            stringBuffer.append("action = ").append(this.h ? "publish" : "dontPublish").append(dp.a);
            if (this.j != null) {
                stringBuffer.append("infos = [").append(dp.a);
                Iterator<Object> iterator = this.j.iterator();
                while (iterator.hasNext()) {
                    Object object = (SinglePubInfo)iterator.next();
                    stringBuffer.append(object).append(dp.a);
                }
                stringBuffer.append("]").append(dp.a);
            }
            stringBuffer.append("]").append(dp.a);
        }
        if (this.d != null) {
            stringBuffer.append("protocolEncryptionKey: ").append(this.d).append(dp.a);
        }
        if (this.g != null) {
            stringBuffer.append("archiveOptions: ").append(this.g).append(dp.a);
        }
        if (this.k != null) {
            stringBuffer.append("otherControls: [").append(dp.a);
            for (Object object : this.k) {
                stringBuffer.append("encoding = ").append(dp.a(object)).append(dp.a);
            }
            stringBuffer.append("]").append(dp.a);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static enum PubMethod {
        DONT_CARE(0),
        X500(1),
        WEB(2),
        LDAP(3);

        private final int a;

        private PubMethod(int n3) {
            this.a = n3;
        }

        public int id() {
            return this.a;
        }
    }

    public static class SinglePubInfo {
        private PubMethod a;
        private GeneralName b;

        public SinglePubInfo(PubMethod pubMethod) {
            if (pubMethod == null) {
                throw new IllegalArgumentException("Input cannot be null");
            }
            this.a = pubMethod;
        }

        public SinglePubInfo(PubMethod pubMethod, GeneralName generalName) {
            this(pubMethod);
            if (generalName == null) {
                throw new IllegalArgumentException("Input cannot be null");
            }
            this.b = generalName;
        }

        public PubMethod getPubMethod() {
            return this.a;
        }

        public GeneralName getPubLocation() {
            return this.b;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof SinglePubInfo)) {
                return false;
            }
            SinglePubInfo singlePubInfo = (SinglePubInfo)object;
            return this.a == singlePubInfo.a && (this.b == null ? singlePubInfo.b == null : this.b.equals(singlePubInfo.b));
        }

        public int hashCode() {
            int n2 = dg.a(7, (Object)this.a);
            n2 = dg.a(n2, this.b);
            return n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SinglePubInfo [").append(dp.a);
            stringBuffer.append("method = ").append((Object)this.a).append("( ").append((Object)this.a).append(")").append(dp.a);
            if (this.b != null) {
                stringBuffer.append("location: ").append(this.b).append(dp.a);
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

