/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.ccme;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.JCMCloneable;
import com.rsa.crypto.SensitiveData;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEHandle;
import com.rsa.crypto.ncm.ccme.CCMEPKCS11Provider;
import com.rsa.crypto.ncm.key.j;
import java.nio.charset.Charset;

public abstract class CCMEAsymmetricKey
extends CCMEHandle
implements JCMCloneable,
SensitiveData,
j {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final int R_PKEY_TYPE_DH = 1;
    public static final int R_PKEY_TYPE_ECC = 2;
    public static final int R_PKEY_TYPE_DSA = 3;
    public static final int R_PKEY_TYPE_RSA = 4;
    public static final int R_PKEY_TYPE_ECCPARAMS = 5;
    public static final int R_PKEY_TYPE_DSAPARAMS = 6;
    public static final int R_PKEY_TYPE_UNKNOWN = -1;
    protected final b cryptoModule;
    protected final boolean isPKCS11Object;

    protected CCMEAsymmetricKey(b b2) {
        this.cryptoModule = b2;
        this.isPKCS11Object = b2.a().isPKCS11Context();
    }

    public b getCryptoModule() {
        return this.cryptoModule;
    }

    @Override
    public synchronized Object clone() {
        CCMEAsymmetricKey cCMEAsymmetricKey = (CCMEAsymmetricKey)super.clone();
        if (!this.isHandleNull()) {
            this.dupObject(cCMEAsymmetricKey);
        }
        return cCMEAsymmetricKey;
    }

    @Override
    public synchronized void clearSensitiveData() {
        this.freeObject();
    }

    public synchronized boolean isSensitiveDataCleared() {
        return this.isHandleNull();
    }

    void freeObject() {
        if (!this.isHandleNull()) {
            this.freeObjectNative();
        }
    }

    @Override
    public synchronized native byte[] getKeyID() throws CryptoException;

    @Override
    public synchronized native void setKeyID(byte[] var1) throws CryptoException;

    @Override
    public String getKeyLabel() throws CryptoException {
        byte[] byArray = this.getKeyLabelNative();
        if (byArray == null || byArray.length == 1 && byArray[0] == 0) {
            return null;
        }
        return new String(byArray, UTF8_CHARSET);
    }

    private synchronized native byte[] getKeyLabelNative() throws CryptoException;

    @Override
    public void setKeyLabel(String string) throws CryptoException {
        this.setKeyLabelNative(string.getBytes(UTF8_CHARSET));
    }

    private synchronized native void setKeyLabelNative(byte[] var1) throws CryptoException;

    @Override
    public byte[] getManufacturerID() throws CryptoException {
        boolean bl2 = this.cryptoModule.a().isPKCS11Context();
        if (!bl2) {
            throw new CryptoException("Not a PKCS #11 key");
        }
        return ((CCMEPKCS11Provider)this.cryptoModule.a().getProvider()).getManufacturerID();
    }

    @Override
    public synchronized native void deleteKeyFromDevice();

    protected synchronized native void store(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.freeObject();
        }
        finally {
            super.finalize();
        }
    }

    private native void freeObjectNative();

    protected native void dupObject(CCMEAsymmetricKey var1);
}

