/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.tunnel;

import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.tunnel.PaCrypto;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class XpsHostConfig
implements ContextConstants {
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());
    public static final String defaultFile = "XpsHost.properties";
    private static final Logger logger = Logger.getLogger(XpsHostConfig.class);
    String ps_ip;
    Integer ps_port;
    Integer ps_fips;
    String psid;
    String secret;
    String trustedHost;
    String userPath;

    public String getPSID() {
        return this.psid;
    }

    public int getPort() {
        return this.ps_port == null ? 0 : this.ps_port;
    }

    public int getFIPS() {
        return this.ps_fips == null ? 0 : this.ps_fips;
    }

    public String getPsIp() {
        return this.ps_ip;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getTrustedHost() {
        return this.trustedHost;
    }

    public String getUserPath() {
        return this.userPath;
    }

    public static XpsHostConfig restore(String string) {
        if (string == null) {
            logger.warn((Object)xlate.translate("SM-ALY-02057"));
            string = defaultFile;
        }
        XpsHostConfig xpsHostConfig = new XpsHostConfig();
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
            String string2 = xlate.formatMessage("SM-ALY-02058", new Object[]{System.getProperty("user.dir"), string, iOException.getMessage()});
            logger.error((Object)string2);
            throw new RuntimeException(string2);
        }
        finally {
            try {
                if (null != fileInputStream) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        xpsHostConfig.ps_ip = properties.getProperty("PS_IP");
        xpsHostConfig.psid = properties.getProperty("PS_ID");
        xpsHostConfig.ps_port = new Integer(properties.getProperty("PS_AUPORT"));
        xpsHostConfig.userPath = properties.getProperty("USER_NAME");
        xpsHostConfig.trustedHost = properties.getProperty("TRUSTED_HOST_NAME");
        xpsHostConfig.secret = properties.getProperty("TRUSTED_HOST_SECRET");
        xpsHostConfig.secret = PaCrypto.decrypt(xpsHostConfig.secret);
        xpsHostConfig.ps_fips = new Integer(properties.getProperty("PS_FIPS"));
        return xpsHostConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("PS_IP", this.ps_ip);
        properties.setProperty("PS_FIPS", this.ps_fips.toString());
        properties.setProperty("PS_ID", this.psid);
        properties.setProperty("PS_AUPORT", this.ps_port.toString());
        String string2 = "SM://" + this.psid + "/" + this.userPath;
        properties.setProperty("USER_NAME", string2);
        properties.setProperty("TRUSTED_HOST_NAME", this.trustedHost);
        properties.setProperty("TRUSTED_HOST_SECRET", PaCrypto.encrypt(this.secret));
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            properties.store(fileOutputStream, xlate.translate("SM-ALY-02027"));
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (null != outputStreamWriter) {
                    outputStreamWriter.close();
                }
                if (null != fileOutputStream) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void saveToDir(String string, String string2) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            boolean bl = file.mkdirs();
        } else if (!file.isDirectory()) {
            throw new IOException("not a directory: " + string);
        }
        File file2 = new File(file, string2);
        this.save(file2.getAbsolutePath());
    }

    public void saveToDir(String string) throws Exception {
        String string2 = this.getPSID() + ".conf";
        this.saveToDir(string, string2);
    }

    public Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.ps_ip);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
        String string = inetAddress.getHostAddress();
        hashMap.put("PS_IP", string);
        hashMap.put("agentName", this.trustedHost);
        hashMap.put("agentSecret", this.secret);
        hashMap.put("userId", this.userPath);
        if (this.ps_port != null) {
            hashMap.put("PS_AUPORT", this.ps_port);
        }
        hashMap.put("PS_FIPS", this.ps_fips);
        return hashMap;
    }
}

