/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer.jdbc;

import com.ca.siteminder.analyzer.jdbc.POJOException;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetFactory;

public abstract class POJOResultSetColumn {
    protected final POJOResultSetFactory factory;

    public POJOResultSetColumn(POJOResultSetFactory pOJOResultSetFactory) {
        this.factory = pOJOResultSetFactory;
    }

    public abstract String memberName();

    public abstract Class memberType();

    public abstract String defaultColumnName();

    public String name() {
        String string = this.factory.getMemberColumnName(this.memberName());
        if (string == null) {
            string = this.defaultColumnName();
        }
        return string;
    }

    public String label() {
        String string = this.factory.getMemberColumnLabel(this.memberName());
        if (string == null) {
            string = this.name();
        }
        return string;
    }

    public int displaySize() {
        return this.factory.getMemberColumnDisplaySize(this.memberName(), this.memberType());
    }

    public int precision() {
        return this.factory.getMemberColumnPrecision(this.memberName(), this.memberType());
    }

    public int scale() {
        return this.factory.getMemberColumnScale(this.memberName(), this.memberType());
    }

    public boolean isCurrency() {
        return this.factory.isCurrencyMember(this.memberName());
    }

    public int sqlType() {
        return POJOResultSetFactory.sqlTypeOf(this.memberType());
    }

    public abstract Object valueFor(Object var1) throws POJOException;
}

