/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer.jdbc;

import com.ca.siteminder.analyzer.jdbc.POJOException;
import com.ca.siteminder.analyzer.jdbc.POJOReaderStream;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetColumn;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetFactory;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetMetaData;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;

public class IteratorResultSet
implements ResultSet {
    private final POJOResultSetMetaData metaData;
    private final Iterator domainInstances;
    private String smI18nMsg = null;
    private Object currentObject;
    private int currentSqlRow = 0;
    private boolean isDone = false;
    private boolean wasNull = false;
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());

    public IteratorResultSet(POJOResultSetMetaData pOJOResultSetMetaData, Iterator iterator) {
        this.metaData = pOJOResultSetMetaData;
        this.domainInstances = iterator;
        this.beforeFirst();
    }

    public POJOResultSetColumn columnAt(int n) throws SQLException {
        return this.metaData.columnAt(n);
    }

    public Object valueAt(int n) throws SQLException {
        POJOResultSetColumn pOJOResultSetColumn = this.columnAt(n);
        Object object = this.currentObject;
        if (object == null) {
            String string = xlate.translate("SM-ALY-02036");
            throw new SQLException(string);
        }
        if (this.metaData.domainClass().isInstance(object)) {
            try {
                Object object2 = pOJOResultSetColumn.valueFor(object);
                this.wasNull = object2 == null;
                return object2;
            }
            catch (POJOException pOJOException) {
                String string = xlate.translate("SM-ALY-02037");
                throw this.sqlError(string, pOJOException);
            }
        }
        String string = xlate.formatMessage("SM-ALY-02038", new Object[]{object.getClass().getName(), this.metaData.domainClass().getName()});
        throw new SQLException(string);
    }

    public Object valueAt(String string) throws SQLException {
        return this.valueAt(this.findColumn(string));
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    private String fullMemberNameOf(int n) throws SQLException {
        return this.metaData.domainClassName() + '.' + this.columnAt(n).memberName();
    }

    private Object typedValueOf(int n, Class clazz, boolean bl) throws SQLException {
        Object object = null;
        Object object2 = this.valueAt(n);
        if (object2 == null) {
            if (!bl) {
                String string = xlate.formatMessage("SM-ALY-02039", new Object[]{this.fullMemberNameOf(n)});
                throw new SQLException(string);
            }
        } else if (clazz.isInstance(object2)) {
            object = object2;
        } else {
            String string = xlate.formatMessage("SM-ALY-02040", new Object[]{this.fullMemberNameOf(n), clazz.getName(), object2.getClass().getName()});
            throw new SQLException(string);
        }
        return object;
    }

    private Object typedValueOf(int n, Class clazz) throws SQLException {
        return this.typedValueOf(n, clazz, true);
    }

    private Number numberValueOf(int n) throws SQLException {
        return (Number)this.typedValueOf(n, Number.class, false);
    }

    private String stringValueOf(int n) throws SQLException {
        return (String)this.typedValueOf(n, String.class);
    }

    private InputStream newReaderStream(Reader reader, String string, int n) throws SQLException {
        try {
            return new POJOReaderStream(reader, string);
        }
        catch (IOException iOException) {
            throw this.sqlErrorOf(iOException, n);
        }
    }

    private SQLException sqlErrorOf(IOException iOException, int n) throws SQLException {
        String string = xlate.formatMessage("SM-ALY-02041", new Object[]{iOException.toString(), this.fullMemberNameOf(n)});
        return new SQLException(string);
    }

    private SQLException sqlError(String string, POJOException pOJOException) {
        Throwable throwable = pOJOException;
        if (pOJOException.getMessage() == null && pOJOException.getCause() != null) {
            throwable = pOJOException.getCause();
        }
        SQLException sQLException = new SQLException(string + ": " + throwable.toString());
        sQLException.initCause(throwable);
        return sQLException;
    }

    public String getString(int n) throws SQLException {
        return (String)this.typedValueOf(n, String.class);
    }

    public boolean getBoolean(int n) throws SQLException {
        Boolean bl = (Boolean)this.typedValueOf(n, Boolean.class, false);
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        return this.numberValueOf(n).byteValue();
    }

    public short getShort(int n) throws SQLException {
        return this.numberValueOf(n).shortValue();
    }

    public int getInt(int n) throws SQLException {
        return this.numberValueOf(n).intValue();
    }

    public long getLong(int n) throws SQLException {
        return this.numberValueOf(n).longValue();
    }

    public float getFloat(int n) throws SQLException {
        return this.numberValueOf(n).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        return this.numberValueOf(n).doubleValue();
    }

    public byte[] getBytes(int n) throws SQLException {
        InputStream inputStream = this.getBinaryStream(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (n2 <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw this.sqlErrorOf(iOException, n);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.typedValueOf(n, Date.class);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.typedValueOf(n, Time.class);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.typedValueOf(n, Timestamp.class);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Class clazz = this.columnAt(n).memberType();
        if (Clob.class.isAssignableFrom(clazz)) {
            Clob clob = this.getClob(n);
            return clob.getAsciiStream();
        }
        return this.newReaderStream(this.getCharacterStream(n), "US-ASCII", n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.newReaderStream(this.getCharacterStream(n), "UTF-16", n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Class clazz = this.columnAt(n).memberType();
        if (Blob.class.isAssignableFrom(clazz)) {
            Blob blob = this.getBlob(n);
            return blob.getBinaryStream();
        }
        return this.newReaderStream(this.getCharacterStream(n), "UTF-8", n);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public String getCursorName() {
        return "";
    }

    public ResultSetMetaData getMetaData() {
        return this.getPOJOMetaData();
    }

    public POJOResultSetMetaData getPOJOMetaData() {
        return this.metaData;
    }

    public Object getObject(int n) throws SQLException {
        return this.valueAt(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.valueAt(string);
    }

    public int findColumn(String string) throws SQLException {
        return this.metaData.findColumn(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Class clazz = this.columnAt(n).memberType();
        if (Clob.class.isAssignableFrom(clazz)) {
            Clob clob = this.getClob(n);
            return clob.getCharacterStream();
        }
        String string = this.stringValueOf(n);
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2);
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Number number = (Number)this.typedValueOf(n, Number.class, true);
        BigDecimal bigDecimal = number == null ? null : (number instanceof BigDecimal ? (BigDecimal)number : (POJOResultSetFactory.isIntegerType(number.getClass()) ? new BigDecimal(BigInteger.valueOf(number.longValue())) : new BigDecimal(number.doubleValue())));
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    boolean unsupportedOperation(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(string);
    }

    public boolean isBeforeFirst() {
        return this.currentSqlRow == 0;
    }

    public boolean isAfterLast() {
        return this.isDone;
    }

    public boolean isFirst() {
        return this.currentSqlRow == 1;
    }

    public boolean isLast() {
        return !this.isDone && !this.domainInstances.hasNext();
    }

    public void beforeFirst() {
        if (this.currentSqlRow != 0) {
            this.unsupportedOperation("beforeFirst");
        }
    }

    public void afterLast() {
        this.unsupportedOperation("afterLast");
    }

    public boolean first() {
        if (this.currentSqlRow == 0) {
            return this.next();
        }
        return this.unsupportedOperation("first");
    }

    public boolean last() {
        return this.unsupportedOperation("last");
    }

    public int getRow() {
        return this.currentSqlRow;
    }

    public boolean absolute(int n) {
        if (this.currentSqlRow == n - 1) {
            return this.next();
        }
        return this.unsupportedOperation("absolute");
    }

    public boolean relative(int n) {
        if (n == 1) {
            return this.next();
        }
        return this.unsupportedOperation("relative");
    }

    public boolean previous() {
        return this.unsupportedOperation("previous");
    }

    public boolean next() {
        if (this.domainInstances.hasNext()) {
            this.currentObject = this.domainInstances.next();
            ++this.currentSqlRow;
            return true;
        }
        this.isDone = true;
        return false;
    }

    public void close() {
    }

    public void setFetchDirection(int n) {
    }

    public int getFetchDirection() {
        return 1000;
    }

    public void setFetchSize(int n) {
    }

    public int getFetchSize() {
        return 0;
    }

    public int getType() {
        return 1003;
    }

    public int getConcurrency() {
        return 1007;
    }

    private static void assertReadOnly() throws SQLException {
        throw new SQLException(xlate.translate("SM-ALY-02042"));
    }

    public boolean rowUpdated() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowDeleted() {
        return false;
    }

    public void updateNull(int n) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateByte(int n, byte by) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateShort(int n, short s) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateInt(int n, int n2) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateLong(int n, long l) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateFloat(int n, float f) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateDouble(int n, double d) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateString(int n, String string) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateDate(int n, Date date) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateTime(int n, Time time) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateObject(int n, Object object) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateNull(String string) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateByte(String string, byte by) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateShort(String string, short s) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateInt(String string, int n) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateLong(String string, long l) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateFloat(String string, float f) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateDouble(String string, double d) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateString(String string, String string2) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateDate(String string, Date date) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateTime(String string, Time time) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateObject(String string, Object object) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void insertRow() throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateRow() throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void deleteRow() throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void refreshRow() {
    }

    public void cancelRowUpdates() {
    }

    public void moveToInsertRow() throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void moveToCurrentRow() {
    }

    public Statement getStatement() {
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException(xlate.translate("SM-ALY-02043"));
    }

    public Ref getRef(int n) throws SQLException {
        return (Ref)this.typedValueOf(n, Ref.class);
    }

    public Blob getBlob(int n) throws SQLException {
        return (Blob)this.typedValueOf(n, Blob.class);
    }

    public Clob getClob(int n) throws SQLException {
        return (Clob)this.typedValueOf(n, Clob.class);
    }

    public Array getArray(int n) throws SQLException {
        return (Array)this.typedValueOf(n, Array.class);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(string);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(string);
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException(xlate.translate("SM-ALY-02044"));
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateArray(int n, Array array) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }

    public void updateArray(String string, Array array) throws SQLException {
        IteratorResultSet.assertReadOnly();
    }
}

