/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.policyserver.smapi;

import com.ca.smi18n.Smi18n;
import com.netegrity.policyserver.smapi.APIContext;
import com.netegrity.policyserver.smapi.NativeCallbackError;
import com.netegrity.policyserver.smapi.RequestContext;
import com.netegrity.policyserver.smapi.SmAPIContextLogger;
import com.netegrity.policyserver.smapi.TunnelContext;
import com.netegrity.policyserver.smapi.TunnelService;
import com.netegrity.util.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class TunnelServiceContext {
    private static final String TUNNEL_SERVICE_RESOURCE_BUNDLE = "tunnelService";
    private long m_lpServiceHandle;
    private APIContext m_APIContext;
    private RequestContext m_RequestContext;
    private TunnelContext m_TunnelContext;
    private byte[] m_InBuf;
    private int m_nBytesErrBuf;
    private long m_lpErrBuf;
    private static Hashtable m_tunnelServices = new Hashtable();
    private static ResourceBundle m_rb;
    private static ResourceBundle m_rbAdmin;
    private static final String libName = "smjavaapi";

    private TunnelServiceContext(long l, long l2, long l3, long l4, byte[] byArray, int n, long l5) {
        this.m_lpServiceHandle = l;
        this.m_APIContext = new SmAPIContextLogger(l2);
        this.m_RequestContext = new RequestContext(l3);
        this.m_TunnelContext = new TunnelContext(l4);
        this.m_InBuf = byArray;
        this.m_nBytesErrBuf = n;
        this.m_lpErrBuf = l5;
    }

    public APIContext getAPIContext() {
        return this.m_APIContext;
    }

    public RequestContext getRequestContext() {
        return this.m_RequestContext;
    }

    public TunnelContext getTunnelContext() {
        return this.m_TunnelContext;
    }

    public byte[] getInputData() {
        return this.m_InBuf;
    }

    public void setErrorText(String string) {
        if (this.m_lpErrBuf == 0L) {
            Logger.logError((ResourceBundle)TunnelServiceContext.getAdminResourceBundle(), (String)"SM-API-02003", (Object)"TunnelServiceContext setErrorText", (Object)string);
        } else {
            this.setErrorText(this.m_nBytesErrBuf, this.m_lpErrBuf, string);
        }
    }

    public static ResourceBundle getResourceBundle() {
        if (m_rb != null) {
            return m_rb;
        }
        return TunnelServiceContext.initResourceBundle();
    }

    private static synchronized ResourceBundle initResourceBundle() {
        if (m_rb != null) {
            return m_rb;
        }
        m_rb = ResourceBundle.getBundle(TUNNEL_SERVICE_RESOURCE_BUNDLE);
        return m_rb;
    }

    public static ResourceBundle getAdminResourceBundle() {
        if (m_rbAdmin != null) {
            return m_rbAdmin;
        }
        return TunnelServiceContext.initAdminResourceBundle();
    }

    private static synchronized ResourceBundle initAdminResourceBundle() {
        if (m_rbAdmin != null) {
            return m_rbAdmin;
        }
        Locale locale = Smi18n.SmGetAdminLocale();
        m_rbAdmin = ResourceBundle.getBundle(TUNNEL_SERVICE_RESOURCE_BUNDLE, locale);
        return m_rbAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] tunnel(long l, long l2, long l3, long l4, byte[] byArray, int n, long l5) {
        TunnelServiceContext tunnelServiceContext = null;
        String string = null;
        try {
            tunnelServiceContext = new TunnelServiceContext(l, l2, l3, l4, byArray, n, l5);
            string = tunnelServiceContext.getTunnelContext().getParameter();
            if (string == null || string.trim().length() == 0) {
                tunnelServiceContext.setErrorText(Smi18n.getTranslatedMessage((String)"SM-API-02001", (ResourceBundle)TunnelServiceContext.getAdminResourceBundle()));
                return null;
            }
            int n2 = string.indexOf(32);
            String string2 = n2 > 0 ? string.substring(0, n2) : string;
            TunnelService tunnelService = null;
            Hashtable hashtable = m_tunnelServices;
            synchronized (hashtable) {
                tunnelService = (TunnelService)m_tunnelServices.get(string2);
                if (tunnelService == null) {
                    tunnelService = (TunnelService)Class.forName(string2).newInstance();
                    m_tunnelServices.put(string2, tunnelService);
                    Logger.logInfo((ResourceBundle)TunnelServiceContext.getAdminResourceBundle(), (String)"SM-API-02005", (Object)string2);
                }
            }
            return tunnelService.tunnel(tunnelServiceContext);
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            Logger.logError((Object)stringWriter.toString());
            if (tunnelServiceContext != null) {
                tunnelServiceContext.setErrorText(throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
            }
            return null;
        }
    }

    private native void setErrorText(int var1, long var2, String var4) throws NativeCallbackError;

    static {
        System.loadLibrary(libName);
    }
}

