/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.policyserver.smapi;

import com.ca.smi18n.Smi18n;
import com.netegrity.policyserver.smapi.APIContext;
import com.netegrity.policyserver.smapi.ActiveExpression;
import com.netegrity.policyserver.smapi.NativeCallbackError;
import com.netegrity.policyserver.smapi.RequestContext;
import com.netegrity.policyserver.smapi.SMAPIFactory;
import com.netegrity.policyserver.smapi.SmAPIContextLogger;
import com.netegrity.policyserver.smapi.UserContext;
import com.netegrity.util.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class ActiveExpressionContext {
    private static final String ACTIVE_EXPRESSION_RESOURCE_BUNDLE = "activeExpression";
    private static final String ACTIVE_EXPRESSION_CHECKPOINT = "Active Expression Context";
    private APIContext m_APIContext;
    private UserContext m_UserContext;
    private RequestContext m_RequestContext;
    private int m_nBytesErrBuf;
    private long m_lpErrBuf;
    private SMAPIFactory m_factory = null;
    private static HashMap m_activeExpressions = new HashMap();
    private static ResourceBundle m_rb;
    private static ResourceBundle m_rbAdmin;
    private static final String libName = "smjavaapi";

    private ActiveExpressionContext(long l, long l2, long l3, int n, long l4, long l5, long l6) {
        this.m_APIContext = new SmAPIContextLogger(l);
        this.m_UserContext = new UserContext(l2);
        this.m_RequestContext = new RequestContext(l3);
        this.m_nBytesErrBuf = n;
        this.m_lpErrBuf = l4;
        this.m_factory = new SMAPIFactory(l5, l6);
    }

    public APIContext getAPIContext() {
        return this.m_APIContext;
    }

    public UserContext getUserContext() {
        return this.m_UserContext;
    }

    public RequestContext getRequestContext() {
        return this.m_RequestContext;
    }

    public SMAPIFactory getSMAPIFactory() {
        return this.m_factory;
    }

    public void setErrorText(String string) {
        if (this.m_lpErrBuf == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03003", (Object)"ActiveExpressionContext setErrorText", (Object)string);
        } else {
            this.setErrorText(this.m_nBytesErrBuf, this.m_lpErrBuf, string);
        }
    }

    private native void setErrorText(int var1, long var2, String var4) throws NativeCallbackError;

    public static ResourceBundle getResourceBundle() {
        if (m_rb != null) {
            return m_rb;
        }
        return ActiveExpressionContext.initResourceBundle();
    }

    private static synchronized ResourceBundle initResourceBundle() {
        if (m_rb != null) {
            return m_rb;
        }
        m_rb = ResourceBundle.getBundle(ACTIVE_EXPRESSION_RESOURCE_BUNDLE);
        return m_rb;
    }

    public static ResourceBundle getAdminResourceBundle() {
        if (m_rbAdmin != null) {
            return m_rbAdmin;
        }
        return ActiveExpressionContext.initAdminResourceBundle();
    }

    private static synchronized ResourceBundle initAdminResourceBundle() {
        if (m_rbAdmin != null) {
            return m_rbAdmin;
        }
        Locale locale = Smi18n.SmGetAdminLocale();
        m_rbAdmin = ResourceBundle.getBundle(ACTIVE_EXPRESSION_RESOURCE_BUNDLE, locale);
        return m_rbAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String invoke(long l, long l2, long l3, int n, long l4, long l5, long l6, String string) {
        ActiveExpressionContext activeExpressionContext = null;
        try {
            String string2;
            activeExpressionContext = new ActiveExpressionContext(l, l2, l3, n, l4, l5, l6);
            if (string == null || string.trim().length() == 0) {
                activeExpressionContext.setErrorText(Smi18n.getTranslatedMessage((String)"SM-API-03001", (ResourceBundle)ActiveExpressionContext.getAdminResourceBundle()));
                return null;
            }
            int n2 = string.indexOf(32);
            String string3 = null;
            if (n2 > 0) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
            } else {
                string2 = string;
            }
            ActiveExpression activeExpression = null;
            Cloneable cloneable = m_activeExpressions;
            synchronized (cloneable) {
                activeExpression = (ActiveExpression)m_activeExpressions.get(string2);
                if (activeExpression == null) {
                    activeExpression = (ActiveExpression)Class.forName(string2).newInstance();
                    activeExpression.init(activeExpressionContext.getAPIContext());
                    m_activeExpressions.put(string2, activeExpression);
                    Logger.logInfo((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03005", (Object)string2);
                }
            }
            cloneable = new Date();
            String string4 = activeExpression.invoke(activeExpressionContext, string3);
            Date date = new Date();
            double d = date.getTime() - ((Date)cloneable).getTime();
            Logger.logTrace((Object)ACTIVE_EXPRESSION_CHECKPOINT, (ResourceBundle)ActiveExpressionContext.getResourceBundle(), (String)"SM-API-03006", (Object)string2, (Object)new Double(d));
            return string4;
        }
        catch (Throwable throwable) {
            Logger.logErrorWithStackTrace((Throwable)throwable);
            if (activeExpressionContext != null) {
                activeExpressionContext.setErrorText(throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int release(long l) {
        HashMap hashMap = m_activeExpressions;
        synchronized (hashMap) {
            SmAPIContextLogger smAPIContextLogger = new SmAPIContextLogger(l);
            Enumeration enumeration = Collections.enumeration(m_activeExpressions.values());
            while (enumeration.hasMoreElements()) {
                ActiveExpression activeExpression = (ActiveExpression)enumeration.nextElement();
                if (activeExpression == null) continue;
                try {
                    activeExpression.release(smAPIContextLogger);
                }
                catch (Throwable throwable) {
                    Logger.logErrorWithStackTrace((Throwable)throwable);
                }
            }
        }
        return 0;
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = "";
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareToIgnoreCase("-silent") == 0) {
                bl = true;
            }
            if (stringArray[i].compareToIgnoreCase("-testfile") != 0) continue;
            string = stringArray[++i];
        }
        if (string.length() == 0) {
            System.out.println("Usage: ActiveExpressionContext [-silent] -testfile <filename>");
            System.out.println("Where:");
            System.out.println("\t-silent - limit output to only report failed tests");
            System.out.println("\t-testfile <filename> - read tests from <filename> which contains lines of the form");
            System.out.println("\t\t<classname and parameters> ! <expected output>");
            return;
        }
        if (bl) {
            Logger.setLogLevel((int)0);
        } else {
            Logger.setLogLevel((int)3);
        }
        System.out.println();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.length() == 0 || string2.startsWith("//")) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                int n3 = string2.indexOf(33);
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                string2 = bufferedReader.readLine();
                ++n;
                String string5 = null;
                if (!bl) {
                    System.out.println("Test #" + n + "\t\"" + string3 + "\"");
                    string5 = ActiveExpressionContext.invoke(0L, 0L, 0L, 0, 0L, 0L, 0L, string3);
                    if (string5 == null) {
                        string5 = "null";
                    }
                    System.out.println("\tExpected Result: \t\"" + string4 + "\"");
                    System.out.println("\tActual Result: \t\"" + string5 + "\"");
                    System.out.println();
                } else {
                    string5 = ActiveExpressionContext.invoke(0L, 0L, 0L, 0, 0L, 0L, 0L, string3);
                    if (string5 == null) {
                        string5 = "null";
                    }
                    if (string4.compareTo(string5) != 0) {
                        System.out.println("FAILED Test #" + n3 + "\t\"" + string3 + "\"");
                        System.out.println("\tExpected Result: \t\"" + string4 + "\"");
                        System.out.println("\tActual Result: \t\"" + string5 + "\"");
                        System.out.println();
                    }
                }
                if (string4.compareTo(string5) == 0) continue;
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logger.logErrorWithStackTrace((Throwable)iOException);
                }
            }
        }
        System.out.println("Completed " + n + " tests " + n2 + " failed");
    }

    static {
        System.loadLibrary(libName);
    }
}

