/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.policyserver.smapi;

import com.ca.smi18n.Smi18n;
import com.netegrity.policyserver.smapi.APIContext;
import com.netegrity.smerrlog.SmLogException;
import com.netegrity.smerrlog.SmLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class APIContextLogger
extends APIContext {
    protected boolean m_isInitialized = false;
    protected SmLogger m_logger = null;
    protected int m_componentId = -1;
    protected String m_transactionId = "";
    protected int m_infoId = -1;
    protected int m_errorId = -1;
    private static final String APICTXLOGGER_RESOURCE_BUNDLE = "apiContextLogger";
    private static ResourceBundle m_rb;
    private static ResourceBundle m_rbAdmin;

    protected APIContextLogger(long l) {
        super(l);
        try {
            this.m_logger = new SmLogger();
            this.m_isInitialized = true;
        }
        catch (SmLogException smLogException) {
            String string = Smi18n.getTranslatedMessage((String)"SM-API-01001", (ResourceBundle)APIContextLogger.getResourceBundle());
            this.trace("APIContextLogger", MessageFormat.format(string, smLogException.getMessage(), APIContextLogger.getStackTrace(smLogException)));
            string = Smi18n.getTranslatedMessage((String)"SM-API-01001", (ResourceBundle)APIContextLogger.getAdminResourceBundle());
            this.error(MessageFormat.format(string, smLogException.getMessage(), APIContextLogger.getStackTrace(smLogException)));
        }
        catch (Throwable throwable) {
            String string = Smi18n.getTranslatedMessage((String)"SM-API-01002", (ResourceBundle)APIContextLogger.getResourceBundle());
            this.trace("APIContextLogger", MessageFormat.format(string, APIContextLogger.getStackTrace(throwable)));
            string = Smi18n.getTranslatedMessage((String)"SM-API-01002", (ResourceBundle)APIContextLogger.getAdminResourceBundle());
            this.error(MessageFormat.format(string, APIContextLogger.getStackTrace(throwable)));
        }
    }

    protected void setTransactionId(String string) {
        if (null == this.m_transactionId) {
            this.m_transactionId = string;
        }
    }

    protected void setGenericErrorMessageId(int n) {
        if (-1 == this.m_errorId) {
            this.m_errorId = n;
        }
    }

    protected void setGenericInfoMessageId(int n) {
        if (-1 == this.m_infoId) {
            this.m_infoId = n;
        }
    }

    protected void setComponentId(int n) {
        this.m_componentId = n;
    }

    public void log(String string, String string2) {
        if (this.m_isInitialized) {
            this.m_logger.logMessage(string, this.m_infoId, string2);
        }
    }

    public void trace(String string, String string2, String string3) {
        if (this.m_isInitialized) {
            this.m_logger.traceMessage(string, string2, this.m_componentId, this.m_transactionId, string3);
        }
    }

    public void error(String string, String string2) {
        if (this.m_isInitialized) {
            this.m_logger.logMessage(string, this.m_errorId, string2);
        }
    }

    protected static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static ResourceBundle getResourceBundle() {
        if (m_rb != null) {
            return m_rb;
        }
        return APIContextLogger.initResourceBundle();
    }

    private static synchronized ResourceBundle initResourceBundle() {
        if (m_rb != null) {
            return m_rb;
        }
        m_rb = ResourceBundle.getBundle(APICTXLOGGER_RESOURCE_BUNDLE);
        return m_rb;
    }

    public static ResourceBundle getAdminResourceBundle() {
        if (m_rbAdmin != null) {
            return m_rbAdmin;
        }
        return APIContextLogger.initAdminResourceBundle();
    }

    public SmLogger getSMLogger() {
        return this.m_logger;
    }

    private static synchronized ResourceBundle initAdminResourceBundle() {
        if (m_rbAdmin != null) {
            return m_rbAdmin;
        }
        Locale locale = Smi18n.SmGetAdminLocale();
        m_rbAdmin = ResourceBundle.getBundle(APICTXLOGGER_RESOURCE_BUNDLE, locale);
        return m_rbAdmin;
    }
}

