/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.policyserver.smapi;

import com.ca.smi18n.Smi18n;
import com.netegrity.policyserver.smapi.ActiveExpressionContext;
import com.netegrity.policyserver.smapi.AppSpecificContext;
import com.netegrity.policyserver.smapi.NativeCallbackError;
import com.netegrity.util.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class APIContext {
    public static final int SM_API_VERSION_V3 = 768;
    public static final int SM_API_VERSION_V4 = 1024;
    public static final int SM_API_VERSION_V4_1 = 1025;
    private long m_lpApiContext;
    private AppSpecificContext m_appSpecificContext;
    private Map m_extConfig;

    protected APIContext(long l) {
        this.m_lpApiContext = l;
        this.m_extConfig = new HashMap(19);
        HashMap hashMap = new HashMap(19);
        this.m_extConfig.put("ATTR_MAP", hashMap);
    }

    public int getVersion() {
        if (this.m_lpApiContext == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03002", (Object)"APIContext getVersion");
            return -1;
        }
        return this.getVersion(this.m_lpApiContext);
    }

    public void log(String string) {
        if (this.m_lpApiContext == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03003", (Object)"APIContext log", (Object)string);
        } else {
            this.log(this.m_lpApiContext, string);
        }
    }

    public void trace(String string, String string2) {
        if (this.m_lpApiContext == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getResourceBundle(), (String)"SM-API-03004", (Object)"APIContext trace", (Object)string, (Object)string2);
        } else {
            this.trace(this.m_lpApiContext, string, string2);
        }
    }

    public void trace(String string, String string2, ResourceBundle resourceBundle, String string3) {
        if (this.m_lpApiContext == 0L) {
            String string4 = Smi18n.getTranslatedMessage((String)string3, (ResourceBundle)resourceBundle);
            Logger.logError((ResourceBundle)ActiveExpressionContext.getResourceBundle(), (String)"SM-API-03004", (Object)"APIContext trace", (Object)string, (Object)string4);
        } else {
            this.trace(this.m_lpApiContext, string, string2);
        }
    }

    public void error(String string) {
        if (this.m_lpApiContext == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03003", (Object)"APIContext error", (Object)string);
        } else {
            this.error(this.m_lpApiContext, string);
        }
    }

    public Map getAttrMap() {
        return (Map)this.m_extConfig.get("ATTR_MAP");
    }

    public AppSpecificContext getAppSpecificContext() {
        if (this.m_appSpecificContext == null) {
            if (this.m_lpApiContext == 0L) {
                Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03002", (Object)"APIContext getAppSpecificContext");
                this.m_appSpecificContext = new AppSpecificContext(0L);
            } else {
                this.m_appSpecificContext = new AppSpecificContext(this.getAppSpecificContext(this.m_lpApiContext));
            }
        }
        return this.m_appSpecificContext;
    }

    long getCptr() {
        return this.m_lpApiContext;
    }

    private native int getVersion(long var1) throws NativeCallbackError;

    private native void log(long var1, String var3) throws NativeCallbackError;

    private native void trace(long var1, String var3, String var4) throws NativeCallbackError;

    private native void error(long var1, String var3) throws NativeCallbackError;

    private native long getAppSpecificContext(long var1) throws NativeCallbackError;
}

