/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.util;

import com.netegrity.util.DataItem;
import com.netegrity.util.Utils;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.util.Arrays;

public class DigestSha256 {
    public static final int LENGTH = 32;
    private JSAFE_MessageDigest md;

    public DigestSha256() {
        try {
            this.md = JSAFE_MessageDigest.getInstance((String)"SHA256", (String)"Java");
        }
        catch (JSAFE_Exception e2) {
            this.md = null;
        }
    }

    public int getDigestSize() {
        return 32;
    }

    public byte[] getDigest(byte[] input) {
        byte[] hash = null;
        if (null != this.md) {
            try {
                this.md.digestInit();
                if (null != input) {
                    this.md.digestUpdate(input, 0, input.length);
                }
                hash = this.md.digestFinal();
            }
            catch (JSAFE_Exception th) {
                th.printStackTrace();
            }
            this.md.clearSensitiveData();
        }
        return hash;
    }

    public int getMultiDigest(DataItem[] input, byte[] output, int offset) {
        int result = 0;
        if (null != this.md && null != output && output.length >= offset + 32) {
            try {
                this.md.digestInit();
                if (null != input) {
                    for (int iter = 0; iter < input.length; ++iter) {
                        if (null == input[iter] || input[iter].isEmpty()) continue;
                        if (input[iter].isValid()) {
                            this.md.digestUpdate(input[iter].data, input[iter].offset, input[iter].length);
                            continue;
                        }
                        this.md.clearSensitiveData();
                        return 0;
                    }
                }
                result = this.md.digestFinal(output, offset);
            }
            catch (JSAFE_Exception th) {
                th.printStackTrace();
                result = 0;
            }
            this.md.clearSensitiveData();
        }
        return result;
    }

    public static byte[] getHMAC(byte[] macKey, byte[] input) {
        int theLength = 0;
        if (null != input) {
            theLength = input.length;
        }
        return DigestSha256.getHMAC(macKey, input, 0, theLength);
    }

    public static byte[] getHMAC(byte[] macKey, byte[] input, int offset, int inputLength) {
        if (null == input && inputLength > 0 || null != input && (offset < 0 || inputLength < 0 || offset + inputLength > input.length)) {
            return null;
        }
        byte[] hash = null;
        JSAFE_MAC HMACSHA256 = null;
        JSAFE_SecretKey theKey = null;
        try {
            HMACSHA256 = JSAFE_MAC.getInstance((String)"HMAC/SHA256", (String)"Java");
            theKey = HMACSHA256.getBlankKey();
            if (null != macKey) {
                theKey.setSecretKeyData(macKey, 0, macKey.length);
            }
            HMACSHA256.macInit(theKey, null);
            if (null != input && inputLength > 0) {
                HMACSHA256.macUpdate(input, offset, inputLength);
            }
            hash = HMACSHA256.macFinal();
        }
        catch (JSAFE_Exception th) {
            Utils.Zeroize(hash);
            hash = null;
        }
        if (null != theKey) {
            theKey.clearSensitiveData();
        }
        if (null != HMACSHA256) {
            HMACSHA256.clearSensitiveData();
        }
        return hash;
    }

    private static void dumpBuf(String tag, byte[] buf) {
        System.out.println(tag + " had " + Utils.toHexString(buf));
    }

    public static void main(String[] args) {
        DigestSha256 digester = new DigestSha256();
        String input = "1234567890abcdefghij1234567890klmnopqrst<and other text to fill out to 80 chars>";
        byte[] inputBytes = input.getBytes();
        byte[] expected = new byte[]{-12, 71, 50, -73, 88, 106, -49, -106, 114, 118, 67, -100, -99, -45, -27, 55, 44, -124, 90, 39, -2, -54, 40, -105, 103, -11, -109, -113, -18, -22, 46, -85};
        byte[] result = digester.getDigest(inputBytes);
        if (null == result) {
            System.out.println("simple digest error");
        } else if (!Arrays.equals(expected, result)) {
            System.out.println("  simple digest result not as expected:");
            DigestSha256.dumpBuf("  actual", result);
            DigestSha256.dumpBuf("expected", expected);
        } else {
            System.out.println("  simple digest test passed.");
        }
        byte[] macKey = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80};
        byte[] macInput = new byte[]{115, 101, 99, 114, 101, 116};
        byte[] expectedOutput = new byte[]{57, 65, 109, 52, 55, 121, 76, 107, 50, 107, 101, 84, 101, 67, 67, 110, 112, 80, 65, 73, 85, 83, 81, 72, 98, 87, 53, 69, 55, 66, 82, 121, 100, 49, 90, 109, 106, 57, 119, 117, 48, 65, 100, 110, 67, 82, 71, 84, 74, 84, 50, 90, 88, 65, 61, 61, 0};
        result = DigestSha256.getHMAC(macKey, macInput);
        if (null == result) {
            System.out.println("HMAC test error");
        } else if (!Arrays.equals(expected, result)) {
            System.out.println("  HMAC result not as expected:");
            DigestSha256.dumpBuf("  actual", result);
            DigestSha256.dumpBuf("expected", expectedOutput);
        } else {
            System.out.println("  HMAC test passed.");
        }
    }
}

