/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.tli;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import com.ca.siteminder.sdk.agentapi.resources.SmTliMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentPacket;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentSession;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTcpTransport;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliBuffer;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliException;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTransport;
import com.netegrity.util.AesKeyWrapper;
import com.netegrity.util.DeriveKey;
import com.netegrity.util.DigestSha256;
import com.netegrity.util.Fips140Mode;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ResourceBundle;

public class SmAgentTliSession
implements SmAgentSession,
SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentTliSession";
    public static final String CA_SM_DISABLE_FIPS_AUTOSEED = "CA_SM_USE_STATIC_FIPS_SEED";
    private static final int HELLO_UNWRAPPED_LEN = 105;
    private static final int HELLO_CONTRIB_LEN = 16;
    private static final int HANDSHAKE_READ_LENGTH = 18 + AesKeyWrapper.WrapResultSize(98);
    private static final int HELLO_AUTHENT_LEN = 16;
    private static final int HELLO_PSCONTRIB_LEN = 16;
    private static final int KEYMAT_WRAPPER_KEY_LEN = 16;
    public static final int RAD_AUTHENT_LEN = 16;
    private static final int WRAPPED_KEY_FORMAT_LENGTH = 84;
    private static final int RANDOM_CHAL_LENGTH = 8;
    private static final int SIZEOF_PACKET = 4;
    private static final int FOLD_COUNTER = 2;
    private static final int HASH_KEY_LENGTH = 32;
    private static final boolean EXPORTING = false;
    static final int VERSION_LENGTH = 2;
    static final int HASH_LENGTH = 16;
    static final int NONCE_LENGTH = 8;
    static final byte HELLO_MAJOR_VERSION = 4;
    static final byte HELLO_MINOR_VERSION = 5;
    static final byte HELLO_MINOR_VERSION_FIPS = 6;
    static final byte HELLO_MINOR_VERSION_MASK = 15;
    static final byte HELLO_FLAG_EXPORT = -128;
    static final byte HELLO_FLAG_RC2 = 64;
    static final byte ZERO_BYTE_FLAG = 0;
    static final byte MINOR_VERSION_MASK = 127;
    static final int AUTHENTICATOR_LENGTH = 16;
    static final int SESSION_KEY_LENGTH = 24;
    static final int IV_LENGTH = 8;
    static final int MIN_SERVER_HELLO_LENGTH = 94;
    static final int ACK_INIT_DATA = 8;
    static final int ACK_RANDOM_LENGTH = 24;
    static final int HANDSHAKE_TIMEOUT = 30000;
    static final int HANDSHAKE_KEYSTRENGTH = 128;
    static final int DOMESTIC_KEYSTRENGTH = 128;
    static final int EXPORT_KEYSTRENGTH = 56;
    protected static final String MESSAGES_CLASSNAME = SmTliMessages.getName();
    protected static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private SmAgentTcpTransport m_transport = null;
    private SmCryptoProvider m_cryptoProvider = null;
    private SmAgentTliBuffer m_tliBuffer;
    private String m_deviceName;
    private String m_sharedSecret;
    private byte[] m_newSharedSecret;
    private long m_newSharedSecretTimestamp;
    protected static JSAFE_SecureRandom m_randomGenerator = null;
    protected static String DISABLE_FIPS_AUTOSEED = System.getenv("CA_SM_USE_STATIC_FIPS_SEED");

    public SmAgentTliSession(String deviceName, String sharedSecret) {
        this.m_deviceName = deviceName;
        this.m_sharedSecret = sharedSecret;
        this.m_newSharedSecret = null;
        this.m_newSharedSecretTimestamp = -1L;
        this.m_tliBuffer = new SmAgentTliBuffer();
        Fips140Mode fipsMode = Fips140Mode.getFips140ModeObject();
        if (fipsMode.wantFips()) {
            try {
                SM_CONF_SHARED_SECRET.setFormat("{AES}");
            }
            catch (SmConfigException e2) {
                Util.display(2, CLASS_NAME, CLASS_NAME, "Exception - while setting AES_FORMAT for Shared Secret config attribute");
            }
        }
    }

    public void bindToTransport(SmAgentTransport tli) throws SmAgentTliException {
        SmAgentTcpTransport xport = null;
        if (!(tli instanceof SmAgentTcpTransport)) {
            Util.display(2, CLASS_NAME, "bindToTransport", "Unsupported transport");
            throw new SmAgentTliException(-1, c_bundle.getString("M_TRANSPORT_INVALID"));
        }
        xport = (SmAgentTcpTransport)tli;
        if (!xport.isConnected()) {
            Util.display(2, CLASS_NAME, "bindToTransport", "Transport not connected");
            throw new SmAgentTliException(-1, c_bundle.getString("M_TRANSPORT_INVALID"));
        }
        this.m_transport = xport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setup() throws IOException, SmAgentTliException {
        byte[] clearSharedSecret;
        byte[] devName;
        block21: {
            block22: {
                String methodName = "setup";
                Util.display(5, CLASS_NAME, "setup", "Initiating TLI handshake");
                devName = this.m_deviceName.toLowerCase().getBytes("UTF-8");
                clearSharedSecret = null;
                Exception decodeException = null;
                try {
                    Object var7_5;
                    try {
                        clearSharedSecret = SM_CONF_SHARED_SECRET.decrypt(this.m_sharedSecret).getBytes("UTF-8");
                    }
                    catch (Exception e2) {
                        decodeException = e2;
                        var7_5 = null;
                        if (decodeException != null) {
                            throw new SmAgentTliException(-1, c_bundle.getString("M_SHARED_SECRET_INVALID"), decodeException);
                        }
                        if (clearSharedSecret == null) {
                            throw new SmAgentTliException(-1, c_bundle.getString("M_SHARED_SECRET_INVALID"));
                        }
                        break block21;
                    }
                    var7_5 = null;
                    if (decodeException == null) break block22;
                    throw new SmAgentTliException(-1, c_bundle.getString("M_SHARED_SECRET_INVALID"), decodeException);
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    if (decodeException != null) {
                        throw new SmAgentTliException(-1, c_bundle.getString("M_SHARED_SECRET_INVALID"), decodeException);
                    }
                    if (clearSharedSecret != null) throw throwable;
                    throw new SmAgentTliException(-1, c_bundle.getString("M_SHARED_SECRET_INVALID"));
                }
            }
            if (clearSharedSecret == null) {
                throw new SmAgentTliException(-1, c_bundle.getString("M_SHARED_SECRET_INVALID"));
            }
        }
        Fips140Mode fipsMode = Fips140Mode.getFips140ModeObject();
        byte[] random_id = new byte[8];
        byte[] agentContrib = null;
        if (fipsMode.wantFips()) {
            agentContrib = this.startFipsSession(devName, clearSharedSecret, random_id);
        } else {
            this.startSession(devName, clearSharedSecret, random_id);
            agentContrib = new byte[16];
        }
        ByteBuffer inBuf = (ByteBuffer)this.m_tliBuffer.initialValue();
        int rc = this.m_transport.read(inBuf, 4, 30000L);
        if (rc != 4) {
            throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_READ_ERROR"));
        }
        int responseLen = inBuf.getInt();
        if (responseLen < 94) {
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_TRUNCATED"));
        }
        rc = this.m_transport.read(inBuf, responseLen, 30000L);
        if (rc != responseLen) {
            throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_READ_ERROR"));
        }
        Util.display(5, CLASS_NAME, "setup", "Received Server HELLO");
        byte data = inBuf.get();
        if (data != 4) {
            Util.display(2, CLASS_NAME, "setup", "Server HELLO major version invalid");
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_VERSION_INVALID"));
        }
        data = inBuf.get();
        int minorVersion = data & 0xF;
        if (minorVersion == 5) {
            if (fipsMode.isFipsOnlyMode()) {
                Util.display(2, CLASS_NAME, "setup", "Server HELLO minor version expected to be FIPS");
                throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_VERSION_INVALID"));
            }
            boolean bWeakCrypto = false;
            if ((data & 0xFFFFFF80) != 0) {
                bWeakCrypto = true;
            }
            boolean bUseRC2 = false;
            if ((data & 0x40) != 0) {
                bUseRC2 = true;
            }
            byte[] authenticator = new byte[16];
            inBuf.get(authenticator);
            int decryptLen = responseLen - 18;
            byte[] cryptData = new byte[decryptLen];
            inBuf.get(cryptData);
            inBuf.clear();
            this.establishSession(cryptData, decryptLen, authenticator, clearSharedSecret, devName, random_id, bUseRC2, bWeakCrypto);
        } else {
            if (minorVersion != 6) {
                Util.display(2, CLASS_NAME, "setup", "Server HELLO minor version invalid");
                throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_VERSION_INVALID"));
            }
            this.establishFipsSession(inBuf, clearSharedSecret, devName, random_id, agentContrib);
        }
        this.m_transport.setupDataChannel();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] startFipsSession(byte[] deviceName, byte[] sharedSecret, byte[] random_id) throws SmAgentTliException {
        String methodName = "startFipsSession";
        try {
            if (DISABLE_FIPS_AUTOSEED == null || m_randomGenerator == null) {
                m_randomGenerator = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"FIPS186Random", (String)"Java");
                m_randomGenerator.autoseed();
            }
            m_randomGenerator.generateRandomBytes(random_id, 0, random_id.length);
        }
        catch (Exception e2) {
            Util.display(2, CLASS_NAME, "startFipsSession", "random generator error");
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_RANDOMGEN_ERROR"), e2);
        }
        byte[] hello = this.makeFipsHelloMessage(sharedSecret, deviceName, random_id);
        ByteBuffer outBuf = null;
        try {
            try {
                outBuf = (ByteBuffer)this.m_tliBuffer.initialValue();
                outBuf.putInt(0);
                int pktDataStart = outBuf.position();
                outBuf.put(hello);
                outBuf.flip();
                outBuf.putInt(0, outBuf.limit() - pktDataStart);
                Util.display(5, CLASS_NAME, "startFipsSession", "Sending FIPS Client HELLO packet");
                int rc = this.m_transport.write(outBuf);
                if (rc != outBuf.limit()) {
                    Util.display(5, CLASS_NAME, "startFipsSession", "Hello Write Error");
                    throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_WRITE_ERROR"));
                }
                Object var10_11 = null;
                if (null == outBuf) return hello;
            }
            catch (IOException ioe) {
                Util.display(2, CLASS_NAME, "startFipsSession", "Exception - while sending Client HELLO packet");
                throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_WRITE_ERROR"));
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (null == outBuf) throw throwable;
            Arrays.fill(outBuf.array(), (byte)0);
            outBuf.clear();
            throw throwable;
        }
        Arrays.fill(outBuf.array(), (byte)0);
        outBuf.clear();
        return hello;
    }

    private byte[] makeFipsHelloMessage(byte[] sharedSecret, byte[] deviceName, byte[] random_id) throws SmAgentTliException {
        String methodName = "startFipsSession";
        int helloLength = 19 + deviceName.length + 8 + 16;
        byte[] hello = new byte[helloLength];
        int nextByte = 0;
        try {
            m_randomGenerator.generateRandomBytes(hello, nextByte, 16);
        }
        catch (Exception e2) {
            Util.display(5, CLASS_NAME, "startFipsSession", "random generator error");
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_RANDOMGEN_ERROR"));
        }
        hello[nextByte += 16] = 4;
        hello[++nextByte] = 6;
        hello[++nextByte] = (byte)deviceName.length;
        SmAgentTliSession.memcpy(deviceName, 0, hello, ++nextByte, deviceName.length);
        int authDataLength = nextByte += deviceName.length;
        SmAgentTliSession.memcpy(random_id, 0, hello, nextByte, 8);
        nextByte += 8;
        byte[] authTemp = null;
        byte[] authKey = new byte[]{0, 0};
        byte[] myHMAC = null;
        JSAFE_MessageDigest SHA256 = null;
        try {
            SHA256 = JSAFE_MessageDigest.getInstance((String)"SHA256", (String)"Java");
            SHA256.digestInit();
            SHA256.digestUpdate(sharedSecret, 0, sharedSecret.length);
            authTemp = SHA256.digestFinal();
            SHA256.clearSensitiveData();
            SHA256 = null;
            if (null == authTemp || 32 != authTemp.length) {
                Util.display(5, CLASS_NAME, "startFipsSession", "crypto key failure - hashing the shared secret");
                throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_KEY_ERROR"));
            }
            authKey[0] = (byte)(authTemp[0] ^ authTemp[16]);
            authKey[1] = (byte)(authTemp[1] ^ authTemp[17]);
            SmAgentTliSession.memset(authTemp, (byte)0);
            authTemp = null;
            myHMAC = DigestSha256.getHMAC(authKey, hello, 0, authDataLength);
            authKey[0] = 0;
            authKey[1] = 0;
            if (null == myHMAC || 32 > myHMAC.length) {
                if (null != myHMAC) {
                    SmAgentTliSession.memset(myHMAC, (byte)0);
                    myHMAC = null;
                }
                Util.display(5, CLASS_NAME, "startFipsSession", "crypto key failure - generating HMAC");
                throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_KEY_ERROR"));
            }
            int hmacOut = myHMAC.length / 2;
            if (hmacOut > 16) {
                hmacOut = 16;
            }
            for (int iter = 0; iter < hmacOut; ++iter) {
                hello[nextByte++] = (byte)(myHMAC[iter] ^ myHMAC[iter + hmacOut]);
                myHMAC[iter] = 0;
                myHMAC[iter + hmacOut] = 0;
            }
            myHMAC = null;
        }
        catch (JSAFE_Exception e3) {
            if (null != SHA256) {
                SHA256.clearSensitiveData();
                SHA256 = null;
            }
            if (null != authKey) {
                SmAgentTliSession.memset(authKey, (byte)0);
                authKey = null;
            }
            if (null != myHMAC) {
                SmAgentTliSession.memset(myHMAC, (byte)0);
                myHMAC = null;
            }
            Util.display(5, CLASS_NAME, "startFipsSession", "crypto key failure - fold the HMAC into the output buffer");
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_KEY_ERROR"));
        }
        return hello;
    }

    private byte[] readFipsHelloResponse(byte[] whereFrom, int fromLength, byte[] sharedSecret, byte[] deviceName, byte[] random_id, byte[] contrib, int contribLength) throws SmAgentTliException {
        String methodName = "readFipsHelloResponse";
        int wrappedOffset = 16;
        int nssLength = 4;
        byte[] contribPS = new byte[16];
        SmAgentTliSession.memcpy(whereFrom, 0, contribPS, 0, contribPS.length);
        byte[] wrappingKey = DeriveKey.Fips140(DeriveKey.DerivationType.FIPS140_TLIAES, 16, sharedSecret, sharedSecret.length, contrib, contribLength, contribPS, contribPS.length, null, 0);
        if (16 > wrappingKey.length) {
            Util.display(5, CLASS_NAME, "readFipsHelloResponse", "Encryption Key Failure - while getting wrapping key");
            throw new SmAgentTliException(-1, c_bundle.getString("M_ENCRYPTION_KEY_ERROR"));
        }
        boolean status = false;
        byte[] unwrappedBuf = null;
        AesKeyWrapper keyUnwrapper = null;
        try {
            keyUnwrapper = new AesKeyWrapper(wrappingKey);
            SmAgentTliSession.memset(wrappingKey, (byte)0);
            unwrappedBuf = keyUnwrapper.Unwrap(whereFrom, wrappedOffset, fromLength - wrappedOffset);
        }
        catch (Throwable th) {
            if (null != keyUnwrapper) {
                keyUnwrapper.clearSensitiveData();
            }
            Util.display(5, CLASS_NAME, "readFipsHelloResponse", "Key Unwrap Failure");
            throw new SmAgentTliException(-1, c_bundle.getString("M_KEY_UNWRAP_ERROR"));
        }
        if (null != keyUnwrapper) {
            keyUnwrapper.clearSensitiveData();
            keyUnwrapper = null;
        }
        if (null == unwrappedBuf || unwrappedBuf.length < 105) {
            Util.display(5, CLASS_NAME, "readFipsHelloResponse", "Key Unwrap Failure");
            throw new SmAgentTliException(-1, c_bundle.getString("M_KEY_UNWRAP_ERROR"));
        }
        if (0 != unwrappedBuf[0]) {
            Util.display(5, CLASS_NAME, "readFipsHelloResponse", "Unable to initiate session");
            if (unwrappedBuf.length > 105) {
                Arrays.fill(unwrappedBuf, (byte)0);
                unwrappedBuf = null;
            }
            throw new SmAgentTliException(-1, c_bundle.getString("M_INIT_SESSION_ERROR"));
        }
        if (unwrappedBuf.length >= 105 + nssLength) {
            int newSecretLen = unwrappedBuf[101] << 24 | (unwrappedBuf[102] & 0xFF) << 16 | (unwrappedBuf[103] & 0xFF) << 8 | unwrappedBuf[104] & 0xFF;
            if (105 + nssLength + newSecretLen > unwrappedBuf.length) {
                Arrays.fill(unwrappedBuf, (byte)0);
                unwrappedBuf = null;
                Util.display(2, CLASS_NAME, "readFipsHelloResponse", "Server HELLO malformed");
                throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_SECRET_INVALID"));
            }
            int nssTimeStamp = 4;
            this.m_newSharedSecretTimestamp = ((long)unwrappedBuf[105] & 0xFFL) << 24 | ((long)unwrappedBuf[106] & 0xFFL) << 16 | ((long)unwrappedBuf[107] & 0xFFL) << 8 | (long)unwrappedBuf[108] & 0xFFL;
            this.m_newSharedSecret = new byte[newSecretLen];
            SmAgentTliSession.memcpy(unwrappedBuf, 105 + nssTimeStamp, this.m_newSharedSecret, 0, newSecretLen);
            Arrays.fill(unwrappedBuf, 101, unwrappedBuf.length - 1, (byte)0);
            unwrappedBuf = null;
        }
        byte[] ps_challenge = new byte[8];
        byte[] received_random = new byte[8];
        SmAgentTliSession.memcpy(unwrappedBuf, 85, ps_challenge, 0, ps_challenge.length);
        SmAgentTliSession.memcpy(unwrappedBuf, 93, received_random, 0, received_random.length);
        if (!SmAgentTliSession.comparebytes(received_random, random_id, received_random.length)) {
            Util.display(5, CLASS_NAME, "readFipsHelloResponse", "Unable to initiate session");
            throw new SmAgentTliException(-1, c_bundle.getString("M_INIT_SESSION_ERROR"));
        }
        try {
            this.m_cryptoProvider = SmCryptoProvider.getInstance("AES-TLI", "", true);
            int keyStrength = 128;
            if ((whereFrom[1] & 0xFFFFFF80) != 0) {
                keyStrength = 40;
            }
            try {
                this.m_cryptoProvider.init(unwrappedBuf, keyStrength);
            }
            catch (SmCryptoProviderException e2) {
                Util.display(5, CLASS_NAME, "readFipsHelloResponse", "Unable to initiate session");
                throw new SmAgentTliException(-1, c_bundle.getString("M_INIT_SESSION_ERROR"));
            }
            SmAgentTliSession.memset(unwrappedBuf, (byte)0);
        }
        catch (Exception e3) {
            Util.display(5, CLASS_NAME, "readFipsHelloResponse", "Encryption Key Failure");
            throw new SmAgentTliException(-1, c_bundle.getString("M_ENCRYPTION_KEY_ERROR"));
        }
        int prePSChallengeLength = 16;
        int postPSChallengeLength = 8;
        int nBytes = prePSChallengeLength + 16 + postPSChallengeLength;
        byte[] ourResponse = new byte[nBytes];
        ByteBuffer ackBuf = ByteBuffer.wrap(ourResponse);
        ackBuf.putShort((short)4);
        ackBuf.putShort((short)6);
        ackBuf.putInt(1536);
        byte[] ackRandom = new byte[24];
        try {
            if (DISABLE_FIPS_AUTOSEED == null || m_randomGenerator == null) {
                m_randomGenerator = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"FIPS186Random", (String)"Java");
                m_randomGenerator.autoseed();
            }
            m_randomGenerator.generateRandomBytes(ackRandom, 0, 24);
        }
        catch (Exception e4) {
            Util.display(5, CLASS_NAME, "readFipsHelloResponse", "random generator failure");
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_RANDOMGEN_ERROR"));
        }
        ackBuf.put(ackRandom);
        for (int ct2 = 0; ct2 < ps_challenge.length; ct2 += 2) {
            int n2 = ct2;
            ps_challenge[n2] = (byte)(ps_challenge[n2] ^ 0xFFFFFFCC);
        }
        ackBuf.put(ps_challenge);
        byte[] togoBuf = null;
        try {
            togoBuf = this.m_cryptoProvider.encrypt(ourResponse, nBytes);
        }
        catch (Throwable e5) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "readFipsHelloResponse", "Error encrypting TLI packet: " + e5);
            }
            throw new SmAgentTliException(-1, c_bundle.getString("M_PACKET_ENCRYPT_ERROR"), e5);
        }
        if (null == togoBuf) {
            Util.display(2, CLASS_NAME, "readFipsHelloResponse", "Error encrypting TLI packet: Unknown error");
            throw new SmAgentTliException(-1, c_bundle.getString("M_PACKET_ENCRYPT_ERROR"));
        }
        return togoBuf;
    }

    public SmAgentPacket read() throws IOException, SmAgentTliException {
        return this.read(0L);
    }

    public SmAgentPacket read(long timeout) throws IOException, SmAgentTliException {
        String methodName = "read";
        if (null == this.m_cryptoProvider) {
            Util.display(2, CLASS_NAME, "read", "No crypto provider set");
            throw new SmAgentTliException(-1, c_bundle.getString("M_NO_CRYPTO_PROVIDER"));
        }
        ByteBuffer inBuf = (ByteBuffer)this.m_tliBuffer.initialValue();
        inBuf.clear();
        int rc = this.m_transport.read(inBuf, 4, timeout);
        if (rc != 4) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "read", "Error reading TLI packet length - instead of 4 got " + rc);
            }
            throw new SmAgentTliException(-2, c_bundle.getString("M_PACKET_READ_ERROR"));
        }
        int pktLen = inBuf.getInt();
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "read", "Expecting to read packet size = " + pktLen);
        }
        if (pktLen == 0) {
            Util.display(2, CLASS_NAME, "read", "Told to read TLI packet length of 0");
            throw new SmAgentTliException(-1, c_bundle.getString("M_PACKET_READ_ERROR"));
        }
        if (inBuf.capacity() < pktLen && pktLen <= 0x8000010) {
            this.m_tliBuffer.set(ByteBuffer.allocate(pktLen));
            inBuf = (ByteBuffer)this.m_tliBuffer.get();
            Arrays.fill(inBuf.array(), (byte)0);
        }
        inBuf.clear();
        rc = this.m_transport.read(inBuf, pktLen, timeout);
        if (rc != pktLen) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "read", "Error reading TLI packet. Received " + rc + " bytes instead of " + pktLen);
            }
            throw new SmAgentTliException(-2, c_bundle.getString("M_PACKET_READ_ERROR"));
        }
        byte[] pktData = null;
        byte[] cryptData = null;
        if (inBuf.hasArray()) {
            cryptData = inBuf.array();
        } else {
            cryptData = new byte[pktLen];
            System.arraycopy(inBuf.array(), 0, cryptData, 0, pktLen);
        }
        try {
            pktData = this.m_cryptoProvider.decrypt(cryptData, pktLen);
        }
        catch (Throwable e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "read", "Error decrypting TLI packet: " + e2);
            }
            throw new SmAgentTliException(-1, c_bundle.getString("M_PACKET_READ_ERROR"), e2);
        }
        inBuf.clear();
        if (null == pktData) {
            Util.display(2, CLASS_NAME, "read", "Error decrypting TLI packet: Unknown error");
            throw new SmAgentTliException(-1, c_bundle.getString("M_PACKET_READ_ERROR"));
        }
        return new SmAgentTliPacket(ByteBuffer.wrap(pktData));
    }

    public int write(SmAgentPacket pkt) throws IOException, SmAgentTliException {
        return this.write(pkt, 0L);
    }

    public int write(SmAgentPacket pkt, long timeout) throws IOException, SmAgentTliException {
        String methodName = "write";
        if (null == this.m_cryptoProvider) {
            Util.display(2, CLASS_NAME, "write", "No crypto provider set");
            throw new SmAgentTliException(-1, c_bundle.getString("M_NO_CRYPTO_PROVIDER"));
        }
        ByteBuffer dataBuf = pkt.getData();
        byte[] clearData = null;
        if (dataBuf.hasArray()) {
            clearData = dataBuf.array();
        } else {
            clearData = new byte[dataBuf.limit()];
            dataBuf.get(clearData, 0, clearData.length);
        }
        byte[] cryptData = null;
        try {
            cryptData = this.m_cryptoProvider.encrypt(clearData, dataBuf.limit());
        }
        catch (Throwable e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "write", "Error encrypting TLI packet: " + e2);
            }
            throw new SmAgentTliException(-1, c_bundle.getString("M_PACKET_ENCRYPT_ERROR"), e2);
        }
        if (null == cryptData) {
            Util.display(2, CLASS_NAME, "write", "Error encrypting TLI packet: Unknown error");
            throw new SmAgentTliException(-1, c_bundle.getString("M_PACKET_ENCRYPT_ERROR"));
        }
        int outCount = 4 + cryptData.length;
        ByteBuffer outBuf = (ByteBuffer)this.m_tliBuffer.initialValue();
        if (outBuf.capacity() < outCount) {
            if (outCount <= 0x8000010) {
                this.m_tliBuffer.set(ByteBuffer.allocate(outCount));
                outBuf = (ByteBuffer)this.m_tliBuffer.get();
            }
            if (outBuf.capacity() < outCount) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "write", "TLI write buffer could not hold " + outCount + " bytes.");
                }
                throw new SmAgentTliException(-2, c_bundle.getString("M_PACKET_WRITE_ERROR"));
            }
        }
        outBuf.clear();
        outBuf.putInt(cryptData.length);
        outBuf.put(cryptData);
        outBuf.flip();
        int bytesWritten = this.m_transport.write(outBuf, timeout);
        if (bytesWritten != outCount) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "write", "Failed to write entire packet, #bytes written = " + bytesWritten);
            }
            throw new SmAgentTliException(-2, c_bundle.getString("M_PACKET_WRITE_ERROR"));
        }
        return cryptData.length;
    }

    public void teardown() throws IOException {
        this.m_transport.disconnect();
    }

    public byte[] getAndClearNewSharedSecret() {
        if (this.m_newSharedSecret == null) {
            return null;
        }
        byte[] newSecretCopy = new byte[this.m_newSharedSecret.length];
        System.arraycopy(this.m_newSharedSecret, 0, newSecretCopy, 0, this.m_newSharedSecret.length);
        Arrays.fill(this.m_newSharedSecret, (byte)0);
        this.m_newSharedSecretTimestamp = -1L;
        this.m_newSharedSecret = null;
        return newSecretCopy;
    }

    public long getNewSharedSecretTimestamp() {
        return this.m_newSharedSecretTimestamp;
    }

    public static final void memcpy(byte[] from, byte[] to, int length) {
        System.arraycopy(from, 0, to, 0, length);
    }

    public static final void memcpy(Object from, int fromStarting, Object to, int toStarting, int length) {
        System.arraycopy(from, fromStarting, to, toStarting, length);
    }

    public static final void memset(byte[] where, byte what, int howmany) {
        if (howmany > where.length) {
            howmany = where.length;
        }
        for (int i2 = 0; i2 < howmany; ++i2) {
            where[i2] = what;
        }
    }

    public static final void memset(byte[] where, byte what) {
        int howmany = where.length;
        for (int i2 = 0; i2 < howmany; ++i2) {
            where[i2] = what;
        }
    }

    public static boolean comparebytes(byte[] a, byte[] b2, int length) {
        if (a.length < length || b2.length < length) {
            return false;
        }
        int n2 = 0;
        while (n2 < length) {
            if (a[n2] == b2[n2++]) continue;
            return false;
        }
        return true;
    }

    public byte[] startSession(byte[] devName, byte[] sharedSecret, byte[] random_id) throws SmAgentTliException {
        String methodName = "startSession";
        ByteBuffer outBuf = null;
        byte[] hashData = new byte[sharedSecret.length + devName.length];
        System.arraycopy(sharedSecret, 0, hashData, 0, sharedSecret.length);
        System.arraycopy(devName, 0, hashData, sharedSecret.length, devName.length);
        byte[] hash = null;
        try {
            hash = SmCryptoProvider.digest(hashData, "MD5");
        }
        catch (Throwable e2) {
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_HASH_ERROR"), e2);
        }
        if (null == hash) {
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_HASH_ERROR"));
        }
        if (16 != hash.length) {
            Arrays.fill(hash, (byte)0);
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_HASH_INVALID"));
        }
        if (random_id == null) {
            Util.display(5, CLASS_NAME, "startSession", "Random Key found to be null");
            throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_RANDOMGEN_ERROR"));
        }
        SmSecureRandom.nextBytes(random_id);
        outBuf = (ByteBuffer)this.m_tliBuffer.initialValue();
        outBuf.putInt(0);
        int pktDataStart = outBuf.position();
        outBuf.put(hash);
        outBuf.put((byte)4);
        outBuf.put((byte)5);
        outBuf.put((byte)devName.length);
        outBuf.put(devName);
        outBuf.put(random_id);
        outBuf.flip();
        outBuf.putInt(0, outBuf.limit() - pktDataStart);
        Util.display(5, CLASS_NAME, "startSession", "Sending Client HELLO packet");
        try {
            try {
                int rc = this.m_transport.write(outBuf);
                if (rc != outBuf.limit()) {
                    Arrays.fill(outBuf.array(), (byte)0);
                    outBuf.clear();
                    throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_WRITE_ERROR"));
                }
                Object var11_12 = null;
            }
            catch (IOException ioe) {
                Util.display(5, CLASS_NAME, "startSession", "Exception - while sending Client HELLO Response");
                throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_WRITE_ERROR"));
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            Arrays.fill(hash, (byte)0);
            Arrays.fill(outBuf.array(), (byte)0);
            outBuf.clear();
            throw throwable;
        }
        Arrays.fill(hash, (byte)0);
        Arrays.fill(outBuf.array(), (byte)0);
        outBuf.clear();
        return null;
    }

    private boolean establishSession(byte[] cryptData, int decryptLen, byte[] authenticator, byte[] sharedSecret, byte[] deviceName, byte[] random_id, boolean bUseRC2, boolean bWeakCrypto) throws SmAgentTliException {
        String methodName = "establishSession";
        Util.display(5, CLASS_NAME, "establishSession", "Server HELLO minor version non FIPS");
        byte[] responsePreKey = new byte[sharedSecret.length + 16];
        System.arraycopy(sharedSecret, 0, responsePreKey, 0, sharedSecret.length);
        System.arraycopy(authenticator, 0, responsePreKey, sharedSecret.length, authenticator.length);
        Arrays.fill(sharedSecret, (byte)0);
        sharedSecret = null;
        SmCryptoProvider tmpRC2Provider = null;
        Util.display(5, CLASS_NAME, "establishSession", "Getting RC2 provider");
        try {
            tmpRC2Provider = SmCryptoProvider.getInstance("RC2", "SHA1", false);
        }
        catch (Throwable e2) {
            Util.display(2, CLASS_NAME, "establishSession", "Unable to get TLI provider");
            throw new SmAgentTliException(-1, c_bundle.getString("M_NO_CRYPTO_PROVIDER"), e2);
        }
        if (null == tmpRC2Provider) {
            Util.display(2, CLASS_NAME, "establishSession", "Unable to get TLI provider");
            throw new SmAgentTliException(-1, c_bundle.getString("M_NO_CRYPTO_PROVIDER"));
        }
        Util.display(5, CLASS_NAME, "establishSession", "Got RC2 provider");
        byte[] rc2iv = new byte[8];
        System.arraycopy(authenticator, authenticator.length - rc2iv.length, rc2iv, 0, rc2iv.length);
        Util.display(5, CLASS_NAME, "establishSession", "Initializing RC2 provider");
        try {
            tmpRC2Provider.init(responsePreKey, responsePreKey, rc2iv, 128, false);
        }
        catch (Throwable e3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "establishSession", "Unable to get TLI provider: " + e3);
            }
            Arrays.fill(responsePreKey, (byte)0);
            responsePreKey = null;
            throw new SmAgentTliException(-1, c_bundle.getString("M_NO_CRYPTO_PROVIDER"), e3);
        }
        Util.display(5, CLASS_NAME, "establishSession", "Initialized RC2 provider");
        Arrays.fill(responsePreKey, (byte)0);
        responsePreKey = null;
        byte[] responseData = null;
        Util.display(5, CLASS_NAME, "establishSession", "Decrypting Server HELLO");
        try {
            responseData = tmpRC2Provider.decrypt(cryptData);
        }
        catch (Throwable e4) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "establishSession", "Unable to decrypt server HELLO: " + e4);
            }
            tmpRC2Provider = null;
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_DECRYPT_ERROR"), e4);
        }
        Util.display(5, CLASS_NAME, "establishSession", "Decrypted Server HELLO");
        tmpRC2Provider = null;
        if (null == responseData) {
            Util.display(2, CLASS_NAME, "establishSession", "Unable to decrypt server HELLO");
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_DECRYPT_ERROR"));
        }
        ByteBuffer responseBuf = ByteBuffer.wrap(responseData);
        Util.display(5, CLASS_NAME, "establishSession", "Parsing Server HELLO");
        byte[] encSessionKey = new byte[24];
        responseBuf.get(encSessionKey);
        byte[] decSessionKey = new byte[24];
        responseBuf.get(decSessionKey);
        byte[] sessionInitVector = new byte[8];
        responseBuf.get(sessionInitVector);
        byte[] serverNonce = new byte[8];
        responseBuf.get(serverNonce);
        byte[] clientNonceReplay = new byte[8];
        responseBuf.get(clientNonceReplay);
        if (!Arrays.equals(random_id, clientNonceReplay)) {
            Arrays.fill(responseData, (byte)0);
            Util.display(2, CLASS_NAME, "establishSession", "Server HELLO does not authenticate");
            throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_CNONCE_INVALID"));
        }
        int newSecretLen = responseBuf.getInt();
        if (newSecretLen != 0) {
            if (decryptLen - responseBuf.position() < newSecretLen + 4) {
                Arrays.fill(responseData, (byte)0);
                Util.display(2, CLASS_NAME, "establishSession", "Server HELLO malformed");
                throw new SmAgentTliException(-1, c_bundle.getString("M_HELLO_SECRET_INVALID"));
            }
            this.m_newSharedSecretTimestamp = responseBuf.getInt();
            this.m_newSharedSecret = new byte[newSecretLen];
            responseBuf.get(this.m_newSharedSecret);
        }
        Util.display(5, CLASS_NAME, "establishSession", "Instantiating negotiated crypto provider");
        Arrays.fill(responseData, (byte)0);
        responseData = null;
        responseBuf = null;
        try {
            this.m_cryptoProvider = bUseRC2 ? SmCryptoProvider.getInstance("RC2", null, false) : SmCryptoProvider.getInstance("RC4/SHA", null, false);
        }
        catch (Throwable e5) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "establishSession", "Unable to instantiate negotiated crypto provider: " + e5);
            }
            throw new SmAgentTliException(-1, c_bundle.getString("M_NO_CRYPTO_PROVIDER"), e5);
        }
        Util.display(5, CLASS_NAME, "establishSession", "Initializing negotiated crypto provider");
        bWeakCrypto = false;
        try {
            if (!bUseRC2) {
                this.m_cryptoProvider.init(encSessionKey, decSessionKey, sessionInitVector, bWeakCrypto ? 56 : 128, false);
            } else {
                this.m_cryptoProvider.init(encSessionKey, encSessionKey, sessionInitVector, bWeakCrypto ? 56 : 128, false);
            }
        }
        catch (Throwable e6) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "establishSession", "Unable to initialize negotiated crypto provider: " + e6);
            }
            throw new SmAgentTliException(-1, c_bundle.getString("M_NO_CRYPTO_PROVIDER"), e6);
        }
        Util.display(5, CLASS_NAME, "establishSession", "Generating client ACK");
        SmSecureRandom.setSeed(encSessionKey);
        byte[] clearAck = new byte[40];
        ByteBuffer ackBuf = ByteBuffer.wrap(clearAck);
        ackBuf.putShort((short)4);
        ackBuf.putShort((short)5);
        ackBuf.putInt(1536);
        byte[] ackRandom = new byte[24];
        SmSecureRandom.nextBytes(ackRandom);
        ackBuf.put(ackRandom);
        for (int i2 = 0; i2 < serverNonce.length; i2 += 2) {
            int n2 = i2;
            serverNonce[n2] = (byte)(serverNonce[n2] ^ 0xFFFFFFCC);
        }
        ackBuf.put(serverNonce);
        byte[] ackData = null;
        try {
            ackData = this.m_cryptoProvider.encrypt(clearAck);
        }
        catch (Throwable e7) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "establishSession", "Unable to encrypt client ACK: " + e7);
            }
            throw new SmAgentTliException(-1, c_bundle.getString("M_ACK_ENCRYPT_ERROR"), e7);
        }
        if (null == ackData) {
            Util.display(2, CLASS_NAME, "establishSession", "Unable to encrypt client ACK: Unknown error");
            throw new SmAgentTliException(-1, c_bundle.getString("M_ACK_ENCRYPT_ERROR"));
        }
        Util.display(5, CLASS_NAME, "establishSession", "Sending client ACK");
        ByteBuffer outBuf = (ByteBuffer)this.m_tliBuffer.initialValue();
        outBuf.clear();
        outBuf.putInt(ackData.length);
        outBuf.put(ackData);
        outBuf.flip();
        try {
            int rc = this.m_transport.write(outBuf);
            boolean bWriteErr = rc != outBuf.limit();
            Arrays.fill(outBuf.array(), (byte)0);
            outBuf.clear();
            Arrays.fill(ackBuf.array(), (byte)0);
            ackBuf.clear();
            if (bWriteErr) {
                Util.display(2, CLASS_NAME, "establishSession", "Error sending client ACK");
                throw new SmAgentTliException(-1, c_bundle.getString("M_ACK_WRITE_ERROR"));
            }
            Util.display(5, CLASS_NAME, "establishSession", "TLI handshake complete");
        }
        catch (IOException ioe) {
            Util.display(5, CLASS_NAME, "establishSession", "Exception - while sending Client HELLO Response");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean establishFipsSession(ByteBuffer inBuf, byte[] sharedSecret, byte[] deviceName, byte[] random_id, byte[] contrib) throws SmAgentTliException {
        String methodName = "establishFipsSession";
        if (random_id == null) {
            Util.display(5, CLASS_NAME, "establishFipsSession", "Random Key found to be null");
            throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_RANDOMGEN_ERROR"));
        }
        ByteBuffer inputBuff = (ByteBuffer)this.m_tliBuffer.initialValue();
        try {
            try {
                byte[] response = new byte[inBuf.remaining()];
                inBuf.get(response);
                byte[] further = this.readFipsHelloResponse(response, response.length, sharedSecret, deviceName, random_id, contrib, 16);
                inputBuff.clear();
                inputBuff.putInt(further.length);
                inputBuff.put(further);
                inputBuff.flip();
                Util.display(5, CLASS_NAME, "establishFipsSession", "Sending Client HELLO Response");
                int rc = this.m_transport.write(inputBuff);
                if (rc != inputBuff.limit()) {
                    Util.display(5, CLASS_NAME, "establishFipsSession", "Hello Write Error - Sending Client HELLO Response");
                    throw new SmAgentTliException(-2, c_bundle.getString("M_HELLO_WRITE_ERROR"));
                }
                Object var12_13 = null;
                if (inputBuff == null) return true;
            }
            catch (IOException ioe) {
                Util.display(5, CLASS_NAME, "establishFipsSession", "Exception - while sending Client HELLO Response");
                boolean bl2 = false;
                Object var12_14 = null;
                if (inputBuff == null) return bl2;
                Arrays.fill(inputBuff.array(), (byte)0);
                inputBuff.clear();
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (inputBuff == null) throw throwable;
            Arrays.fill(inputBuff.array(), (byte)0);
            inputBuff.clear();
            throw throwable;
        }
        Arrays.fill(inputBuff.array(), (byte)0);
        inputBuff.clear();
        return true;
    }
}

