/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.tli;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentPacket;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SmAgentTliPacket
implements SmAgentPacket,
SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentTliPacket";
    private static final int MAX_OID_SIZE = 64;
    private static final int SIZEOF_INT = 4;
    private static final int TYPE_OFFSET = 0;
    private static final int VERSION_OFFSET = 4;
    private static final int SIZE_OFFSET = 8;
    private static final int ATTR_COUNT_OFFSET = 12;
    private static final int HEADER_LENGTH = 20;
    private static SmAgentTliBuffer c_buffer = new SmAgentTliBuffer();
    private static final int TLI_VERSION = 1280;
    private int m_type = 0;
    private int m_version = 1280;
    private int m_size = 0;
    private List m_attributes = null;

    public SmAgentTliPacket() {
    }

    public SmAgentTliPacket(ByteBuffer buffer) {
        if (buffer == null || buffer.array() == null || buffer.array().length < 20) {
            return;
        }
        this.m_type = buffer.get(0);
        this.m_version = buffer.getInt(4);
        int size = buffer.getInt(8);
        int attrCount = buffer.getInt(12);
        buffer.position(20);
        for (int count = 0; buffer.hasRemaining() && buffer.position() < size && count < attrCount; ++count) {
            int attrId = buffer.getInt();
            int attrTTL = buffer.getInt();
            int attrFlags = buffer.getInt();
            byte[] attrOid = new byte[64];
            buffer.get(attrOid);
            String oidString = null;
            if (attrOid[0] != 0) {
                try {
                    oidString = new String(attrOid, "UTF-8");
                    if (attrOid[63] == 0) {
                        oidString = oidString.trim();
                        if (Util.isLogEnabled()) {
                            Util.display(4, CLASS_NAME, "ctor", "Trimmed OID string: result = " + oidString);
                        }
                    }
                }
                catch (UnsupportedEncodingException e2) {
                    oidString = null;
                }
            }
            int length = buffer.getInt();
            byte[] value = new byte[length];
            if (length > 0) {
                buffer.get(value);
            }
            if (this.m_attributes == null) {
                this.m_attributes = new ArrayList();
            }
            this.m_attributes.add(new SmAttribute(attrId, attrTTL, attrFlags, oidString, value));
        }
        this.m_size = buffer.position();
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public int getSize() {
        return this.m_size;
    }

    public int getAttrCount() {
        return this.m_attributes != null ? this.m_attributes.size() : 0;
    }

    public List getAttributes() {
        return this.m_attributes;
    }

    public void setAttribute(SmAttribute attr) {
        if (attr == null || attr.getValue() == null) {
            return;
        }
        if (this.m_attributes == null) {
            this.m_attributes = new ArrayList();
        }
        this.m_attributes.add(attr);
        this.m_size += 8 + attr.getValue().length;
    }

    public void setAttribute(int id, byte[] value) {
        this.setAttribute(new SmAttribute(id, value));
    }

    public ByteBuffer getData() {
        ByteBuffer buffer = null;
        if (this.m_size <= SmAgentTliBuffer.getDefaultBufferSize()) {
            buffer = (ByteBuffer)c_buffer.get();
            buffer.clear();
        } else {
            buffer = ByteBuffer.allocate(this.m_size + 20);
        }
        buffer.put(0, (byte)this.m_type);
        buffer.putInt(4, this.m_version);
        buffer.putInt(12, this.getAttrCount());
        buffer.position(20);
        if (this.m_attributes != null) {
            for (int k2 = 0; k2 < this.m_attributes.size(); ++k2) {
                SmAttribute attr = (SmAttribute)this.m_attributes.get(k2);
                if (attr == null) continue;
                byte[] val = attr.getValue();
                buffer.putInt(attr.getId());
                buffer.putInt(val.length);
                buffer.put(val);
            }
        }
        int size = buffer.position();
        buffer.putInt(8, size);
        buffer.flip();
        return buffer;
    }
}

