/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.SmAgentApiCommonConstants;
import com.ca.siteminder.sdk.agentapi.UtilLog;
import com.ca.siteminder.sdk.agentapi.crypto.SmAesCryptoTliProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmDES3CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2HmacSHA1CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2SHA1CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC4SHA1CryptoProvider;
import com.ca.siteminder.sdk.agentapi.resources.SmCryptoMessages;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public abstract class SmCryptoProvider
implements SmAgentApiCommonConstants {
    private static final String CLASS_NAME = "SmCryptoProvider";
    public static final int KEY_SIZE = 24;
    public static final int SESSION_KEY_SIZE = 48;
    public static final int MINIMAL_KEY_STRENGTH = 56;
    public static final int DEFAULT_KEY_STRENGTH = 128;
    protected static final String MESSAGES_CLASSNAME = SmCryptoMessages.getName();
    protected static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    protected String m_transformation = null;
    protected String m_algorithm = null;
    protected String m_digestAlg = null;
    protected String m_keyDigestAlg = null;
    protected int m_keyStrength = 128;
    protected boolean m_verifyDigest = false;
    protected boolean m_bAscii = false;
    protected int m_keySize = 24;
    protected static JsafeJCE m_provider = new JsafeJCE();
    protected byte[] m_initVector = null;
    protected Key m_encryptKey = null;
    protected Key m_decryptKey = null;
    protected Cipher m_encrypter = null;
    protected Cipher m_decrypter = null;
    protected int m_digestLength = 0;
    protected boolean m_bCipherCanDoFinal = true;

    public static SmCryptoProvider getInstance(String algorithm, String keyDigestAlg, boolean bAscii) throws SmCryptoProviderException {
        SmCryptoProvider provider = null;
        if ("RC2".equals(algorithm)) {
            provider = new SmRC2CryptoProvider(keyDigestAlg, bAscii);
        } else if ("RC2/SHA".equals(algorithm)) {
            provider = new SmRC2SHA1CryptoProvider(keyDigestAlg, bAscii);
        }
        if ("RC2/HmacSHA1".equals(algorithm)) {
            provider = new SmRC2HmacSHA1CryptoProvider(keyDigestAlg, bAscii);
        } else if ("RC4/SHA".equals(algorithm)) {
            provider = new SmRC4SHA1CryptoProvider(keyDigestAlg, bAscii);
        } else if ("DES3".equals(algorithm)) {
            provider = new SmDES3CryptoProvider(keyDigestAlg, bAscii);
        } else if ("AES-TLI".equals(algorithm)) {
            provider = new SmAesCryptoTliProvider();
        }
        if (provider == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_UNSUPPORTED_PROVIDER") + algorithm);
        }
        return provider;
    }

    public void init(byte[] encryptKey, byte[] decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.m_keyStrength = keyStrength;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(encryptKey);
            this.setDecryptKey(decryptKey);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(initVector, bUseEncKeyForIV);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void init(Key encryptKey, byte[] decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.m_keyStrength = keyStrength;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(encryptKey);
            this.setDecryptKey(decryptKey);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(initVector, bUseEncKeyForIV);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void init(byte[] encryptKey, Key decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.m_keyStrength = keyStrength;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(encryptKey);
            this.setDecryptKey(decryptKey);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(initVector, bUseEncKeyForIV);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void init(Key encryptKey, Key decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.m_keyStrength = keyStrength;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(encryptKey);
            this.setDecryptKey(decryptKey);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(initVector, bUseEncKeyForIV);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void init(byte[] keyingMaterial, int keyStrength) throws SmCryptoProviderException {
    }

    public byte[] encrypt(byte[] input) throws SmCryptoProviderException {
        String methodName = "encrypt";
        if (input == null) {
            UtilLog.display(3, CLASS_NAME, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return this.encrypt(input, input.length);
    }

    public byte[] encrypt(byte[] input, int inLength) throws SmCryptoProviderException {
        String methodName = "encrypt";
        if (input == null || inLength <= 0 || inLength > input.length) {
            UtilLog.display(3, CLASS_NAME, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        if (UtilLog.isLogEnabled()) {
            UtilLog.display(5, CLASS_NAME, "encrypt", "Using crypto provider = " + this.getClass().getName() + ", on input length = " + inLength);
        }
        try {
            if (this.m_encrypter == null) {
                UtilLog.display(5, CLASS_NAME, "encrypt", "Getting encrypter");
                this.m_encrypter = this.getEncrypter();
                UtilLog.display(5, CLASS_NAME, "encrypt", "Got encrypter");
            }
            byte[] output = null;
            byte[] digest = this.makeDigest(input, inLength, true);
            if (digest != null) {
                int tl = this.m_encrypter.getOutputSize(digest.length + inLength);
                output = new byte[tl];
                int dl = this.m_encrypter.update(digest, 0, digest.length, output);
                int il = this.m_encrypter.update(input, 0, inLength, output, dl);
                if (this.m_bCipherCanDoFinal) {
                    this.m_encrypter.doFinal(output, dl + il);
                }
            } else {
                output = this.m_bCipherCanDoFinal ? this.m_encrypter.doFinal(input, 0, inLength) : this.m_encrypter.update(input, 0, inLength);
            }
            if (this.m_bAscii) {
                output = SmCryptoProvider.base64encode(output);
            }
            return output;
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public byte[] decrypt(byte[] input) throws SmCryptoProviderException {
        String methodName = "decrypt";
        if (input == null) {
            UtilLog.display(3, CLASS_NAME, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return this.decrypt(input, input.length);
    }

    public byte[] decrypt(byte[] input, int inLength) throws SmCryptoProviderException {
        String methodName = "decrypt";
        if (input == null || inLength <= 0 || inLength > input.length) {
            UtilLog.display(3, CLASS_NAME, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        if (UtilLog.isLogEnabled()) {
            UtilLog.display(5, CLASS_NAME, "decrypt", "Using crypto provider = " + this.getClass().getName() + ", on input length = " + inLength);
        }
        try {
            byte[] compare;
            int digestLength;
            if (this.m_decrypter == null) {
                UtilLog.display(5, CLASS_NAME, "decrypt", "Getting decrypter");
                this.m_decrypter = this.getDecrypter();
                UtilLog.display(5, CLASS_NAME, "decrypt", "Got decrypter");
            }
            byte[] output = null;
            byte[] digest = null;
            if (this.m_bAscii) {
                input = SmCryptoProvider.base64decode(input, inLength);
                inLength = input.length;
            }
            if ((digestLength = this.getDigestLength()) > 0) {
                digest = new byte[digestLength];
                byte[] combined = this.m_bCipherCanDoFinal ? this.m_decrypter.doFinal(input, 0, inLength) : this.m_decrypter.update(input, 0, inLength);
                output = new byte[combined.length - digest.length];
                System.arraycopy(combined, 0, digest, 0, digest.length);
                System.arraycopy(combined, digest.length, output, 0, output.length);
            } else {
                output = this.m_bCipherCanDoFinal ? this.m_decrypter.doFinal(input, 0, inLength) : this.m_decrypter.update(input, 0, inLength);
            }
            if (this.m_verifyDigest && !MessageDigest.isEqual(digest, compare = this.makeDigest(output, false))) {
                throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_DIGEST_MISMATCH"));
            }
            return output;
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public static byte[] digest(byte[] input, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm, (Provider)new JsafeJCE());
        return md.digest(input);
    }

    public static byte[] base64encode(byte[] input) throws SmCryptoProviderException {
        if (input == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return SmCryptoProvider.base64encode(input, input.length);
    }

    public static byte[] base64encode(byte[] input, int inLength) throws SmCryptoProviderException {
        if (input == null || inLength <= 0 || inLength > input.length) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        try {
            JSAFE_Recode encoder = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            encoder.encodeInit();
            int ouputSize = encoder.getOutputBufferSize(inLength);
            byte[] output = new byte[ouputSize];
            int updatedSize = encoder.encodeUpdate(input, 0, inLength, output, 0);
            updatedSize += encoder.encodeFinal(output, updatedSize);
            if (updatedSize == ouputSize) {
                return output;
            }
            byte[] updated = new byte[updatedSize];
            System.arraycopy(output, 0, updated, 0, updatedSize);
            return updated;
        }
        catch (JSAFE_Exception e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public static byte[] base64decode(byte[] input) throws SmCryptoProviderException {
        if (input == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return SmCryptoProvider.base64decode(input, input.length);
    }

    public static byte[] base64decode(byte[] input, int inLength) throws SmCryptoProviderException {
        if (input == null || inLength <= 0 || inLength > input.length) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        try {
            JSAFE_Recode decoder = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            decoder.decodeInit();
            int ouputSize = decoder.getOutputBufferSize(inLength);
            byte[] output = new byte[ouputSize];
            int updatedSize = decoder.decodeUpdate(input, 0, inLength, output, 0);
            updatedSize += decoder.decodeFinal(output, updatedSize);
            if (updatedSize == ouputSize) {
                return output;
            }
            byte[] updated = new byte[updatedSize];
            System.arraycopy(output, 0, updated, 0, updatedSize);
            return updated;
        }
        catch (JSAFE_Exception e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public abstract Key generateKey() throws SmCryptoProviderException;

    protected void setEncryptKey(byte[] encryptKey) throws NoSuchAlgorithmException, SmCryptoProviderException {
        if (encryptKey == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_ENCRYPTION_KEY"));
        }
        byte[] encryptKeyData = this.generateKeyData(encryptKey);
        this.m_encryptKey = new SecretKeySpec(encryptKeyData, this.m_algorithm);
    }

    protected void setDecryptKey(byte[] decryptKey) throws NoSuchAlgorithmException, SmCryptoProviderException {
        if (decryptKey == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_DECRYPTION_KEY"));
        }
        byte[] decryptKeyData = this.generateKeyData(decryptKey);
        this.m_decryptKey = new SecretKeySpec(decryptKeyData, this.m_algorithm);
    }

    protected void setEncryptKey(Key encryptKey) throws SmCryptoProviderException {
        if (encryptKey == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_ENCRYPTION_KEY"));
        }
        if (encryptKey.getAlgorithm() == null || !encryptKey.getAlgorithm().equals(this.m_algorithm)) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_ALGORITHM") + encryptKey.getAlgorithm());
        }
        this.m_encryptKey = encryptKey;
    }

    protected void setDecryptKey(Key decryptKey) throws SmCryptoProviderException {
        if (decryptKey == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_DECRYPTION_KEY"));
        }
        if (decryptKey.getAlgorithm() == null || !decryptKey.getAlgorithm().equals(this.m_algorithm)) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_ALGORITHM") + decryptKey.getAlgorithm());
        }
        this.m_decryptKey = decryptKey;
    }

    protected void setInitVector(byte[] initVector, boolean bUseEncKeyForIV) throws GeneralSecurityException, SmCryptoProviderException {
        this.m_initVector = initVector;
        if (this.m_initVector == null) {
            int blockSize = this.getBlockSize();
            byte[] keyData = null;
            keyData = bUseEncKeyForIV ? this.m_encryptKey.getEncoded() : this.m_decryptKey.getEncoded();
            if (keyData == null || keyData.length < blockSize) {
                String error = null;
                try {
                    error = new String(keyData, "UTF-8");
                }
                catch (UnsupportedEncodingException e2) {
                    throw new SmCryptoProviderException(e2);
                }
                throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INIT_VECTOR") + error);
            }
            this.m_initVector = new byte[blockSize];
            System.arraycopy(keyData, 0, this.m_initVector, 0, blockSize);
        }
    }

    protected void initParams() throws SmCryptoProviderException {
    }

    protected abstract Cipher getEncrypter() throws GeneralSecurityException, SmCryptoProviderException;

    protected abstract Cipher getDecrypter() throws GeneralSecurityException, SmCryptoProviderException;

    protected byte[] makeDigest(byte[] input, boolean bEncryptionMode) throws GeneralSecurityException, SmCryptoProviderException {
        return null;
    }

    protected byte[] makeDigest(byte[] input, int inLength, boolean bEncryptionMode) throws GeneralSecurityException, SmCryptoProviderException {
        return null;
    }

    protected int getDigestLength() {
        return this.m_digestLength;
    }

    protected int getBlockSize() throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        return cipher.getBlockSize();
    }

    protected byte[] generateKeyData(byte[] input) throws NoSuchAlgorithmException {
        if (input == null) {
            return null;
        }
        byte[] keyData = new byte[this.m_keySize];
        byte[] rawData = input;
        if (this.m_keyDigestAlg != null) {
            MessageDigest md = MessageDigest.getInstance(this.m_keyDigestAlg, (Provider)m_provider);
            rawData = md.digest(input);
        }
        if (rawData.length >= this.m_keySize) {
            System.arraycopy(rawData, 0, keyData, 0, this.m_keySize);
        } else {
            System.arraycopy(rawData, 0, keyData, 0, rawData.length);
            Arrays.fill(keyData, rawData.length, this.m_keySize, (byte)0);
        }
        return keyData;
    }
}

