/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.config;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigAttribute;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmConfigMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class SmConfigFile
implements SmAgentApiConstants {
    private static final String CLASS_NAME = "SmConfigFile";
    private static final String MESSAGES_CLASSNAME = SmConfigMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static final String ATTR_SEPARATOR = "=";
    private static final String COMMENT_PREFIX = "#";
    private static final String QUOTE_STRING = "\"";
    private Map m_configFileLines = Collections.synchronizedMap(new LinkedHashMap());
    private static Hashtable c_instances = new Hashtable();
    private FileChannel m_channel;
    private String m_filename;

    public static SmConfigFile getInstance(String configFilename) throws SmConfigException {
        return SmConfigFile.getInstance(configFilename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmConfigFile getInstance(String configFilename, boolean createFile) throws SmConfigException {
        String methodName = "getInstance";
        if (configFilename == null) {
            return null;
        }
        File configFile = new File(configFilename);
        String absoluteName = configFile.getAbsolutePath();
        SmConfigFile config = null;
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "getInstance", "Obtaining SmConfigFile instance for file: " + absoluteName);
        }
        Hashtable hashtable = c_instances;
        synchronized (hashtable) {
            config = (SmConfigFile)c_instances.get(absoluteName);
            if (config == null) {
                if (!createFile) {
                    SmConfigFile.validateConfigFile(configFile, absoluteName);
                } else if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "getInstance", "Creating new SmConfigFile for file: " + absoluteName);
                }
                config = new SmConfigFile(absoluteName);
                c_instances.put(absoluteName, config);
            } else if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "getInstance", "Retrieved existing SmConfigFile for file: " + absoluteName);
            }
        }
        return config;
    }

    protected SmConfigFile(String filename) {
        this.m_filename = filename;
    }

    public synchronized void read() throws SmConfigException {
        String methodName = "read";
        if (this.m_configFileLines.size() != 0) {
            Util.display(4, CLASS_NAME, "read", "Skipping read since attributes already read");
            return;
        }
        ByteBuffer buffer = null;
        try {
            this.openChannel("r");
        }
        catch (FileNotFoundException e2) {
            throw new SmConfigException(e2);
        }
        if (this.m_channel == null) {
            if (Util.isLogEnabled()) {
                Util.display(3, CLASS_NAME, "read", "Failed to open a channel to configFile = " + this.getFilename());
            }
            throw new SmConfigException(c_bundle.getString("M_FAILURE_OPEN_CHANNEL") + this.getFilename());
        }
        FileLock lock = null;
        try {
            lock = this.m_channel.lock(0L, Long.MAX_VALUE, true);
            if (lock == null) {
                if (Util.isLogEnabled()) {
                    Util.display(3, CLASS_NAME, "read", "Retrieved null shared read lock to configFile = " + this.getFilename());
                }
                throw new SmConfigException(c_bundle.getString("M_FAILURE_LOCK_SHARED") + this.getFilename());
            }
            long size = this.m_channel.size();
            buffer = ByteBuffer.allocate((int)size);
            this.m_channel.read(buffer);
        }
        catch (IOException e3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "read", "Failed to open a channel to configFile = " + this.getFilename());
                e3.printStackTrace();
            }
            throw new SmConfigException(e3);
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                this.close();
            }
            catch (IOException e4) {
                if (Util.isLogEnabled()) {
                    e4.printStackTrace();
                }
                throw new SmConfigException(e4);
            }
        }
        if (buffer != null) {
            try {
                this.parse(new String(buffer.array(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e5) {
                throw new SmConfigException(e5);
            }
        }
    }

    public synchronized void write() throws SmConfigException {
        byte[] bytes;
        try {
            bytes = this.createWriteBuffer().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new SmConfigException(e2);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            this.openChannel("rws");
        }
        catch (FileNotFoundException e3) {
            throw new SmConfigException(e3);
        }
        if (this.m_channel == null) {
            throw new SmConfigException(c_bundle.getString("M_FAILURE_OPEN_CHANNEL") + this.getFilename());
        }
        FileLock lock = null;
        try {
            lock = this.m_channel.lock(0L, Long.MAX_VALUE, false);
            if (lock == null) {
                throw new SmConfigException(c_bundle.getString("M_FAILURE_LOCK_EXCLUSIVE") + this.getFilename());
            }
            int size = this.m_channel.write(buffer, 0L);
            this.m_channel.truncate(size);
        }
        catch (IOException e4) {
            if (Util.isLogEnabled()) {
                e4.printStackTrace();
            }
            throw new SmConfigException(e4);
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                this.close();
            }
            catch (IOException e5) {
                if (Util.isLogEnabled()) {
                    e5.printStackTrace();
                }
                throw new SmConfigException(e5);
            }
        }
    }

    public synchronized void close() throws SmConfigException {
        try {
            if (this.m_channel != null) {
                this.m_channel.close();
                this.m_channel = null;
            }
        }
        catch (IOException e2) {
            throw new SmConfigException(e2);
        }
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getAttribute(SmConfigAttribute attribute) throws SmCryptoProviderException, SmConfigException {
        if (attribute == null) {
            return null;
        }
        if (attribute.isMultiValue()) {
            throw new SmConfigException(c_bundle.getString("M_NOT_SINGLEVALUE"));
        }
        return (String)this.m_configFileLines.get(attribute);
    }

    public String getDecryptedAttribute(SmConfigAttribute attribute) throws SmCryptoProviderException, SmConfigException {
        if (attribute == null) {
            return null;
        }
        String encrypted = this.getAttribute(attribute);
        return attribute.decrypt(encrypted);
    }

    public List getMultiValueAttribute(SmConfigAttribute attribute) throws SmCryptoProviderException, SmConfigException {
        if (attribute == null) {
            return new ArrayList();
        }
        if (!attribute.isMultiValue()) {
            throw new SmConfigException(c_bundle.getString("M_NOT_MULTIVALUE"));
        }
        List encrypted = (List)this.m_configFileLines.get(attribute);
        if (encrypted == null || encrypted.size() == 0) {
            return new ArrayList();
        }
        ArrayList<String> decrypted = new ArrayList<String>((int)Math.ceil((double)encrypted.size() * 1.35));
        for (int i2 = 0; i2 < encrypted.size(); ++i2) {
            decrypted.add(attribute.decrypt((String)encrypted.get(i2)));
        }
        return decrypted;
    }

    public void setAttribute(SmConfigAttribute attribute, String value) throws SmCryptoProviderException, SmConfigException {
        if (attribute == null) {
            return;
        }
        if (attribute.isMultiValue()) {
            throw new SmConfigException(c_bundle.getString("M_NOT_SINGLEVALUE"));
        }
        String encrypted = attribute.encrypt(value);
        this.m_configFileLines.put(attribute, encrypted);
    }

    public void setAttribute(SmConfigAttribute attribute, List value) throws SmCryptoProviderException, SmConfigException {
        if (attribute == null) {
            return;
        }
        if (!attribute.isMultiValue()) {
            throw new SmConfigException(c_bundle.getString("M_NOT_MULTIVALUE"));
        }
        if (value == null) {
            this.m_configFileLines.put(attribute, new ArrayList());
        }
        ArrayList<String> encrypted = new ArrayList<String>((int)Math.ceil((double)value.size() * 1.35));
        for (int i2 = 0; i2 < value.size(); ++i2) {
            encrypted.add(attribute.encrypt((String)value.get(i2)));
        }
        this.m_configFileLines.put(attribute, encrypted);
    }

    public void removeAttribute(SmConfigAttribute attr) {
        this.m_configFileLines.remove(attr);
    }

    public void removeAll() {
        this.m_configFileLines.clear();
    }

    public Map getAllAttributes() throws SmCryptoProviderException, SmConfigException {
        HashMap attributes = new HashMap();
        Set keys = this.m_configFileLines.keySet();
        if (keys != null) {
            for (Object key : keys) {
                if (!(key instanceof SmConfigAttribute)) continue;
                SmConfigAttribute attribute = (SmConfigAttribute)key;
                Object value = !attribute.isMultiValue() ? this.getAttribute(attribute) : this.getMultiValueAttribute(attribute);
                attributes.put(key, value);
                if (!Util.isLogEnabled()) continue;
                Util.display(5, CLASS_NAME, "getAllAttributes", "Adding to all attributes name = " + ((SmConfigAttribute)key).getName() + ", value = " + value);
            }
        }
        return attributes;
    }

    public int getTotalLines() {
        return this.m_configFileLines.size();
    }

    public void addComment(String comment) {
        if (comment == null) {
            return;
        }
        if (!comment.startsWith(COMMENT_PREFIX)) {
            comment = COMMENT_PREFIX + comment;
        }
        this.m_configFileLines.put(new Integer(this.m_configFileLines.size()), comment);
    }

    public void addBlankLine() {
        this.m_configFileLines.put(new Integer(this.m_configFileLines.size()), "");
    }

    public boolean updateComment(String comment, int lineNumber) {
        if (lineNumber < 0 || comment == null) {
            return false;
        }
        Object existingLine = this.m_configFileLines.get(new Integer(lineNumber));
        if (existingLine == null) {
            return false;
        }
        if (!comment.startsWith(COMMENT_PREFIX)) {
            comment = COMMENT_PREFIX + comment;
        }
        this.m_configFileLines.put(new Integer(lineNumber), comment);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSharedSecret(String newSecret, long newTime) throws SmCryptoProviderException, SmConfigException {
        if (newSecret == null) {
            return false;
        }
        Map map = this.m_configFileLines;
        synchronized (map) {
            String oldSecret = this.getAttribute(SM_CONF_SHARED_SECRET);
            String timestamp = this.getAttribute(SM_CONF_SHARED_SECRET_TIME);
            long oldTime = 0L;
            if (timestamp != null) {
                try {
                    oldTime = Long.parseLong(timestamp);
                }
                catch (NumberFormatException e2) {
                    oldTime = 0L;
                }
            }
            if (oldSecret == null || timestamp == null || !oldSecret.equals(newSecret) && newTime > oldTime) {
                this.setAttribute(SM_CONF_SHARED_SECRET, newSecret);
                this.setAttribute(SM_CONF_SHARED_SECRET_TIME, String.valueOf(newTime));
                return true;
            }
        }
        return false;
    }

    protected void finalize() throws SmConfigException {
        this.close();
    }

    private void openChannel(String mode) throws FileNotFoundException {
        if (this.m_channel == null || !this.m_channel.isOpen()) {
            RandomAccessFile file = new RandomAccessFile(this.getFilename(), mode);
            this.m_channel = file.getChannel();
        }
    }

    private void parse(String buffer) throws SmConfigException {
        String methodName = "parse";
        String[] bufferLines = buffer.split(LINE_SEPARATOR);
        for (int k2 = 0; k2 < bufferLines.length; ++k2) {
            String line = bufferLines[k2].trim();
            if (line.length() == 0) {
                this.addBlankLine();
                continue;
            }
            if (line.startsWith(COMMENT_PREFIX)) {
                this.addComment(line);
                continue;
            }
            int index = line.indexOf(ATTR_SEPARATOR);
            if (index > 0) {
                String name = line.substring(0, index).trim();
                String value = line.substring(index + ATTR_SEPARATOR.length()).trim();
                if (value != null && value.startsWith(QUOTE_STRING) && value.endsWith(QUOTE_STRING)) {
                    value = value.substring(QUOTE_STRING.length(), value.length() - QUOTE_STRING.length());
                    String format = null;
                    if (value.startsWith("{RC2}")) {
                        format = "{RC2}";
                    } else if (value.startsWith("{DES3}")) {
                        format = "{DES3}";
                    }
                    SmConfigAttribute attribute = SmConfigAttribute.findOrCreate(name, format);
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "parse", "Adding attribute name = " + attribute.getName() + ", value = " + value);
                    }
                    if (!attribute.isMultiValue()) {
                        this.m_configFileLines.put(attribute, value);
                        continue;
                    }
                    ArrayList<String> values = (ArrayList<String>)this.m_configFileLines.get(attribute);
                    if (values == null) {
                        values = new ArrayList<String>(2);
                    }
                    values.add(value);
                    this.m_configFileLines.put(attribute, values);
                    continue;
                }
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "parse", "Malformed line quoted value: " + line);
                }
                throw new SmConfigException(c_bundle.getString("M_MALFORMED_LINE_NO_QUOTES") + line);
            }
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "parse", "Malformed line no name=value pair: " + line);
            }
            throw new SmConfigException(c_bundle.getString("M_MALFORMED_LINE_EMPTY_NAME") + line);
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "parse", "Parsed total lines = " + bufferLines.length);
        }
    }

    private String createWriteBuffer() throws SmConfigException {
        StringBuffer writeBuffer = new StringBuffer();
        for (Map.Entry entry : this.m_configFileLines.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof SmConfigAttribute) {
                SmConfigAttribute attribute = (SmConfigAttribute)key;
                if (!attribute.isMultiValue()) {
                    this.appendAttribute(writeBuffer, attribute.getName(), (String)entry.getValue());
                    continue;
                }
                List values = (List)entry.getValue();
                if (values.size() == 0) {
                    this.appendAttribute(writeBuffer, attribute.getName(), "");
                    continue;
                }
                for (int i2 = 0; i2 < values.size(); ++i2) {
                    this.appendAttribute(writeBuffer, attribute.getName(), (String)values.get(i2));
                }
                continue;
            }
            if (key instanceof Integer) {
                writeBuffer.append((String)entry.getValue());
                writeBuffer.append(LINE_SEPARATOR);
                continue;
            }
            throw new SmConfigException(c_bundle.getString("M_INVALID_ATTRIBUTE"));
        }
        return writeBuffer.toString();
    }

    private void appendAttribute(StringBuffer writeBuffer, String name, String value) {
        writeBuffer.append(name);
        writeBuffer.append(ATTR_SEPARATOR);
        writeBuffer.append(QUOTE_STRING);
        writeBuffer.append(value);
        writeBuffer.append(QUOTE_STRING);
        writeBuffer.append(LINE_SEPARATOR);
    }

    private static void validateConfigFile(File configFile, String absoluteName) throws SmConfigException {
        String methodName = "validateConfigFile";
        if (!configFile.exists()) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "validateConfigFile", "File does not exist: " + absoluteName);
            }
            throw new SmConfigException("Could not find config file: " + absoluteName);
        }
        if (!configFile.canRead()) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "validateConfigFile", "Config file must be readable: " + absoluteName);
            }
            throw new SmConfigException("Config file must be readable: " + absoluteName);
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "validateConfigFile", "Found readable config file: " + absoluteName);
        }
    }
}

