/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.config;

import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigAttrDefinitions;
import com.ca.siteminder.sdk.agentapi.config.SmConfigAttrFormats;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmConfigMessages;
import com.netegrity.util.AesKeyWrapper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class SmConfigAttribute
implements SmConfigAttrFormats,
SmConfigAttrDefinitions {
    private static final String CLASS_NAME = "SmConfigAttribute";
    private static final String MESSAGES_CLASSNAME;
    private static ResourceBundle c_bundle;
    private static byte[] c_key;
    private static Map c_attributes;
    private String m_name;
    private String m_format;
    private boolean m_isMultiValue;
    private static String[] m_allFormats;

    SmConfigAttribute(String name, String format) {
        this(name, format, false);
    }

    SmConfigAttribute(String name, String format, boolean isMultiValue) {
        if (name != null) {
            this.m_name = name.toLowerCase();
        }
        this.m_format = format;
        this.m_isMultiValue = isMultiValue;
        c_attributes.put(name, this);
    }

    public static SmConfigAttribute find(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase();
        return (SmConfigAttribute)c_attributes.get(name);
    }

    public static SmConfigAttribute findOrCreate(String name, String format) throws SmConfigException {
        SmConfigAttribute attr = SmConfigAttribute.find(name);
        if (attr == null) {
            attr = new SmConfigAttribute(name, format);
        }
        attr.setFormat(format);
        return attr;
    }

    public String getName() {
        return this.m_name;
    }

    public String getFormat() {
        return this.m_format;
    }

    public void setFormat(String format) throws SmConfigException {
        if (format != null) {
            boolean valid = false;
            if (m_allFormats != null) {
                for (int k2 = 0; k2 < m_allFormats.length; ++k2) {
                    if (!format.equals(m_allFormats[k2])) continue;
                    valid = true;
                    break;
                }
            }
            if (!valid) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "setFormat", "Attempt to set unsupported format = " + format);
                }
                throw new SmConfigException(c_bundle.getString("M_NOT_SUPPORTED_FORMAT") + format);
            }
        }
        this.m_format = format;
    }

    public String encrypt(String input) throws SmCryptoProviderException, SmConfigException {
        String methodName = "encrypt";
        if (input == null) {
            return null;
        }
        try {
            if (this.m_format == null) {
                return input;
            }
            if (this.m_format.equals("{RC2}")) {
                SmCryptoProvider provider = SmCryptoProvider.getInstance("RC2/SHA", null, true);
                provider.init(c_key, c_key, null, 128, true);
                String output = new String(provider.encrypt(input.getBytes("UTF-8")), "UTF-8");
                return "{RC2}" + output;
            }
            if (this.m_format.equals("{AES}")) {
                AesKeyWrapper aesKeyWrapper = new AesKeyWrapper(c_key);
                byte[] inputBytes = input.getBytes("UTF-8");
                String output = new String(aesKeyWrapper.WrapAscii(inputBytes, inputBytes.length), "UTF-8");
                Arrays.fill(inputBytes, (byte)0);
                return "{AES}" + output;
            }
            if (this.m_format.equals("{DES3}")) {
                Util.display(2, CLASS_NAME, "encrypt", "Attempt to encrypt with unsupported format DES3");
                throw new SmConfigException(c_bundle.getString("M_NOT_SUPPORTED_DES3"));
            }
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "encrypt", "Attempt to encrypt with unknown format " + this.m_format);
            }
            throw new SmConfigException(c_bundle.getString("M_NOT_SUPPORTED_FORMAT") + this.m_format);
        }
        catch (UnsupportedEncodingException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "encrypt", e2.getMessage());
            }
            throw new SmConfigException(e2);
        }
    }

    public String decrypt(String input) throws SmCryptoProviderException, SmConfigException {
        String methodName = "decrypt";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "decrypt", "Attempting to decrypt input = " + input);
        }
        if (input == null) {
            return null;
        }
        try {
            if (input.startsWith("{RC2}")) {
                input = input.substring("{RC2}".length());
                SmCryptoProvider provider = SmCryptoProvider.getInstance("RC2/SHA", null, true);
                provider.init(c_key, c_key, null, 128, true);
                String output = new String(provider.decrypt(input.getBytes("UTF-8")), "UTF-8");
                return output;
            }
            if (input.startsWith("{AES}")) {
                input = input.substring("{AES}".length());
                AesKeyWrapper aesKeyWrapper = new AesKeyWrapper(c_key);
                byte[] inputBytes = input.getBytes("UTF-8");
                String output = new String(aesKeyWrapper.UnwrapAscii(inputBytes, 0, inputBytes.length), "UTF-8");
                Arrays.fill(inputBytes, (byte)0);
                return output;
            }
            if (input.startsWith("{DES3}")) {
                Util.display(2, CLASS_NAME, "decrypt", "Attempt to decrypt unsupported DES3");
                throw new SmConfigException(c_bundle.getString("M_NOT_SUPPORTED_DES3"));
            }
            return input;
        }
        catch (UnsupportedEncodingException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "decrypt", "Unsupported encoding: " + e2);
            }
            throw new SmConfigException(e2);
        }
    }

    private static byte[] generateKey() {
        ByteBuffer buffer = ByteBuffer.allocate(24);
        buffer.order(ByteOrder.nativeOrder());
        buffer.putInt(272624002);
        buffer.putInt(687646644);
        buffer.putInt(-581792113);
        buffer.putInt(390718410);
        buffer.putInt(297542465);
        buffer.putInt(2077505698);
        byte[] key = buffer.array();
        return key;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("*name:");
        buffer.append(this.m_name);
        buffer.append(", format:");
        buffer.append(this.m_format);
        buffer.append("*");
        return buffer.toString();
    }

    public boolean isMultiValue() {
        return this.m_isMultiValue;
    }

    static {
        block2: {
            MESSAGES_CLASSNAME = SmConfigMessages.getName();
            c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
            c_key = SmConfigAttribute.generateKey();
            c_attributes = new HashMap();
            try {
                m_allFormats = SmConfigAttrFormats.ALL_FORMATS;
                Class.forName(SmConfigAttrDefinitions.class.getName());
            }
            catch (Exception e2) {
                if (!Util.isLogEnabled()) break block2;
                Util.display(2, CLASS_NAME, "static", "Unable to initialize encryption formats");
                e2.printStackTrace();
            }
        }
    }
}

