/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.advancedauth;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.advancedauth.SATokenRequest;
import com.ca.siteminder.sdk.agentapi.advancedauth.SATokenResponse;
import com.ca.siteminder.sdk.agentapi.advancedauth.SmAgentApiAdvAuth;
import com.ca.siteminder.sdk.agentapi.advancedauth.SmAgentApiAdvAuthException;
import com.ca.siteminder.sdk.agentapi.advancedauth.SmAgentApiAdvAuthResult;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnection;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.resources.SmAdvAuthMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class SmAgentApiAdvAuthImpl
implements SmAgentApiAdvAuth,
SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentApiAdvAuthImpl";
    private static final String MESSAGES_CLASSNAME = SmAdvAuthMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    final String Sm_Api_Search_Key_Adv_Auth = "AdvAuthTokenId";
    final String Sm_Api_Data_Adv_Auth = "AdvAuthTokenData";
    private final String Sm_Api_SAID = "SAID";
    private final String Sm_Api_SARespID_SAResult = "SARespID_Result";
    private final String Sm_Api_SARespID_DeviceID = "SARespID_DeviceID";
    private final String Sm_Api_SARespID_DeviceHash = "SARespID_DeviceHash";
    private final String Sm_Api_SARespID_UserRefID = "SARespID_UserRefID";
    private final String Sm_Api_SARespID_RiskScore = "SARespID_RiskScore";
    private final String Sm_Api_SARespID_TargetURL = "SARespID_TargetURL";
    private final String Sm_Api_SARespID_RealmOid = "SARespID_RealmOid";
    private final String Sm_Api_SAReqID_TenantID = "SAReqID_TenantID";
    private final String Sm_Api_SAReqID_DomainName = "SAReqID_DomainName";
    private final String Sm_Api_SAReqID_UserDN = "SAReqID_UserDN";
    private final String Sm_Api_SAReqID_UserDirName = "SAReqID_UserDirName";
    private final String Sm_Api_SAReqID_UserRefID = "SAReqID_UserRefID";
    private final String Sm_Api_SAReqID_FlowURL = "SAReqID_FlowURL";
    private final String Sm_Api_SAReqID_DeviceHash = "SAReqID_DeviceHash";
    private final String Sm_Api_SAReqID_StateVar = "SAReqID_StateVar";
    private final String Sm_Api_SAReqID_TargetURL = "SAReqID_TargetURL";
    private final String Sm_Api_SAReqID_RealmOid = "SAReqID_RealmOid";
    private SmAgentApiConnection m_connection = null;

    public SmAgentApiAdvAuthImpl(SmAgentApiConnection connection) {
        this.m_connection = connection;
    }

    public String peekAdvAuthToken(String transactionId, String advAuthTokenId) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.getAdvAuthToken(transactionId, advAuthTokenId, false);
    }

    public String getAdvAuthToken(String transactionId, String advAuthTokenId) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.getAdvAuthToken(transactionId, advAuthTokenId, true);
    }

    private String getAdvAuthToken(String transactionId, String advAuthTokenId, boolean bDeleteOnRead) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "getAdvAuthToken";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, "No connection is initialized.");
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(141);
        try {
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(128, new Integer(9).toString().getBytes("UTF-8"));
            request.setAttribute(140, "AdvAuthTokenId".getBytes("UTF-8"));
            request.setAttribute(141, advAuthTokenId.getBytes("UTF-8"));
            if (bDeleteOnRead) {
                request.setAttribute(127, new String("").getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e2) {
            Util.display(2, CLASS_NAME, "getAdvAuthToken", c_bundle.getString("M_UNSUPPORTED_ENCODING"));
            throw new SmAgentApiAdvAuthException(e2);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        this.validateResponse(status, response);
        String advAuthTokenData = null;
        List responseAttrs = response.getAttributes();
        if (null != responseAttrs && responseAttrs.size() > 0) {
            Iterator it = responseAttrs.iterator();
            SmAttribute attr = (SmAttribute)it.next();
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "getAdvAuthToken", c_bundle.getString("M_PROCESS_RESPONSE_ATTR") + new String(attr.getValue()));
            }
            if (attr == null || attr.getValue() == null) {
                Util.display(2, CLASS_NAME, "getAdvAuthToken", c_bundle.getString("M_PROCESS_RESPONSE_NULL"));
                throw new SmAgentApiAdvAuthException(-1, "Invalid attribute.");
            }
            try {
                advAuthTokenData = new String(attr.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e3) {
                Util.display(2, CLASS_NAME, "getAdvAuthToken", c_bundle.getString("M_UNSUPPORTED_ENCODING"));
                throw new SmAgentApiAdvAuthException(e3);
            }
        }
        return advAuthTokenData;
    }

    public SmAgentApiAdvAuthResult setAdvAuthToken(String transactionId, String advAuthTokenId, String advAuthTokenData) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "setAdvAuthToken";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(142);
        try {
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(128, new Integer(9).toString().getBytes("UTF-8"));
            request.setAttribute(140, "AdvAuthTokenId".getBytes("UTF-8"));
            request.setAttribute(141, advAuthTokenId.getBytes("UTF-8"));
            request.setAttribute(140, "AdvAuthTokenData".getBytes("UTF-8"));
            request.setAttribute(141, advAuthTokenData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            Util.display(2, CLASS_NAME, "setAdvAuthToken", c_bundle.getString("M_UNSUPPORTED_ENCODING"));
            throw new SmAgentApiAdvAuthException(e2);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        this.validateResponse(status, response);
        boolean result = false;
        int code = response.getType();
        if (code == 2) {
            result = true;
        }
        return new SmAgentApiAdvAuthResult(result);
    }

    public SmAgentApiAdvAuthResult deleteAdvAuthToken(String transactionId, String advAuthTokenId) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "deleteAdvAuthToken";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(143);
        try {
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(221, transactionId.getBytes("UTF-8"));
            request.setAttribute(128, new Integer(9).toString().getBytes("UTF-8"));
            request.setAttribute(140, "AdvAuthTokenId".getBytes("UTF-8"));
            request.setAttribute(141, advAuthTokenId.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            Util.display(2, CLASS_NAME, "deleteAdvAuthToken", c_bundle.getString("M_UNSUPPORTED_ENCODING"));
            throw new SmAgentApiAdvAuthException(e2);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        this.validateResponse(status, response);
        boolean result = false;
        int code = response.getType();
        if (code == 2) {
            result = true;
        }
        return new SmAgentApiAdvAuthResult(result);
    }

    private void validateResponse(int[] status, SmAgentTliPacket response) throws SmAgentApiAdvAuthException {
        String methodName = "validateResponse";
        if (status[0] != 0) {
            Util.display(2, CLASS_NAME, "validateResponse", c_bundle.getString("M_PROCESS_RESPONSE_FAIL"));
            throw new SmAgentApiAdvAuthException(status[0], "Failed request.");
        }
        if (response == null) {
            Util.display(2, CLASS_NAME, "validateResponse", c_bundle.getString("M_PROCESS_RESPONSE_NULL"));
            throw new SmAgentApiAdvAuthException(-1, "Invalid response.");
        }
        int code = response.getType();
        if (code != 2 && code != 3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "validateResponse", c_bundle.getString("M_PROCESS_RESPONSE_UNKNOWN") + code);
            }
            throw new SmAgentApiAdvAuthException(-1, "Unrecognized response code.");
        }
    }

    public SATokenRequest getSARequestToken(String transactionId, String saTokenReqID) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "getSARequestToken";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, "No connection is initialized.");
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(141);
        try {
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(128, new Integer(10).toString().getBytes("UTF-8"));
            request.setAttribute(140, "SAID".getBytes("UTF-8"));
            request.setAttribute(141, saTokenReqID.getBytes("UTF-8"));
            request.setAttribute(127, new String("").getBytes("UTF-8"));
            int[] status = new int[1];
            SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
            this.validateResponse(status, response);
            SATokenRequest retData = new SATokenRequest();
            this.fillSATokenRequest(retData, response);
            return retData;
        }
        catch (UnsupportedEncodingException e2) {
            Util.display(2, CLASS_NAME, "getSARequestToken", c_bundle.getString("M_UNSUPPORTED_ENCODING"));
            throw new SmAgentApiAdvAuthException(e2);
        }
    }

    private void fillSATokenRequest(SATokenRequest satr, SmAgentTliPacket response) throws SmAgentApiAdvAuthException, UnsupportedEncodingException {
        String methodName = "fillSATokenRequest";
        List responseAttrs = response.getAttributes();
        if (null != responseAttrs && responseAttrs.size() > 0) {
            for (SmAttribute attr : responseAttrs) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "fillSATokenRequest", c_bundle.getString("M_PROCESS_RESPONSE_ATTR") + new String(attr.getValue()));
                }
                if (attr == null || attr.getValue() == null || attr.getOid() == null) {
                    Util.display(2, CLASS_NAME, "fillSATokenRequest", c_bundle.getString("M_PROCESS_RESPONSE_NULL"));
                    throw new SmAgentApiAdvAuthException(-1, "Invalid attribute.");
                }
                if (attr.getOid().equals("SAReqID_TenantID")) {
                    satr.setTenantID(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_DomainName")) {
                    satr.setDomainName(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_UserDN")) {
                    satr.setUserDN(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_UserDirName")) {
                    satr.setUserDirName(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_UserRefID")) {
                    satr.setUserRefID(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_FlowURL")) {
                    satr.setSAFlowURL(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_DeviceHash")) {
                    satr.setDeviceHash(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_StateVar")) {
                    satr.setStateVar(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (attr.getOid().equals("SAReqID_TargetURL")) {
                    satr.setTargetURL(new String(attr.getValue(), "UTF-8"));
                    continue;
                }
                if (!attr.getOid().equals("SAReqID_RealmOid")) continue;
                satr.setRealmOid(new String(attr.getValue(), "UTF-8"));
            }
        } else {
            Util.display(2, CLASS_NAME, "fillSATokenRequest", c_bundle.getString("M_PROCESS_RESPONSE_NULL"));
            throw new SmAgentApiAdvAuthException(-1, c_bundle.getString("M_PROCESS_RESPONSE_NULL"));
        }
    }

    public SmAgentApiAdvAuthResult setSAResponseToken(String transactionId, String saTokenRespID, SATokenResponse saTokenResp) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "setSAResponseToken";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(142);
        try {
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(128, new Integer(11).toString().getBytes("UTF-8"));
            request.setAttribute(140, "SAID".getBytes("UTF-8"));
            request.setAttribute(141, saTokenRespID.getBytes("UTF-8"));
            request.setAttribute(140, "SARespID_Result".getBytes("UTF-8"));
            request.setAttribute(141, saTokenResp.getSAResult().getBytes("UTF-8"));
            request.setAttribute(140, "SARespID_DeviceID".getBytes("UTF-8"));
            request.setAttribute(141, saTokenResp.getDeviceID().getBytes("UTF-8"));
            request.setAttribute(140, "SARespID_DeviceHash".getBytes("UTF-8"));
            request.setAttribute(141, saTokenResp.getDeviceHash().getBytes("UTF-8"));
            request.setAttribute(140, "SARespID_UserRefID".getBytes("UTF-8"));
            request.setAttribute(141, saTokenResp.getUserRefID().getBytes("UTF-8"));
            request.setAttribute(140, "SARespID_RiskScore".getBytes("UTF-8"));
            request.setAttribute(141, String.valueOf(saTokenResp.getRiskScore()).getBytes("UTF-8"));
            request.setAttribute(140, "SARespID_TargetURL".getBytes("UTF-8"));
            request.setAttribute(141, String.valueOf(saTokenResp.getTargetURL()).getBytes("UTF-8"));
            request.setAttribute(140, "SARespID_RealmOid".getBytes("UTF-8"));
            request.setAttribute(141, String.valueOf(saTokenResp.getRealmOid()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            Util.display(2, CLASS_NAME, "setSAResponseToken", c_bundle.getString("M_UNSUPPORTED_ENCODING"));
            throw new SmAgentApiAdvAuthException(e2);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        this.validateResponse(status, response);
        boolean result = false;
        int code = response.getType();
        if (code == 2) {
            result = true;
        }
        return new SmAgentApiAdvAuthResult(result);
    }
}

