/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi;

import com.ca.siteminder.sdk.agentapi.SmAgentApi;
import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiResult;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAgentApiAccessControl;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAgentApiAccessControlException;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAgentApiAccessControlImpl;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuditResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuthenticationResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuthorizationResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmRealmDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceContextDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceProtectionResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmSessionDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserAgentDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserCredentials;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmVerifyCredsResult;
import com.ca.siteminder.sdk.agentapi.advancedauth.SATokenRequest;
import com.ca.siteminder.sdk.agentapi.advancedauth.SATokenResponse;
import com.ca.siteminder.sdk.agentapi.advancedauth.SmAgentApiAdvAuth;
import com.ca.siteminder.sdk.agentapi.advancedauth.SmAgentApiAdvAuthException;
import com.ca.siteminder.sdk.agentapi.advancedauth.SmAgentApiAdvAuthImpl;
import com.ca.siteminder.sdk.agentapi.advancedauth.SmAgentApiAdvAuthResult;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnection;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagement;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementException;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementImpl;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementResult;
import com.ca.siteminder.sdk.agentapi.management.SmAgentInstanceDef;
import com.ca.siteminder.sdk.agentapi.management.SmManagementContextDef;
import com.ca.siteminder.sdk.agentapi.management.SmTokenDescriptor;
import com.ca.siteminder.sdk.agentapi.resources.SmAccessControlMessages;
import com.ca.siteminder.sdk.agentapi.resources.SmManagementMessages;
import com.ca.siteminder.sdk.agentapi.resources.SmServicesMessages;
import com.ca.siteminder.sdk.agentapi.resources.SmSessionManagementMessages;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServices;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServicesException;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServicesImpl;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServicesResult;
import com.ca.siteminder.sdk.agentapi.services.SmTunnelServiceRequest;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagement;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagementException;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagementImpl;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagementResult;
import com.netegrity.util.Fips140Mode;
import java.util.List;
import java.util.ResourceBundle;

public class SmAgentApiImpl
implements SmAgentApi,
SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentApiImpl";
    private static final String MESSAGES_ACCESSCONTROL = SmAccessControlMessages.getName();
    private static final String MESSAGES_SESSION = SmSessionManagementMessages.getName();
    private static final String MESSAGES_MANAGEMENT = SmManagementMessages.getName();
    private static final String MESSAGES_SERVICES = SmServicesMessages.getName();
    private static ResourceBundle c_accessControlBundle = ResourceBundle.getBundle(MESSAGES_ACCESSCONTROL);
    private static ResourceBundle c_sessionMgmtBundle = ResourceBundle.getBundle(MESSAGES_SESSION);
    private static ResourceBundle c_managementBundle = ResourceBundle.getBundle(MESSAGES_MANAGEMENT);
    private static ResourceBundle c_servicesBundle = ResourceBundle.getBundle(MESSAGES_SERVICES);
    private SmAgentApiConnection m_connection = null;
    private SmAgentApiAccessControl m_accessControlObj = null;
    private SmAgentApiSessionManagement m_sessionMgmtObj = null;
    private SmAgentApiManagement m_managementObj = null;
    private SmAgentApiServices m_servicesObj = null;
    private SmAgentApiAdvAuth m_advancedAuthObj = null;

    public void init(String configFile) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        this.m_connection = SmAgentApiConnection.getConnection(configFile);
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "init", "Initialized with connection hostname = " + this.m_connection.getHostName());
        }
        this.m_accessControlObj = new SmAgentApiAccessControlImpl(this.m_connection);
        this.m_sessionMgmtObj = new SmAgentApiSessionManagementImpl(this.m_connection);
        this.m_managementObj = new SmAgentApiManagementImpl(this.m_connection);
        this.m_servicesObj = new SmAgentApiServicesImpl(this.m_connection);
        this.m_advancedAuthObj = new SmAgentApiAdvAuthImpl(this.m_connection);
    }

    public void init(SmInitDef initDef) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        Fips140Mode fipsModeObj = Fips140Mode.getFips140ModeObject();
        if (fipsModeObj.isUnset()) {
            if (0 == initDef.getCryptoOpMode()) {
                fipsModeObj.setMode(Util.resolveSetting());
            } else {
                fipsModeObj.setMode(initDef.getCryptoOpMode());
            }
        }
        this.m_connection = SmAgentApiConnection.getConnection(initDef);
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "init", "Initialized with connection hostname = " + this.m_connection.getHostName());
        }
        this.m_accessControlObj = new SmAgentApiAccessControlImpl(this.m_connection);
        this.m_sessionMgmtObj = new SmAgentApiSessionManagementImpl(this.m_connection);
        this.m_managementObj = new SmAgentApiManagementImpl(this.m_connection);
        this.m_servicesObj = new SmAgentApiServicesImpl(this.m_connection);
        this.m_advancedAuthObj = new SmAgentApiAdvAuthImpl(this.m_connection);
    }

    public void close() {
        if (this.m_connection != null) {
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    public String getHostConfigFile() {
        try {
            return this.m_connection.getHostConfigFile().getFilename();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public boolean isConnected() {
        if (this.m_connection == null) {
            return false;
        }
        return !this.m_connection.isClosed();
    }

    protected void finalize() {
        this.close();
    }

    public SmResourceProtectionResult isProtected(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.isProtected(transactionId, userAgentDef, resourceContextDef);
    }

    public SmResourceProtectionResult isProtectedDLP(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.isProtectedDLP(transactionId, userAgentDef, resourceContextDef);
    }

    public SmAuthenticationResult login(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmUserCredentials credentials, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.login(transactionId, userAgentDef, resourceContextDef, realmDef, credentials, authReason);
    }

    public SmAuthenticationResult loginEx(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmUserCredentials credentials, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.loginEx(transactionId, userAgentDef, resourceContextDef, realmDef, credentials, sessionDef, authReason);
    }

    public SmAuthenticationResult validate(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.validate(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef);
    }

    public SmAuthenticationResult validateServiceToken(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.validateServiceToken(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef);
    }

    public SmAuthorizationResult authorize(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.authorize(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef, authReason);
    }

    public SmAuthorizationResult authorize(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason, String unresolvedVariables, String resolvedVariables) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.authorize(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef, authReason, unresolvedVariables, resolvedVariables);
    }

    public SmAuthorizationResult authorizeDLP(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.authorizeDLP(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef, authReason);
    }

    public SmAuthorizationResult authorizeDLP(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason, String unresolvedVariables, String resolvedVariables) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.authorizeDLP(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef, authReason, unresolvedVariables, resolvedVariables);
    }

    public SmAgentApiResult logout(String transactionId, SmUserAgentDef userAgentDef, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.logout(transactionId, userAgentDef, sessionDef, authReason);
    }

    public SmAuditResult audit(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.audit(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef);
    }

    public SmAgentApiSessionManagementResult getSessionVariables(String transactionId, String sessionId, SmResourceContextDef resourceContextDef, List variables) throws SmAgentApiSessionManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_sessionMgmtObj == null) {
            throw new SmAgentApiSessionManagementException(-1, c_sessionMgmtBundle.getString("M_UNINITIALIZED_SESSION"));
        }
        return this.m_sessionMgmtObj.getSessionVariables(transactionId, sessionId, resourceContextDef, variables);
    }

    public SmAgentApiSessionManagementResult setSessionVariables(String transactionId, String sessionId, SmResourceContextDef resourceContextDef, List variables) throws SmAgentApiSessionManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_sessionMgmtObj == null) {
            throw new SmAgentApiSessionManagementException(-1, c_sessionMgmtBundle.getString("M_UNINITIALIZED_SESSION"));
        }
        return this.m_sessionMgmtObj.setSessionVariables(transactionId, sessionId, resourceContextDef, variables);
    }

    public SmAgentApiSessionManagementResult delSessionVariables(String transactionId, String sessionId, SmResourceContextDef resourceContextDef, List variables) throws SmAgentApiSessionManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_sessionMgmtObj == null) {
            throw new SmAgentApiSessionManagementException(-1, c_sessionMgmtBundle.getString("M_UNINITIALIZED_SESSION"));
        }
        return this.m_sessionMgmtObj.delSessionVariables(transactionId, sessionId, resourceContextDef, variables);
    }

    public SmAgentApiManagementResult doManagement(SmManagementContextDef managementContextDef) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_managementObj == null) {
            throw new SmAgentApiManagementException(-1, c_managementBundle.getString("M_UNINITIALIZED_MANAGEMENT"));
        }
        return this.m_managementObj.doManagement(managementContextDef);
    }

    public SmAgentApiManagementResult setAgentInstanceInfo(SmAgentInstanceDef agentInstanceDef) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_managementObj == null) {
            throw new SmAgentApiManagementException(-1, c_managementBundle.getString("M_UNINITIALIZED_MANAGEMENT"));
        }
        return this.m_managementObj.setAgentInstanceInfo(agentInstanceDef);
    }

    public SmAgentApiManagementResult updateAttributes(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, List refreshAttributes) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_managementObj == null) {
            throw new SmAgentApiManagementException(-1, c_managementBundle.getString("M_UNINITIALIZED_MANAGEMENT"));
        }
        return this.m_managementObj.updateAttributes(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef, refreshAttributes);
    }

    public SmAgentApiManagementResult getAgentConfig(String agentConfigName) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_managementObj == null) {
            throw new SmAgentApiManagementException(-1, c_managementBundle.getString("M_UNINITIALIZED_MANAGEMENT"));
        }
        return this.m_managementObj.getAgentConfig(agentConfigName);
    }

    public SmAgentApiManagementResult getHostConfig(String hostConfigName) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_managementObj == null) {
            throw new SmAgentApiManagementException(-1, c_managementBundle.getString("M_UNINITIALIZED_MANAGEMENT"));
        }
        return this.m_managementObj.getHostConfig(hostConfigName);
    }

    public String createSSOToken(SmSessionDef sessionDef, List attributes) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException, SmCryptoProviderException {
        if (this.m_servicesObj == null) {
            throw new SmAgentApiManagementException(-1, c_managementBundle.getString("M_UNINITIALIZED_MANAGEMENT"));
        }
        return this.m_managementObj.createSSOToken(sessionDef, attributes);
    }

    public SmTokenDescriptor decodeSSOToken(String SSOToken, boolean bUpdate) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException, SmCryptoProviderException {
        if (this.m_servicesObj == null) {
            throw new SmAgentApiManagementException(-1, c_managementBundle.getString("M_UNINITIALIZED_MANAGEMENT"));
        }
        return this.m_managementObj.decodeSSOToken(SSOToken, bUpdate);
    }

    public int getTunnelBufferSize() throws SmAgentApiServicesException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_servicesObj == null) {
            throw new SmAgentApiServicesException(-1, c_servicesBundle.getString("M_UNINITIALIZED_SERVICES"));
        }
        return this.m_servicesObj.getTunnelBufferSize();
    }

    public int getMaxTunnelBufferSize() throws SmAgentApiServicesException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_servicesObj == null) {
            throw new SmAgentApiServicesException(-1, c_servicesBundle.getString("M_UNINITIALIZED_SERVICES"));
        }
        return this.m_servicesObj.getMaxTunnelBufferSize();
    }

    public SmAgentApiServicesResult tunnel(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmTunnelServiceRequest tunnelRequest) throws SmAgentApiServicesException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_servicesObj == null) {
            throw new SmAgentApiServicesException(-1, c_servicesBundle.getString("M_UNINITIALIZED_SERVICES"));
        }
        return this.m_servicesObj.tunnel(transactionId, userAgentDef, resourceContextDef, tunnelRequest);
    }

    public String getAdvAuthToken(String transactionId, String advAuthTokenId) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_advancedAuthObj == null) {
            throw new SmAgentApiAdvAuthException(-1, "The advanced auth interface is not initialized.");
        }
        return this.m_advancedAuthObj.getAdvAuthToken(transactionId, advAuthTokenId);
    }

    public String peekAdvAuthToken(String transactionId, String advAuthTokenId) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_advancedAuthObj == null) {
            throw new SmAgentApiAdvAuthException(-1, "The advanced auth interface is not initialized.");
        }
        return this.m_advancedAuthObj.peekAdvAuthToken(transactionId, advAuthTokenId);
    }

    public SmAgentApiAdvAuthResult setAdvAuthToken(String transactionId, String advAuthTokenId, String advAuthTokenData) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_advancedAuthObj == null) {
            throw new SmAgentApiAdvAuthException(-1, "The advanced auth interface is not initialized.");
        }
        return this.m_advancedAuthObj.setAdvAuthToken(transactionId, advAuthTokenId, advAuthTokenData);
    }

    public SmAgentApiAdvAuthResult deleteAdvAuthToken(String transactionId, String advAuthTokenId) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_advancedAuthObj == null) {
            throw new SmAgentApiAdvAuthException(-1, "The advanced auth interface is not initialized.");
        }
        return this.m_advancedAuthObj.deleteAdvAuthToken(transactionId, advAuthTokenId);
    }

    public SmVerifyCredsResult verifyCredentials(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmUserCredentials credentials, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_accessControlObj == null) {
            throw new SmAgentApiAccessControlException(-1, c_accessControlBundle.getString("M_UNINITIALIZED_ACCESSCONTROL"));
        }
        return this.m_accessControlObj.verifyCredentials(transactionId, userAgentDef, resourceContextDef, realmDef, credentials, authReason);
    }

    public SATokenRequest getSARequestToken(String transactionId, String saTokenReqID) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_advancedAuthObj == null) {
            throw new SmAgentApiAdvAuthException(-1, "The advanced auth interface is not initialized.");
        }
        return this.m_advancedAuthObj.getSARequestToken(transactionId, saTokenReqID);
    }

    public SmAgentApiAdvAuthResult setSAResponseToken(String transactionId, String saTokenRespID, SATokenResponse saTokenResp) throws SmAgentApiAdvAuthException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_advancedAuthObj == null) {
            throw new SmAgentApiAdvAuthException(-1, "The advanced auth interface is not initialized.");
        }
        return this.m_advancedAuthObj.setSAResponseToken(transactionId, saTokenRespID, saTokenResp);
    }
}

