/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.tli;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTcpIPv6Transport;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTransport;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.Iterator;

public class SmAgentTcpTransport
implements SmAgentTransport,
SmAgentApiConstants {
    private int connectionTimeout;
    private static final String CLASS_NAME = "SmAgentTcpTransport";
    private Selector m_selector;
    private SelectionKey m_selectionKey;
    private SocketChannel m_socketChannel;

    public static final SmAgentTcpTransport newInstance(SocketAddress socketAddress) throws IOException {
        if (socketAddress instanceof InetSocketAddress) {
            boolean useIPv6 = ((InetSocketAddress)socketAddress).getAddress() instanceof Inet6Address;
            return SmAgentTcpTransport.newInstance(useIPv6);
        }
        throw new IllegalArgumentException("use InetSocketAddress");
    }

    public static final SmAgentTcpTransport newInstance(boolean useIPv6) throws IOException {
        String methodName = "newInstance";
        String OS = System.getProperty("os.name");
        if (-1 != OS.indexOf("Windows") && useIPv6) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "newInstance", "Platform is Windows and is IPv6, using class SmAgentTcpIPv6WinTransport");
            }
            return new SmAgentTcpIPv6Transport(new Socket());
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "newInstance", "Using SmAgentTcpTransport class");
        }
        return new SmAgentTcpTransport(Selector.open(), SocketChannel.open());
    }

    protected void finalize() throws Throwable {
        if (this.m_selectionKey != null) {
            try {
                this.m_selectionKey.cancel();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.m_socketChannel != null) {
            try {
                this.m_socketChannel.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.m_selector != null) {
            try {
                this.m_selector.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    protected SmAgentTcpTransport(Selector selector, SocketChannel socketChannel) {
        block4: {
            this.connectionTimeout = 3000;
            String methodName = CLASS_NAME;
            this.m_selector = selector;
            this.m_socketChannel = socketChannel;
            String timeoutStr = System.getProperty("NONBLOCKING_CONNECTION_SLEEP_TIME");
            if (timeoutStr != null) {
                try {
                    this.connectionTimeout = Integer.parseInt(timeoutStr);
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, CLASS_NAME, "Modifying nonblocking connection sleep time to " + this.connectionTimeout);
                    }
                }
                catch (NumberFormatException e) {
                    if (!Util.isLogEnabled()) break block4;
                    Util.display(2, CLASS_NAME, CLASS_NAME, e.toString());
                }
            }
        }
    }

    public boolean isConnected() {
        return this.m_socketChannel.isConnected();
    }

    public boolean connect(SocketAddress sa) throws IOException, UnresolvedAddressException {
        block7: {
            String methodName = "connect";
            try {
                String keepAliveSetting = System.getenv("SM_ENABLE_TCP_KEEPALIVE");
                if (keepAliveSetting != null && 1 == Integer.parseInt(keepAliveSetting)) {
                    Socket sock = this.m_socketChannel.socket();
                    sock.setKeepAlive(true);
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "connect", "SM_ENABLE_TCP_KEEPALIVE is enabled, setting keep alive option");
                    }
                }
            }
            catch (SecurityException e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "connect", "Unable to get SM_ENABLE_TCP_KEEPALIVE environment variable : " + e);
                }
            }
            catch (NumberFormatException e) {
                if (!Util.isLogEnabled()) break block7;
                Util.display(2, CLASS_NAME, "connect", "Unable to parse SM_ENABLE_TCP_KEEPALIVE as integer : " + e);
            }
        }
        if (this.m_socketChannel.connect(sa)) {
            this.m_socketChannel.configureBlocking(false);
            return true;
        }
        return false;
    }

    public int write(ByteBuffer buf) throws IOException {
        return this.write(buf, 0L);
    }

    public int write(ByteBuffer buf, long timeout) throws IOException {
        long dropDeadTime;
        String methodName = "write";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "write", "tcp write: timeout " + timeout);
        }
        long l = dropDeadTime = timeout > 0L ? System.currentTimeMillis() + timeout : timeout;
        if (this.m_selectionKey == null) {
            this.m_selectionKey = this.m_socketChannel.register(this.m_selector, 4);
        } else {
            this.m_selectionKey.interestOps(4);
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "write", "tcp write: registered selector...valid status = " + this.m_selectionKey.isValid());
        }
        int writeLength = buf.remaining();
        int bytesWritten = 0;
        Throwable removeFailure = null;
        do {
            int numChans = 0;
            long now = System.currentTimeMillis();
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "write", "dropDeadTime = " + dropDeadTime + ", bytesWritten = " + bytesWritten + ", writeLength = " + writeLength);
            }
            if (dropDeadTime > 0L && now >= dropDeadTime) {
                Util.display(5, CLASS_NAME, "write", "tcp write: timeout!");
                return bytesWritten > 0 ? bytesWritten : -2;
            }
            if (removeFailure != null) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "write", "Failed to clean up selection set: " + removeFailure);
                    removeFailure.printStackTrace();
                }
                removeFailure = null;
            }
            Util.display(5, CLASS_NAME, "write", "tcp write: trying to write...");
            try {
                if (Util.isLogEnabled()) {
                    SelectionKey testKey = this.m_socketChannel.keyFor(this.m_selector);
                    if (testKey == null) {
                        Util.display(5, CLASS_NAME, "write", "tcp write: NO KEY FOR CHANNEL!");
                    } else {
                        Util.display(5, CLASS_NAME, "write", "tcp write: chan interest mask = " + testKey.interestOps());
                    }
                }
                if (dropDeadTime < 0L) {
                    numChans = this.m_selector.selectNow();
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "write", "dropDeadTime < 0 selected total channels = " + numChans);
                    }
                } else if (dropDeadTime == 0L) {
                    numChans = this.m_selector.select();
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "write", "0 dropDeadTime selected total channels = " + numChans);
                    }
                } else {
                    long maxTO = dropDeadTime - now;
                    numChans = this.m_selector.select(maxTO);
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "write", "Selected channels with maxTO = " + maxTO + " is " + numChans);
                    }
                }
            }
            catch (IOException e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "write", "IOException trying to select a channel: " + e);
                }
                throw e;
            }
            if (numChans == 0) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "write", "numChans = 0, bytes written = " + bytesWritten);
                }
                return bytesWritten > 0 ? bytesWritten : -2;
            }
            Iterator<SelectionKey> it = this.m_selector.selectedKeys().iterator();
            SelectionKey curKey = it.next();
            try {
                it.remove();
            }
            catch (RuntimeException e) {
                removeFailure = e;
            }
            try {
                if (!curKey.isValid() || !curKey.isWritable()) continue;
                SocketChannel chan = (SocketChannel)curKey.channel();
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "write", "tcp write: buf limit " + buf.limit() + ", capacity " + buf.capacity() + ", remaining " + buf.remaining());
                }
                int curBytesWritten = chan.write(buf);
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "write", "Current bytes written to the channel = " + curBytesWritten);
                }
                if (curBytesWritten < 0) {
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "write", "Current channel bytes written < 0, " + (curBytesWritten == -1 ? "EOF from server" : "Unknown error."));
                    }
                    throw new IOException();
                }
                bytesWritten += curBytesWritten;
            }
            catch (IOException e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "write", "IOException writing to the channel: " + e);
                }
                throw e;
            }
        } while (dropDeadTime >= 0L && bytesWritten < writeLength);
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "write", "Completed execution bytes written = " + bytesWritten);
        }
        return bytesWritten;
    }

    public int read(ByteBuffer buf, int len) throws IOException {
        return this.read(buf, len, 0L);
    }

    public int read(ByteBuffer buffer, int readLength, long timeout) throws IOException {
        String methodName = "read";
        if (buffer.capacity() < readLength) {
            throw new BufferOverflowException();
        }
        long dropDeadTime = timeout > 0L ? System.currentTimeMillis() + timeout : timeout;
        buffer.clear();
        buffer.limit(readLength);
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "read", "Reading " + readLength + " bytes with timeout of " + timeout + "ms");
        }
        if (this.m_selectionKey == null) {
            this.m_selectionKey = this.m_socketChannel.register(this.m_selector, 1);
        } else {
            this.m_selectionKey.interestOps(1);
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "read", "tcp read: registered selector...valid status = " + this.m_selectionKey.isValid());
        }
        int bytesRead = 0;
        Throwable removeFailure = null;
        do {
            int numChans = 0;
            long now = System.currentTimeMillis();
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "read", "dropDeadTime = " + dropDeadTime + ", bytesRead = " + bytesRead + ", readLength = " + readLength);
            }
            if (dropDeadTime > 0L && now >= dropDeadTime) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "read", "now >= dropDeadTime > 0, bytesRead = " + bytesRead);
                }
                return bytesRead > 0 ? bytesRead : -2;
            }
            if (removeFailure != null) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "read", "Failed to clean up selection set: " + removeFailure);
                    removeFailure.printStackTrace();
                }
                removeFailure = null;
            }
            try {
                if (Util.isLogEnabled()) {
                    SelectionKey testKey = this.m_socketChannel.keyFor(this.m_selector);
                    if (testKey == null) {
                        Util.display(5, CLASS_NAME, "read", "tcp read: NO KEY FOR CHANNEL!");
                    } else {
                        Util.display(5, CLASS_NAME, "read", "tcp read: chan interest mask = " + testKey.interestOps());
                    }
                }
                if (dropDeadTime < 0L) {
                    numChans = this.m_selector.selectNow();
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "read", "dropDeadTime < 0 selected total channels = " + numChans);
                    }
                } else if (dropDeadTime == 0L) {
                    numChans = this.m_selector.select();
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "read", "0 dropDeadTime selected total channels = " + numChans);
                    }
                } else {
                    long maxTO = dropDeadTime - now;
                    numChans = this.m_selector.select(maxTO);
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "read", "Selected channels with maxTO = " + maxTO + " is " + numChans);
                    }
                }
            }
            catch (IOException e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "read", "IOException trying to select a channel: " + e);
                }
                throw e;
            }
            if (numChans == 0) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "read", "numChans = 0, bytes read = " + bytesRead);
                }
                return bytesRead > 0 ? bytesRead : -2;
            }
            Iterator<SelectionKey> it = this.m_selector.selectedKeys().iterator();
            SelectionKey curKey = it.next();
            try {
                it.remove();
            }
            catch (RuntimeException e) {
                removeFailure = e;
            }
            try {
                if (!curKey.isValid() || !curKey.isReadable()) continue;
                SocketChannel chan = (SocketChannel)curKey.channel();
                int curReadBytes = chan.read(buffer);
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "read", "Current bytes read from the channel = " + curReadBytes);
                }
                if (curReadBytes < 0) {
                    if (!Util.isLogEnabled()) break;
                    Util.display(4, CLASS_NAME, "read", "Current channel bytes read < 0, " + (curReadBytes == -1 ? "EOF from server" : "Unknown error."));
                    break;
                }
                bytesRead += curReadBytes;
            }
            catch (IOException e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "read", "IOException reading the channel: " + e);
                }
                throw e;
            }
        } while (dropDeadTime >= 0L && bytesRead < readLength);
        if (bytesRead > 0) {
            buffer.flip();
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "read", "Completed execution: bytes read = " + bytesRead + ", returning " + (bytesRead > 0 ? bytesRead : -2));
        }
        return bytesRead > 0 ? bytesRead : -2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() throws IOException {
        if (this.m_selectionKey != null) {
            try {
                this.m_selectionKey.cancel();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.m_socketChannel == null) return;
        if (this.m_socketChannel.socket() != null) {
            try {
                this.m_socketChannel.socket().setSoLinger(true, 0);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.m_socketChannel.close();
            Object var3_5 = null;
            if (this.m_selector == null) return;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (this.m_selector == null) throw throwable;
            this.m_selector.close();
            throw throwable;
        }
        this.m_selector.close();
    }

    public void setupDataChannel() {
        try {
            this.m_socketChannel.socket().setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

