/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.services;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceContextDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserAgentDef;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnection;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.resources.SmServicesMessages;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServices;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServicesException;
import com.ca.siteminder.sdk.agentapi.services.SmAgentApiServicesResult;
import com.ca.siteminder.sdk.agentapi.services.SmTunnelServiceRequest;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.ResourceBundle;

public class SmAgentApiServicesImpl
implements SmAgentApiServices,
SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentApiServicesImpl";
    private static final String MESSAGES_CLASSNAME = SmServicesMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private SmAgentApiConnection m_connection = null;

    public SmAgentApiServicesImpl(SmAgentApiConnection connection) {
        this.m_connection = connection;
    }

    public int getTunnelBufferSize() throws SmAgentApiServicesException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        return this.m_connection.getBufferSize();
    }

    public int getMaxTunnelBufferSize() throws SmAgentApiServicesException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        return this.m_connection.getMaxBufferSize();
    }

    public SmAgentApiServicesResult tunnel(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmTunnelServiceRequest tunnelRequest) throws SmAgentApiServicesException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (resourceContextDef != null && (resourceContextDef.getServer() == null || resourceContextDef.getResource() == null || resourceContextDef.getAction() == null)) {
            throw new SmAgentApiServicesException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        if (tunnelRequest == null || tunnelRequest.getLibrary() == null || tunnelRequest.getFunction() == null) {
            throw new SmAgentApiServicesException(-4, c_bundle.getString("M_INVALID_TUNNEL_REQUEST"));
        }
        if (tunnelRequest.getData() == null || tunnelRequest.getData().length == 0) {
            byte[] data = new byte[1];
            Arrays.fill(data, (byte)0);
            tunnelRequest.setData(data);
        } else if (tunnelRequest.getData().length > this.getMaxTunnelBufferSize()) {
            throw new SmAgentApiServicesException(-4, c_bundle.getString("M_INVALID_TUNNEL_REQUEST"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(8);
        try {
            if (userAgentDef != null && userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            if (resourceContextDef != null) {
                String agent = this.m_connection.getAgentName(resourceContextDef);
                if (agent == null) {
                    throw new SmAgentApiServicesException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
                }
                request.setAttribute(200, agent.getBytes("UTF-8"));
                request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
                request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
                request.setAttribute(202, resourceContextDef.getAction().getBytes("UTF-8"));
            }
            request.setAttribute(161, tunnelRequest.getLibrary().getBytes("UTF-8"));
            request.setAttribute(162, tunnelRequest.getFunction().getBytes("UTF-8"));
            request.setAttribute(164, tunnelRequest.getData());
            if (tunnelRequest.getParameter() != null) {
                request.setAttribute(163, tunnelRequest.getParameter().getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiServicesException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiServicesException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            Util.display(2, CLASS_NAME, "tunnel", "processRequest returned null response");
            throw new SmAgentApiServicesException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        if (code != 2 && code != 3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "tunnel", "processRequest returned unknown response code " + code);
            }
            throw new SmAgentApiServicesException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        boolean result = false;
        if (code == 2) {
            result = true;
        }
        return new SmAgentApiServicesResult(result, response.getAttributes());
    }
}

