/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.UtilLog;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.netegrity.util.AesCryptoProviderTli;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

class SmAesCryptoTliProvider
extends SmCryptoProvider {
    private static final String CLASS_NAME = "SmAesCryptoTliProvider";
    private AesCryptoProviderTli m_AesCryptoProviderTli;

    SmAesCryptoTliProvider() throws SmCryptoProviderException {
        this.m_transformation = "AES/OFB/NoPadding";
        this.m_algorithm = "AES";
        this.m_digestAlg = "HmacSHA256";
        this.m_digestLength = 32;
        this.m_keyDigestAlg = "SHA256";
        this.m_verifyDigest = true;
        this.m_bAscii = false;
        this.m_keySize = 16;
        this.m_bCipherCanDoFinal = false;
        try {
            this.m_AesCryptoProviderTli = new AesCryptoProviderTli();
        }
        catch (Throwable e) {
            throw new SmCryptoProviderException(e);
        }
    }

    public void init(byte[] keyingMaterial, int keyStrength) throws SmCryptoProviderException {
        int status = this.m_AesCryptoProviderTli.Init(keyingMaterial, keyStrength, true);
        if (0 != status) {
            throw new SmCryptoProviderException(c_bundle.getString("M_INIT_SESSION_ERROR"));
        }
    }

    public void init(byte[] encryptKey, byte[] decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public void init(Key encryptKey, byte[] decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public void init(byte[] encryptKey, Key decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public void init(Key encryptKey, Key decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public byte[] encrypt(byte[] input, int inLength) throws SmCryptoProviderException {
        String methodName = "encrypt";
        byte[] encbuff = null;
        if (input == null || inLength < 0 || inLength > input.length) {
            UtilLog.display(3, CLASS_NAME, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        encbuff = this.m_AesCryptoProviderTli.Encrypt(input, inLength);
        return encbuff;
    }

    public byte[] decrypt(byte[] input, int inLength) throws SmCryptoProviderException {
        String methodName = "decrypt";
        byte[] clearbuff = null;
        if (input == null || inLength <= 0 || inLength > input.length) {
            UtilLog.display(3, CLASS_NAME, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        clearbuff = this.m_AesCryptoProviderTli.Decrypt(input, inLength);
        return clearbuff;
    }

    public Key generateKey() throws SmCryptoProviderException {
        Object key = null;
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    protected Cipher getEncrypter() throws GeneralSecurityException, SmCryptoProviderException {
        Object cipher = null;
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    protected Cipher getDecrypter() throws GeneralSecurityException, SmCryptoProviderException {
        Object cipher = null;
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    protected int getBlockSize() throws GeneralSecurityException {
        return 16;
    }

    protected byte[] generateKeyData(byte[] input) throws NoSuchAlgorithmException {
        if (input == null) {
            return null;
        }
        throw new NoSuchAlgorithmException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }
}

