/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.accesscontrol;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiResult;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAgentApiAccessControl;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAgentApiAccessControlException;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuditResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuthenticationResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmAuthorizationResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmRealmDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceContextDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceProtectionResult;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmSessionDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserAgentDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserCredentials;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmVerifyCredsResult;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnection;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.resources.SmAccessControlMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class SmAgentApiAccessControlImpl
implements SmAgentApiAccessControl,
SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentApiAccessControlImpl";
    private static final String MESSAGES_CLASSNAME = SmAccessControlMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private SmAgentApiConnection m_connection = null;

    public SmAgentApiAccessControlImpl(SmAgentApiConnection connection) {
        this.m_connection = connection;
    }

    public SmResourceProtectionResult isProtected(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String agent;
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if ((agent = this.m_connection.getAgentName(resourceContextDef)) == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(9);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, action.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        boolean result = false;
        if (code == 2) {
            result = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        String realmName = null;
        String domainOid = null;
        String realmOid = null;
        String formLoc = null;
        int credentials = -1;
        List attributes = response.getAttributes();
        if (attributes == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        for (SmAttribute attr : attributes) {
            if (attr == null) continue;
            try {
                switch (attr.getId()) {
                    case 203: {
                        realmName = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                    case 150: {
                        domainOid = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                    case 204: {
                        realmOid = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                    case 219: {
                        byte[] attrValue = attr.getValue();
                        if (attrValue != null && attrValue.length > 0) {
                            credentials = Integer.parseInt(new String(attrValue, "UTF-8"));
                            break;
                        }
                        credentials = 0;
                        break;
                    }
                    case 220: {
                        formLoc = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmRealmDef realmDef = new SmRealmDef(realmName, realmOid, domainOid, credentials, formLoc);
        return new SmResourceProtectionResult(result, response.getAttributes(), realmDef);
    }

    public SmResourceProtectionResult isProtectedDLP(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String agent;
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if ((agent = this.m_connection.getAgentName(resourceContextDef)) == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(15);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, action.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        boolean result = false;
        if (code == 2) {
            result = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        String realmName = null;
        String domainOid = null;
        String realmOid = null;
        String formLoc = null;
        int credentials = -1;
        List attributes = response.getAttributes();
        if (attributes == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        for (SmAttribute attr : attributes) {
            if (attr == null) continue;
            try {
                switch (attr.getId()) {
                    case 203: {
                        realmName = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                    case 150: {
                        domainOid = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                    case 204: {
                        realmOid = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                    case 219: {
                        credentials = Integer.parseInt(new String(attr.getValue(), "UTF-8"));
                        break;
                    }
                    case 220: {
                        formLoc = new String(attr.getValue(), "UTF-8");
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmRealmDef realmDef = new SmRealmDef(realmName, realmOid, domainOid, credentials, formLoc);
        return new SmResourceProtectionResult(result, response.getAttributes(), realmDef);
    }

    public SmAuthenticationResult login(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmUserCredentials credentials, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.loginEx(transactionId, userAgentDef, resourceContextDef, realmDef, credentials, null, authReason);
    }

    public SmAuthenticationResult loginEx(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmUserCredentials credentials, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "login";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if (realmDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (credentials == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_CREDS"));
        }
        if (sessionDef != null && (sessionDef.getId() == null || sessionDef.getSpec() == null)) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        if (realmDef.getOid() == null) {
            return new SmAuthenticationResult(false);
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(1);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, action.getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            if (sessionDef != null) {
                request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
                request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
            } else {
                request.setAttribute(205, "".getBytes("UTF-8"));
                request.setAttribute(209, "".getBytes("UTF-8"));
            }
            request.setAttribute(212, SmAgentApiAccessControlImpl.getBinaryIntValue(authReason));
            if (credentials.getName() != null) {
                request.setAttribute(210, credentials.getName().getBytes("UTF-8"));
            }
            if (credentials.getPassword() != null) {
                request.setAttribute(211, credentials.getPassword().getBytes("UTF-8"));
            }
            if (credentials.getCertUserDN() != null) {
                request.setAttribute(207, credentials.getCertUserDN().getBytes("UTF-8"));
            }
            if (credentials.getCertIssuerDN() != null) {
                request.setAttribute(222, credentials.getCertIssuerDN().getBytes("UTF-8"));
            }
            if (credentials.getBinaryCreds() != null) {
                request.setAttribute(206, credentials.getBinaryCreds());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "login", "TLI auth response status = " + status[0] + ", type = " + response.getType());
        }
        int code = response.getType();
        boolean result = false;
        boolean challenge = false;
        if (code == 2) {
            result = true;
        } else if (code == 4) {
            challenge = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        int reason = 0;
        int currentTime = -1;
        int startTime = -1;
        int lastTime = -1;
        int idleTimeout = -1;
        int maxTimeout = -1;
        String sessionId = "";
        String sessionSpec = "";
        List responseAttributes = response.getAttributes();
        ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
        if (responseAttributes == null) {
            if (code == 3) {
                return new SmAuthenticationResult(false);
            }
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        block15: for (SmAttribute responseAttribute : responseAttributes) {
            if (responseAttribute == null) continue;
            try {
                switch (responseAttribute.getId()) {
                    case 212: {
                        reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        if (!Util.isLogEnabled()) continue block15;
                        Util.display(5, CLASS_NAME, "login", "Processing tli attr reason - setting = " + reason);
                        break;
                    }
                    case 153: {
                        currentTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 154: {
                        startTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 155: {
                        lastTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 225: {
                        idleTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 226: {
                        maxTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 205: {
                        sessionId = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 209: {
                        sessionSpec = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    default: {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "login", "Adding result attribute id = " + responseAttribute.getId());
                        }
                        resultAttributes.add(responseAttribute);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmSessionDef session = new SmSessionDef(idleTimeout, maxTimeout, currentTime, startTime, lastTime, sessionId, sessionSpec);
        return new SmAuthenticationResult(result, resultAttributes, reason, session, challenge);
    }

    public SmAuthenticationResult validate(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "validate";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if (realmDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (sessionDef == null || sessionDef.getId() == null || sessionDef.getSpec() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        if (realmDef.getOid() == null) {
            return new SmAuthenticationResult(false);
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(11);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, resourceContextDef.getAction().getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
            request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        boolean result = false;
        boolean challenge = false;
        if (code == 2) {
            result = true;
        } else if (code == 4) {
            challenge = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        int reason = 0;
        int currentTime = -1;
        int startTime = -1;
        int lastTime = -1;
        int idleTimeout = -1;
        int maxTimeout = -1;
        String sessionId = null;
        String sessionSpec = null;
        List responseAttributes = response.getAttributes();
        ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
        if (responseAttributes == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        for (SmAttribute responseAttribute : responseAttributes) {
            if (responseAttribute == null) continue;
            try {
                switch (responseAttribute.getId()) {
                    case 212: {
                        reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 153: {
                        currentTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 154: {
                        startTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 155: {
                        lastTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 225: {
                        idleTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 226: {
                        maxTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 205: {
                        sessionId = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 209: {
                        sessionSpec = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    default: {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "validate", "Adding result attribute id = " + responseAttribute.getId());
                        }
                        resultAttributes.add(responseAttribute);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmSessionDef session = new SmSessionDef(idleTimeout, maxTimeout, currentTime, startTime, lastTime, sessionId, sessionSpec);
        return new SmAuthenticationResult(result, resultAttributes, reason, session, challenge);
    }

    public SmAuthenticationResult validateServiceToken(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "validate";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if (realmDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (sessionDef == null || sessionDef.getId() == null || sessionDef.getSpec() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        if (realmDef.getOid() == null) {
            return new SmAuthenticationResult(false);
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(17);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, resourceContextDef.getAction().getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
            request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        boolean result = false;
        boolean challenge = false;
        if (code == 2) {
            result = true;
        } else if (code == 4) {
            challenge = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        int reason = 0;
        int currentTime = -1;
        int startTime = -1;
        int lastTime = -1;
        int idleTimeout = -1;
        int maxTimeout = -1;
        String sessionId = null;
        String sessionSpec = null;
        List responseAttributes = response.getAttributes();
        ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
        if (responseAttributes == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        for (SmAttribute responseAttribute : responseAttributes) {
            if (responseAttribute == null) continue;
            try {
                switch (responseAttribute.getId()) {
                    case 212: {
                        reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 153: {
                        currentTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 154: {
                        startTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 155: {
                        lastTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 225: {
                        idleTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 226: {
                        maxTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 205: {
                        sessionId = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 209: {
                        sessionSpec = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    default: {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "validate", "Adding result attribute id = " + responseAttribute.getId());
                        }
                        resultAttributes.add(responseAttribute);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmSessionDef session = new SmSessionDef(idleTimeout, maxTimeout, currentTime, startTime, lastTime, sessionId, sessionSpec);
        return new SmAuthenticationResult(result, resultAttributes, reason, session, challenge);
    }

    public SmAuthorizationResult authorize(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.authorize(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef, authReason, null, null);
    }

    public SmAuthorizationResult authorize(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason, String unresolvedVariables, String resolvedVariables) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "authorize";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        if (resourceContextDef.getResource() == null) {
            return new SmAuthorizationResult(false);
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if (realmDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (sessionDef == null || sessionDef.getId() == null || sessionDef.getSpec() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        if (realmDef.getOid() == null) {
            return new SmAuthorizationResult(false);
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(10);
        try {
            if (authReason != 0) {
                request.setAttribute(212, SmAgentApiAccessControlImpl.getBinaryIntValue(authReason));
            }
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, action.getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
            request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
            if (unresolvedVariables != null) {
                request.setAttribute(146, unresolvedVariables.getBytes("UTF-8"));
            }
            if (resolvedVariables != null) {
                request.setAttribute(147, resolvedVariables.getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "authorize", "TLI AZ response status = " + status[0] + ", type = " + response.getType());
        }
        int code = response.getType();
        boolean result = false;
        boolean unresolved = false;
        if (code == 2) {
            result = true;
        } else if (code == 4) {
            unresolved = true;
        } else if (code == 5) {
            unresolved = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        int reason = 0;
        int currentTime = -1;
        int startTime = -1;
        int lastTime = -1;
        int idleTimeout = -1;
        int maxTimeout = -1;
        String sessionId = null;
        String sessionSpec = null;
        String unresolvedAttributes = null;
        String resolvedAttributes = null;
        List responseAttributes = response.getAttributes();
        ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
        if (responseAttributes == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        block17: for (SmAttribute responseAttribute : responseAttributes) {
            if (responseAttribute == null) continue;
            try {
                switch (responseAttribute.getId()) {
                    case 212: {
                        reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        if (!Util.isLogEnabled()) continue block17;
                        Util.display(5, CLASS_NAME, "authorize", "Processing tli attr reason - setting = " + reason);
                        break;
                    }
                    case 153: {
                        currentTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 154: {
                        startTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 155: {
                        lastTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 225: {
                        idleTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 226: {
                        maxTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 205: {
                        sessionId = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 209: {
                        sessionSpec = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 146: {
                        unresolvedAttributes = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 147: {
                        resolvedAttributes = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    default: {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "authorize", "Adding result attribute id = " + responseAttribute.getId());
                        }
                        resultAttributes.add(responseAttribute);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmSessionDef session = new SmSessionDef(idleTimeout, maxTimeout, currentTime, startTime, lastTime, sessionId, sessionSpec);
        return new SmAuthorizationResult(result, resultAttributes, reason, session, resolvedAttributes, unresolvedAttributes, unresolved);
    }

    public SmAuthorizationResult authorizeDLP(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.authorizeDLP(transactionId, userAgentDef, resourceContextDef, realmDef, sessionDef, authReason, null, null);
    }

    public SmAuthorizationResult authorizeDLP(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, int authReason, String unresolvedVariables, String resolvedVariables) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "authorize";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        if (resourceContextDef.getResource() == null) {
            return new SmAuthorizationResult(false);
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if (realmDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (sessionDef == null || sessionDef.getId() == null || sessionDef.getSpec() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        if (realmDef.getOid() == null) {
            return new SmAuthorizationResult(false);
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(16);
        try {
            if (authReason != 0) {
                request.setAttribute(212, SmAgentApiAccessControlImpl.getBinaryIntValue(authReason));
            }
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, action.getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
            request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
            if (unresolvedVariables != null) {
                request.setAttribute(146, unresolvedVariables.getBytes("UTF-8"));
            }
            if (resolvedVariables != null) {
                request.setAttribute(147, resolvedVariables.getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "authorize", "TLI AZ response status = " + status[0] + ", type = " + response.getType());
        }
        int code = response.getType();
        boolean result = false;
        boolean unresolved = false;
        if (code == 2) {
            result = true;
        } else if (code == 4) {
            unresolved = true;
        } else if (code == 5) {
            unresolved = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        int reason = 0;
        int currentTime = -1;
        int startTime = -1;
        int lastTime = -1;
        int idleTimeout = -1;
        int maxTimeout = -1;
        String sessionId = null;
        String sessionSpec = null;
        String unresolvedAttributes = null;
        String resolvedAttributes = null;
        List responseAttributes = response.getAttributes();
        ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
        if (responseAttributes == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        block17: for (SmAttribute responseAttribute : responseAttributes) {
            if (responseAttribute == null) continue;
            try {
                switch (responseAttribute.getId()) {
                    case 212: {
                        reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        if (!Util.isLogEnabled()) continue block17;
                        Util.display(5, CLASS_NAME, "authorize", "Processing tli attr reason - setting = " + reason);
                        break;
                    }
                    case 153: {
                        currentTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 154: {
                        startTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 155: {
                        lastTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 225: {
                        idleTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 226: {
                        maxTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 205: {
                        sessionId = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 209: {
                        sessionSpec = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 146: {
                        unresolvedAttributes = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 147: {
                        resolvedAttributes = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    default: {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "authorize", "Adding result attribute id = " + responseAttribute.getId());
                        }
                        resultAttributes.add(responseAttribute);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmSessionDef session = new SmSessionDef(idleTimeout, maxTimeout, currentTime, startTime, lastTime, sessionId, sessionSpec);
        return new SmAuthorizationResult(result, resultAttributes, reason, session, resolvedAttributes, unresolvedAttributes, unresolved);
    }

    public SmAgentApiResult logout(String transactionId, SmUserAgentDef userAgentDef, SmSessionDef sessionDef, int authReason) throws SmAgentApiAccessControlException, SmAgentApiNotInitializedException {
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (sessionDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        if (sessionDef.getId() == null || sessionDef.getSpec() == null) {
            return new SmAgentApiResult(false, null);
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(2);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
            request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
            if (authReason != 0) {
                request.setAttribute(212, SmAgentApiAccessControlImpl.getBinaryIntValue(authReason));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        boolean result = false;
        if (code == 2) {
            result = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        return new SmAgentApiResult(result, response.getAttributes());
    }

    public SmAuditResult audit(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "audit";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null || resourceContextDef.getAction() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        if (realmDef == null || realmDef.getOid() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (sessionDef == null || sessionDef.getId() == null || sessionDef.getSpec() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(5);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, resourceContextDef.getAction().getBytes("UTF-8"));
            request.setAttribute(150, realmDef.getDomainOid().getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
            request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        boolean result = false;
        if (code == 2) {
            result = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        int reason = 0;
        int currentTime = -1;
        int startTime = -1;
        int lastTime = -1;
        int idleTimeout = -1;
        int maxTimeout = -1;
        String sessionId = null;
        String sessionSpec = null;
        List responseAttributes = response.getAttributes();
        ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
        if (responseAttributes == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        block15: for (SmAttribute responseAttribute : responseAttributes) {
            if (responseAttribute == null) continue;
            try {
                switch (responseAttribute.getId()) {
                    case 212: {
                        reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        if (!Util.isLogEnabled()) continue block15;
                        Util.display(5, CLASS_NAME, "audit", "Processing tli attr reason - setting = " + reason);
                        break;
                    }
                    case 153: {
                        currentTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 154: {
                        startTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 155: {
                        lastTime = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 225: {
                        idleTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 226: {
                        maxTimeout = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        break;
                    }
                    case 205: {
                        sessionId = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    case 209: {
                        sessionSpec = new String(responseAttribute.getValue(), "UTF-8");
                        break;
                    }
                    default: {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "audit", "Adding result attribute id = " + responseAttribute.getId());
                        }
                        resultAttributes.add(responseAttribute);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SmAgentApiAccessControlException(uee);
            }
        }
        SmSessionDef session = new SmSessionDef(idleTimeout, maxTimeout, currentTime, startTime, lastTime, sessionId, sessionSpec);
        return new SmAuditResult(result, resultAttributes, reason, session);
    }

    public SmVerifyCredsResult verifyCredentials(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmUserCredentials credentials, int authReason) throws SmAgentApiAccessControlException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "verifycredentials";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        String action = resourceContextDef.getAction();
        if (action == null) {
            action = "";
        }
        if (realmDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (userAgentDef == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (credentials == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_USER_CREDS"));
        }
        if (realmDef.getOid() == null) {
            return new SmVerifyCredsResult(false);
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiAccessControlException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(19);
        try {
            if (userAgentDef.getClientIpAddress() != null) {
                request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            }
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, action.getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            request.setAttribute(212, SmAgentApiAccessControlImpl.getBinaryIntValue(authReason));
            if (credentials.getName() != null) {
                request.setAttribute(210, credentials.getName().getBytes("UTF-8"));
            }
            if (credentials.getPassword() != null) {
                request.setAttribute(211, credentials.getPassword().getBytes("UTF-8"));
            }
            if (credentials.getCertUserDN() != null) {
                request.setAttribute(207, credentials.getCertUserDN().getBytes("UTF-8"));
            }
            if (credentials.getCertIssuerDN() != null) {
                request.setAttribute(222, credentials.getCertIssuerDN().getBytes("UTF-8"));
            }
            if (credentials.getBinaryCreds() != null) {
                request.setAttribute(206, credentials.getBinaryCreds());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiAccessControlException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiAccessControlException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "verifycredentials", "TLI auth response status = " + status[0] + ", type = " + response.getType());
        }
        int code = response.getType();
        boolean result = false;
        boolean challenge = false;
        if (code == 2) {
            result = true;
        } else if (code == 4) {
            challenge = true;
        } else if (code != 3) {
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
        int reason = 0;
        List responseAttributes = response.getAttributes();
        ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
        if (responseAttributes == null) {
            if (code == 3) {
                return new SmVerifyCredsResult(false);
            }
            throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        block7: for (SmAttribute responseAttribute : responseAttributes) {
            if (responseAttribute == null) continue;
            try {
                switch (responseAttribute.getId()) {
                    case 212: {
                        reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                        if (!Util.isLogEnabled()) continue block7;
                        Util.display(5, CLASS_NAME, "verifycredentials", "Processing tli attr reason - setting = " + reason);
                        break;
                    }
                    default: {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "verifycredentials", "Adding result attribute id = " + responseAttribute.getId());
                        }
                        resultAttributes.add(responseAttribute);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SmAgentApiAccessControlException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE_VALUE"), e);
            }
        }
        return new SmVerifyCredsResult(result, resultAttributes, reason, challenge);
    }

    private static byte[] getBinaryIntValue(int value) {
        byte[] valueByteArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(valueByteArray);
        byteBuffer.putInt(value);
        return valueByteArray;
    }
}

