/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.netegrity.util.AesKeyWrapper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class SmServerCrypto {
    final String RC2SHA_FORMAT = "{RC2}";
    final String AES_FORMAT = "{AES}";
    private static boolean c_bStubbed = false;
    private static byte[] c_masterKey = SmServerCrypto.generateMasterKey();
    private static byte[] c_psKey = null;
    private static byte[] c_ksKey = null;
    private static boolean c_isFIPS = false;
    private boolean m_isKeyStore = false;

    public SmServerCrypto(boolean bl) {
        this.m_isKeyStore = bl;
    }

    public String encrypt(byte[] byArray) throws SmCryptoProviderException, UnsupportedEncodingException {
        if (c_bStubbed || byArray == null) {
            return null;
        }
        String string = new String(byArray, "UTF-8");
        String string2 = c_isFIPS ? "{AES}" : "{RC2}";
        if (string.startsWith(string2)) {
            return string;
        }
        byte[] byArray2 = this.decryptInternal(c_masterKey, this.getEncryptionKey());
        byte[] byArray3 = this.encryptInternal(byArray2, byArray);
        String string3 = string2 + new String(byArray3, "UTF-8");
        Arrays.fill(byArray3, (byte)0);
        Arrays.fill(byArray2, (byte)0);
        return string3;
    }

    byte[] encryptInternal(byte[] byArray, byte[] byArray2) throws SmCryptoProviderException, UnsupportedEncodingException {
        if (!c_isFIPS) {
            SmCryptoProvider smCryptoProvider = SmCryptoProvider.getInstance("RC2/SHA", null, true);
            smCryptoProvider.init(byArray, byArray, null, 128, true);
            return smCryptoProvider.encrypt(byArray2);
        }
        AesKeyWrapper aesKeyWrapper = new AesKeyWrapper(byArray);
        return aesKeyWrapper.WrapAscii(byArray2, byArray2.length);
    }

    public byte[] decrypt(String string) throws SmCryptoProviderException, UnsupportedEncodingException {
        String string2;
        if (c_bStubbed || string == null) {
            return null;
        }
        String string3 = string2 = c_isFIPS ? "{AES}" : "{RC2}";
        if (!string.startsWith(string2)) {
            return string.getBytes("UTF-8");
        }
        byte[] byArray = string.substring(string2.length()).getBytes("UTF-8");
        byte[] byArray2 = this.decryptInternal(c_masterKey, this.getEncryptionKey());
        byte[] byArray3 = this.decryptInternal(byArray2, byArray);
        Arrays.fill(byArray2, (byte)0);
        return byArray3;
    }

    public byte[] decryptInternal(byte[] byArray, byte[] byArray2) throws SmCryptoProviderException, UnsupportedEncodingException {
        if (!c_isFIPS) {
            SmCryptoProvider smCryptoProvider = SmCryptoProvider.getInstance("RC2/SHA", null, true);
            smCryptoProvider.init(byArray, byArray, null, 128, true);
            return smCryptoProvider.decrypt(byArray2);
        }
        AesKeyWrapper aesKeyWrapper = new AesKeyWrapper(byArray);
        return aesKeyWrapper.UnwrapAscii(byArray2, 0, byArray2.length);
    }

    private static byte[] generateMasterKey() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(1255072322);
        byteBuffer.putInt(861109358);
        byteBuffer.putInt(317994786);
        byteBuffer.putInt(-1207138008);
        return byteBuffer.array();
    }

    private byte[] getEncryptionKey() {
        return this.m_isKeyStore ? c_ksKey : c_psKey;
    }

    static native byte[] getEncryptionKeyNative(boolean var0);

    static native boolean getFIPSMode();

    static {
        try {
            System.loadLibrary("smutilities");
            c_psKey = SmServerCrypto.getEncryptionKeyNative(false);
            c_ksKey = SmServerCrypto.getEncryptionKeyNative(true);
            c_isFIPS = SmServerCrypto.getFIPSMode();
        }
        catch (Throwable throwable) {
            c_bStubbed = true;
        }
    }
}

