/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import java.util.regex.Pattern;

final class Utilities {
    private static final String CLASSNAME = "[A-Z_]{1}[0-9A-Z_]{1,3}\\.[A-Z_]{1}[0-9A-Z_]{1,3}\\:\\:[a-zA-Z_]{1}[a-z0-9A-Z_]{0,31}";
    private static final Pattern XID_GUID_PATTERN = Pattern.compile("(?:[A-Z_]{1}[0-9A-Z_]{1,3}\\.[A-Z_]{1}[0-9A-Z_]{1,3}\\:\\:[a-zA-Z_]{1}[a-z0-9A-Z_]{0,31}\\@[\\x20-\\x7E]{1,128})");
    private static final Pattern XID_REFID_PATTERN = Pattern.compile("(?:[A-Z_]{1}[0-9A-Z_]{1,3}\\.[A-Z_]{1}[0-9A-Z_]{1,3}\\:\\:[a-zA-Z_]{1}[a-z0-9A-Z_]{0,31}\\#[\\x20-\\x7E]+)");
    private static final Pattern CLASS_PATTERN = Pattern.compile("(?:[A-Z_]{1}[0-9A-Z_]{1,3}\\.[A-Z_]{1}[0-9A-Z_]{1,3}\\:\\:[a-zA-Z_]{1}[a-z0-9A-Z_]{0,31})");
    private static final Pattern ATTR_PATTERN = Pattern.compile("(?:[A-Z_]{1}[0-9A-Z_]{1,3}\\.[A-Z_]{1}[0-9A-Z_]{1,3}\\:\\:[a-zA-Z_]{1}[a-z0-9A-Z_]{0,31}\\.[a-zA-Z_]{1}[a-z0-9A-Z_]{0,31})");
    static long count = 0L;

    Utilities() {
    }

    static synchronized boolean isValidXidGuid(String string) {
        return XID_GUID_PATTERN.matcher(string).matches();
    }

    static synchronized boolean isValidXidRef(String string) {
        return XID_REFID_PATTERN.matcher(string).matches();
    }

    static synchronized boolean isValidClassName(String string) {
        return CLASS_PATTERN.matcher(string).matches();
    }

    static synchronized boolean isValidAttrName(String string) {
        return ATTR_PATTERN.matcher(string).matches();
    }

    static boolean isRefXid(String string) {
        return string != null && string.indexOf(35) > 0;
    }

    static boolean isValidXid(String string) {
        return string != null;
    }

    static String generateXid(String string) {
        return string + '#' + ++count;
    }
}

