/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.Permissions;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSBase;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Workspace;
import com.ca.siteminder.sdk.adminapi.dd.DDAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Security
extends XPSBase {
    public static final int CCRIGHTS_CREATE = 1;
    public static final int CCRIGHTS_UPDATE = 2;
    public static final int CCRIGHTS_DELETE = 4;
    public static final int CCRIGHTS_TRAVERSE = 8;
    public static final int CCRIGHTS_READ = 16;
    public static final int CCRIGHTS_SEARCH = 32;
    public static final int CCRIGHTS_PROTECT = 64;
    public static final int CCRIGHTS_EXECUTE = 128;
    public static final int CCRIGHTS_BACKUP = 256;
    public static final int CCRIGHTS_IMPORT = 512;

    Security(Session session) {
        this.session = session;
    }

    public List<Administrator> getAdmins(Filter filter) {
        return this.search(Administrator.ddclass, filter);
    }

    public List<Administrator> getAdmins() {
        return this.getAdmins(null);
    }

    public Administrator getAdminByAttr(DDAttribute dDAttribute, String string) {
        return (Administrator)this.fetchByAttr(dDAttribute, string);
    }

    public Administrator getAdminByName(String string) {
        return this.getAdminByAttr(Administrator.NAME, string);
    }

    public Administrator getAdminByPath(String string) {
        return this.getAdminByAttr(Administrator.USERPATH, string);
    }

    public List<Grant> getGrants() {
        return this.search(Grant.ddclass);
    }

    public Administrator newAdministrator() {
        return this.session.getPolicyData().newObject(Administrator.ddclass);
    }

    public void createAdministrator(Administrator administrator) {
        this.session.getPolicyData().createObject(administrator);
    }

    public void updateAdministrator(Administrator administrator) {
        this.session.getPolicyData().updateObject(administrator);
    }

    public void deleteAdministrator(Administrator administrator) {
        this.session.getPolicyData().deleteObject(administrator);
    }

    public Grant newGrant() {
        return this.session.getPolicyData().newObject(Grant.ddclass);
    }

    public void createGrant(Grant grant) {
        this.session.getPolicyData().createObject(grant);
    }

    public void updateGrant(Grant grant) {
        this.session.getPolicyData().updateObject(grant);
    }

    public void deleteGrant(Grant grant) {
        this.session.getPolicyData().deleteObject(grant);
    }

    public void setWorkspaceXid(String string) {
        this.session.workspaceXid = string;
        this.session.service.Security_setWorkspace(string);
    }

    public void setWorkspace(Workspace workspace) {
        if (workspace != null) {
            this.setWorkspaceXid(workspace.getXid());
        }
    }

    public List<XPSObject> getWorkspaceClosure(String string) {
        return this.session.service.Security_getWorkspaceClosure(string);
    }

    public List<XPSObject> getWorkspaceClosure(Workspace workspace) {
        return this.session.service.Security_getWorkspaceClosure(workspace.getXid());
    }

    public int getRights(String string) {
        try {
            return this.session.service.Security_getRights(string);
        }
        catch (ServerException serverException) {
            return 0;
        }
    }

    public int getRights(XPSObject xPSObject) {
        return this.getRights(xPSObject.getXid());
    }

    public List<String> decryptSensitiveAttribute(String string, String string2) {
        return this.session.service.Security_decryptSensitiveAttribute(string, string2);
    }

    public List<String> decryptSensitiveAttribute(XPSObject xPSObject, IAttribute iAttribute) {
        String string = xPSObject.getXid();
        String string2 = iAttribute.getFQName();
        return this.decryptSensitiveAttribute(string, string2);
    }

    public Administrator getAdmin() {
        return (Administrator)this.session.service.Security_getAdmin();
    }

    public Workspace getWorkspace() {
        return (Workspace)this.session.service.Security_getWorkspace();
    }

    public Permissions getRights(String string, String string2, String string3) {
        return this.session.service.Security_getAdminRights(string, string2, string3);
    }

    public void setRights(String string, String string2, String string3, String string4) {
        this.session.service.Security_setAdminRights(string, string2, string3, string4);
    }

    public Map<String, Map<String, Permissions>> buildACL(String string) {
        return this.session.service.Security_buildACL(string);
    }

    public List<SecurityCategory> getAdminSecurityCategories(String string, boolean bl) {
        return this.session.service.Security_getAdminSecurityCategories(string, bl);
    }

    public List<XPSObject> getAdminScopes(String string, String string2, boolean bl) {
        return this.session.service.Security_getAdminScopes(string, string2, bl);
    }

    public static int convertRights(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                n |= 1 << c - 65;
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                n |= 1 << c - 97;
                continue;
            }
            throw new IllegalArgumentException(string);
        }
        return n;
    }

    public static String convertRights(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        for (int i = 0; i < 26; ++i) {
            if ((n & n2) != 0) {
                stringBuilder.append((char)(65 + i));
            }
            n2 <<= 1;
        }
        return stringBuilder.toString();
    }
}

