/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.CacheUpdate;
import com.ca.siteminder.sdk.adminapi.CacheUpdater;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.Utilities;
import com.ca.siteminder.sdk.adminapi.XPSBase;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyData
extends XPSBase {
    PolicyData(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(XPSObject xPSObject) {
        String string = xPSObject.getXid();
        if (!Utilities.isValidXid(string)) {
            throw new XPSException("object.delete.xid");
        }
        List<CacheUpdate> list = null;
        if (this.session.version > 2) {
            list = this.session.service.PolicyData_deleteObject1(string);
        } else {
            this.session.service.PolicyData_deleteObject(string);
        }
        CacheUpdater cacheUpdater = this.session.cacheUpdater;
        synchronized (cacheUpdater) {
            xPSObject.impl.turnIntoStub();
            this.session.objectCache.remove(string);
            if (list != null) {
                for (CacheUpdate cacheUpdate : list) {
                    int n = cacheUpdate.getOperation();
                    string = cacheUpdate.getXid();
                    xPSObject = this.session.objectCache.get(string);
                    if (xPSObject == null) continue;
                    xPSObject.impl.turnIntoStub();
                    if (n != 4) continue;
                    this.session.objectCache.remove(string);
                }
            }
        }
    }

    public void createObject(XPSObject xPSObject) {
        String string = xPSObject.getXid();
        if (string != null) {
            this.session.objectCache.remove(string);
            xPSObject.impl.clearXid();
        }
        XPSObject xPSObject2 = this.session.service.PolicyData_createObject(xPSObject);
        String string2 = xPSObject2.getXid();
        xPSObject2.impl.transferTo(xPSObject.impl);
        this.session.objectCache.remove(string2);
        this.session.objectCache.insert(xPSObject, false);
        this.session.cacheUpdater.addMy(string2);
    }

    public void updateObject(XPSObject xPSObject) {
        String string = xPSObject.getXid();
        if (!Utilities.isValidXid(string)) {
            throw new XPSException("object.update.xid");
        }
        this.session.objectCache.remove(string);
        XPSObject xPSObject2 = this.session.service.PolicyData_updateObject(xPSObject);
        String string2 = xPSObject2.getXid();
        xPSObject2.impl.transferTo(xPSObject.impl);
        this.session.objectCache.remove(string2);
        this.session.objectCache.insert(xPSObject, false);
        this.session.cacheUpdater.addMy(xPSObject.getXid());
    }

    public <T extends XPSObject> T newObject(IClass<T> iClass) {
        String string = iClass.getFQName();
        XPSObject xPSObject = this.session.service.PolicyData_newObject(string);
        xPSObject.impl.session = this.session;
        return xPSObject.castTo(iClass.getJavaClass());
    }

    public String getAttributeValue(String string, String string2) {
        List<String> list = Collections.singletonList(string);
        List<String> list2 = this.session.service.PolicyData_getAttributeValue(list, string2);
        return list2 == null || list2.isEmpty() ? null : list2.get(0);
    }

    public String getAttributeValue(XPSObject xPSObject, IAttribute iAttribute) {
        return this.getAttributeValue(xPSObject.getXid(), iAttribute.getFQName());
    }

    public List<String> getAttributeValue(List<String> list, String string) {
        return this.session.service.PolicyData_getAttributeValue(list, string);
    }
}

