/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.ca.xps.Bit;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.ca.xps.Product;
import com.ca.siteminder.sdk.adminapi.ca.xps.Vendor;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCache {
    Session session;
    Map<Object, IClass<? extends XPSObject>> classMap = new HashMap<Object, IClass<? extends XPSObject>>();
    List<IClass<? extends XPSObject>> classes = new ArrayList<IClass<? extends XPSObject>>();
    List<DDClass<? extends XPSObject>> ddclasses = new ArrayList<DDClass<? extends XPSObject>>();

    ClassCache(Session session) {
        this.session = session;
    }

    void bootstrap() {
        DDClass[] dDClassArray;
        DDClass[] dDClassArray2 = dDClassArray = new DDClass[]{Vendor.ddclass, Product.ddclass, Class.ddclass, Attribute.ddclass, Bit.ddclass};
        int n = dDClassArray2.length;
        for (int i = 0; i < n; ++i) {
            DDClass dDClass;
            DDClass dDClass2 = dDClass = dDClassArray2[i];
            this.addClass(dDClass2);
            this.classMap.put(dDClass, dDClass2);
            this.ddclasses.add(dDClass);
        }
    }

    void addClass(IClass<? extends XPSObject> iClass) {
        String string = iClass.getFQName();
        if (!this.classMap.containsKey(string)) {
            this.classes.add(iClass);
            this.classMap.put(string, iClass);
        }
    }

    boolean addDDClass(DDClass<? extends XPSObject> dDClass) {
        IClass<? extends XPSObject> iClass = this.classMap.get(dDClass.getFQName());
        if (iClass != null) {
            this.classMap.put(dDClass, iClass);
            this.classMap.put(dDClass.getJavaClass(), iClass);
            this.ddclasses.add(dDClass);
            return true;
        }
        return false;
    }

    IClass<? extends XPSObject> getClass(String string) {
        IClass<? extends XPSObject> iClass = this.classMap.get(string);
        if (iClass == null) {
            throw new XPSException("class", string);
        }
        return iClass;
    }

    IClass<? extends XPSObject> getClass(java.lang.Class<?> clazz) {
        IClass<? extends XPSObject> iClass = this.classMap.get(clazz);
        if (iClass == null) {
            throw new XPSException("class", clazz.getSimpleName());
        }
        return iClass;
    }

    void init() {
        IClass<GenericObject> iClass;
        for (IClass<? extends XPSObject> dDClass : this.classes) {
            if (!(dDClass instanceof Class)) continue;
            iClass = (Class)dDClass;
            iClass.init();
            iClass.setMetadata(this.session.metadata);
        }
        for (DDClass dDClass : this.ddclasses) {
            iClass = this.classMap.get(dDClass);
            if (!(iClass instanceof Class)) continue;
            iClass.setDDClass(dDClass);
        }
    }
}

