/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpcutil;

import com.ca.siteminder.rpcutil.BeanUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandLineOptions {
    List options;
    String commandName;
    int numRequiredOptions;
    List constraints;
    List posargs;
    String posargname;
    String posargdescr;
    int minMatchLen = 4;

    private void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    private void add(Option option) {
        this.options.add(option);
        if (!option.isOptional) {
            ++this.numRequiredOptions;
        }
    }

    public Option getOption(String string) {
        Option option2 = null;
        for (Option option2 : this.options) {
            if (!option2.key.equals(string)) continue;
            return option2;
        }
        return null;
    }

    public CommandLineOptions(String string) {
        this.commandName = string;
        this.options = new ArrayList();
        this.constraints = new ArrayList();
        this.numRequiredOptions = 0;
    }

    public void positionalArgs(String string, String string2) {
        this.posargname = string;
        this.posargdescr = string2;
    }

    void addPosarg(Object object) {
        if (this.posargs == null) {
            this.posargs = new ArrayList();
        }
        this.posargs.add(object);
    }

    private Option add(String string, boolean bl, String string2) {
        SingleOption singleOption = new SingleOption(string, string2, bl);
        this.add(singleOption);
        return singleOption;
    }

    public Option addRequired(String string, String string2) {
        return this.add(string, false, string2);
    }

    public Option addOptional(String string, String string2) {
        return this.add(string, true, string2);
    }

    public Option addMulti(String string, String string2) {
        MultiOption multiOption = new MultiOption(string, string2, true);
        this.add(multiOption);
        return multiOption;
    }

    public Option addSwitch(String string, String string2, String string3) {
        SwitchOption switchOption = new SwitchOption(string2, string, string3);
        this.add(switchOption);
        return switchOption;
    }

    public Option addEnum(String string, String[] stringArray, String string2) {
        EnumOption enumOption = new EnumOption(string, stringArray, string2, true);
        this.add(enumOption);
        return enumOption;
    }

    public void oneOf(Option option, Option option2) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        arrayList.add(option);
        arrayList.add(option2);
        this.addConstraint(new ExactlyOne(arrayList));
    }

    public void oneOf(Option option, Option option2, Option option3) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        arrayList.add(option);
        arrayList.add(option2);
        arrayList.add(option3);
        this.addConstraint(new ExactlyOne(arrayList));
    }

    public Option addKeyValue(String string, String string2) {
        KeyValueOption keyValueOption = new KeyValueOption(string, string2);
        this.add(keyValueOption);
        return keyValueOption;
    }

    public boolean process(String[] stringArray, Object object) {
        return this.process(stringArray, new Object[]{object});
    }

    public boolean process(String[] stringArray, Object[] objectArray) {
        Object object;
        if (stringArray.length == 0) {
            if (this.numRequiredOptions > 0) {
                this.usage();
                return false;
            }
        } else if (stringArray.length == 1 && (((String)(object = stringArray[0])).equals("-h") || ((String)object).equals("-help"))) {
            this.usage();
            return false;
        }
        object = new Context(stringArray);
        Map map = null;
        try {
            map = this.parse((Context)object);
            this.validate(map);
            this.populate(map, objectArray);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(runtimeException.getMessage());
            this.usage();
            return false;
        }
        return true;
    }

    private Map parse(Context context) {
        HashMap hashMap = new HashMap();
        while (context.hasNext()) {
            if (context.isSwitch()) {
                this.processNext(hashMap, context);
                continue;
            }
            if (this.posargname != null) {
                this.addPosarg(context.next());
                continue;
            }
            throw new RuntimeException("no positional arguments allowed");
        }
        return hashMap;
    }

    private void processNext(Map map, Context context) {
        String string = context.next();
        int n = 0;
        Option option = null;
        for (Option option2 : this.options) {
            if (!option2.match(string)) continue;
            ++n;
            option = option2;
        }
        if (n == 0) {
            throw new RuntimeException("invalid option: " + string);
        }
        if (n > 1) {
            throw new RuntimeException("ambiguous option: " + string);
        }
        if (!option.allowRepeated() && option.get(map) != null) {
            throw new RuntimeException("repeated option: " + option.key);
        }
        option.put(map, context, string);
    }

    private void validate(Map map) {
        for (Object object : this.options) {
            ((Option)object).validate(map);
        }
        for (Object object : this.constraints) {
            ((Constraint)object).validate(map);
        }
    }

    public void printUsage(PrintWriter printWriter) {
        printWriter.println("Usage:");
        printWriter.print(this.commandName + " ");
        for (Iterator iterator : this.options) {
            if (((Option)((Object)iterator)).description == null) continue;
            Object object = ((Option)((Object)iterator)).arg();
            if (((Option)((Object)iterator)).isOptional) {
                printWriter.print(" [" + (String)object + "]");
                continue;
            }
            printWriter.print(" " + (String)object);
        }
        printWriter.println();
        int n = 0;
        for (Object object : this.options) {
            int n2;
            if (((Option)object).description == null || (n2 = ((Option)object).key.length()) <= n) continue;
            n = n2;
        }
        for (Object object : this.options) {
            if (((Option)object).description == null) continue;
            ((Option)object).print(printWriter, n);
        }
        printWriter.flush();
    }

    public void usage() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        }
        this.printUsage(printWriter);
    }

    private void populate(Map map, Object[] objectArray) {
        if (this.posargs != null) {
            BeanUtil.setField(this.posargname, objectArray, (Object)this.posargs);
        }
        for (Map.Entry entry : map.entrySet()) {
            Option option = (Option)entry.getKey();
            Object v = entry.getValue();
            String string = option.key.substring(1);
            BeanUtil.setField(string, objectArray, v);
        }
    }

    class ExactlyOne
    extends Constraint {
        List options;

        ExactlyOne(List list) {
            this.options = list;
        }

        void validate(Map map) {
            int n = 0;
            for (Option option : this.options) {
                if (!map.containsKey(option)) continue;
                ++n;
            }
            if (n != 1) {
                throw new RuntimeException("one of" + this.listOptions() + " must be specified");
            }
        }

        String listOptions() {
            StringBuffer stringBuffer = new StringBuffer();
            for (Option option : this.options) {
                stringBuffer.append(" ").append(option.key);
            }
            return stringBuffer.toString();
        }
    }

    abstract class Constraint {
        Constraint() {
        }

        abstract void validate(Map var1);
    }

    class Context {
        String[] args;
        int curInd = 0;
        int numArgs;

        Context(String[] stringArray) {
            this.args = stringArray;
            this.numArgs = stringArray.length;
        }

        boolean hasNext() {
            return this.curInd < this.numArgs;
        }

        boolean isSwitch() {
            return this.args[this.curInd].charAt(0) == '-';
        }

        String next() {
            return this.args[this.curInd++];
        }
    }

    class KeyValueOption
    extends Option {
        String fs;

        KeyValueOption(String string, String string2) {
            this(string, string2, "=");
        }

        KeyValueOption(String string, String string2, String string3) {
            super(string, string2, true);
            this.fs = string3;
        }

        boolean allowRepeated() {
            return true;
        }

        boolean match(String string) {
            return string.indexOf(this.fs) > 0 && string.startsWith(this.key);
        }

        void put(Map map, Context context, String string) {
            int n = string.indexOf(this.fs);
            int n2 = this.key.length();
            String string2 = string.substring(n2, n);
            String string3 = string.substring(n + this.fs.length());
            ArrayList<Entry> arrayList = (ArrayList<Entry>)this.get(map);
            if (arrayList == null) {
                arrayList = new ArrayList<Entry>();
                this.put(map, arrayList);
            }
            Entry entry = new Entry(string2, string3);
            arrayList.add(entry);
        }

        String arg() {
            return this.key + "<param>" + this.fs + "<value> ...";
        }
    }

    public static class Entry {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        Entry(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }

    class SwitchOption
    extends Option {
        String yes;

        SwitchOption(String string, String string2, String string3) {
            super(string2, string3, true);
            this.yes = string;
        }

        void put(Map map, Context context, String string) {
            if (!context.hasNext() || context.isSwitch()) {
                this.put(map, this.yes);
            } else {
                this.put(map, context.next());
            }
        }

        String arg() {
            return this.key + " [<" + this.key.substring(1) + ">" + "=" + this.yes + "]";
        }
    }

    class EnumOption
    extends Option {
        String[] vals;

        EnumOption(String string, String[] stringArray, String string2, boolean bl) {
            super(string, string2, bl);
            this.vals = stringArray;
        }

        void put(Map map, Context context, String string) {
            if (!context.hasNext()) {
                throw new RuntimeException("no value supplied for option " + this.key);
            }
            String string2 = context.next();
            boolean bl = false;
            for (int i = 0; i < this.vals.length; ++i) {
                if (!string2.equalsIgnoreCase(this.vals[i])) continue;
                this.put(map, new Integer(i));
                bl = true;
                break;
            }
            if (!bl) {
                throw new RuntimeException("illegal value supplied for option " + this.key);
            }
        }

        String optionList(String string) {
            return this.optionList(string, string);
        }

        String optionList(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer(this.vals[0]);
            int n = this.vals.length - 1;
            for (int i = 1; i <= n; ++i) {
                String string3 = i == n ? string2 : string;
                stringBuffer.append(string3).append(this.vals[i]);
            }
            return stringBuffer.toString();
        }

        String arg() {
            return this.key + " " + this.optionList("|");
        }

        String printMoreInfo() {
            return this.optionList(", ");
        }
    }

    class MultiOption
    extends Option {
        MultiOption(String string, String string2, boolean bl) {
            super(string, string2, bl);
        }

        void put(Map map, Context context, String string) {
            if (!context.hasNext()) {
                throw new RuntimeException("no value supplied for option " + this.key);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (context.hasNext() && !context.isSwitch()) {
                arrayList.add(context.next());
            }
            this.put(map, arrayList);
        }

        String arg() {
            String string = " <" + this.key.substring(1) + ">";
            return this.key + string + " ...";
        }
    }

    class SingleOption
    extends Option {
        SingleOption(String string, String string2, boolean bl) {
            super(string, string2, bl);
        }

        void put(Map map, Context context, String string) {
            if (!context.hasNext()) {
                throw new RuntimeException("no value supplied for option " + this.key);
            }
            this.put(map, context.next());
        }

        String arg() {
            return this.key + " <" + this.key.substring(1) + ">";
        }
    }

    public abstract class Option {
        String key;
        boolean isOptional;
        String description;
        int minMatchLen = 4;

        boolean allowRepeated() {
            return false;
        }

        public void setOptional(boolean bl) {
            this.isOptional = bl;
        }

        Option(String string, String string2, boolean bl) {
            this.key = string;
            this.isOptional = bl;
            this.description = string2;
        }

        boolean match(String string) {
            int n = string.length();
            if (n < this.minMatchLen) {
                return this.key.equals(string);
            }
            return this.key.startsWith(string);
        }

        Object get(Map map) {
            return map.get(this);
        }

        void put(Map map, Object object) {
            map.put(this, object);
        }

        boolean isSet(Map map) {
            return map.get(this) != null;
        }

        void validate(Map map) {
            if (!this.isSet(map) && !this.isOptional) {
                throw new RuntimeException("required option " + this.key + " is not specified");
            }
        }

        String printMoreInfo() {
            return null;
        }

        void print(PrintWriter printWriter, int n) {
            int n2 = n - this.key.length();
            printWriter.print("  " + this.key);
            for (int i = 0; i < n2; ++i) {
                printWriter.print(" ");
            }
            printWriter.print("\t" + this.description);
            String string = this.printMoreInfo();
            if (string != null) {
                printWriter.print(": " + string);
            }
            printWriter.println();
        }

        abstract void put(Map var1, Context var2, String var3);

        abstract String arg();
    }
}

