/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpcutil;

import com.ca.siteminder.rpc.type.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;

public class BeanUtil {
    public static void objToMap(Object object, Map map, boolean bl) {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object2;
            Field field = fieldArray[i];
            String string = field.getName();
            try {
                object2 = field.get(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (object2 == null) continue;
            if (bl) {
                object2 = object2.toString();
            }
            map.put(string, object2);
        }
    }

    public static void objToMap(Object object, Map map) {
        BeanUtil.objToMap(object, map, false);
    }

    public static void objToProperties(Object object, Properties properties) {
        BeanUtil.objToMap(object, properties, true);
    }

    public static void mapToObj(Object object, Map map) {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            String string = field.getName();
            if (!map.containsKey(string)) continue;
            Object v = map.get(string);
            BeanUtil.setFieldValue(field, object, v);
        }
    }

    public static void setField(String string, Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!BeanUtil.setField(string, objectArray[i], object)) continue;
            return;
        }
        throw new RuntimeException("no such field: " + string);
    }

    public static boolean setField(String string, Object object, Object object2) {
        Field field = null;
        Class<?> clazz = object.getClass();
        try {
            field = clazz.getField(string);
        }
        catch (Exception exception) {
            return false;
        }
        if (field == null) {
            return false;
        }
        BeanUtil.setFieldValue(field, object, object2);
        return true;
    }

    public static void setFieldValue(Field field, Object object, Object object2) {
        Class clazz = field.getType();
        if (clazz.isPrimitive()) {
            clazz = BeanUtil.primitiveToWrapper(clazz);
        }
        Class<?> clazz2 = object2.getClass();
        Object object3 = null;
        if (clazz.isAssignableFrom(clazz2)) {
            object3 = object2;
        } else {
            Constructor constructor = null;
            try {
                constructor = clazz.getConstructor(clazz2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            try {
                object3 = constructor.newInstance(object2);
            }
            catch (Exception exception) {
                throw new RuntimeException(field.getName() + "=" + object2 + ": value is not " + Util.simpleNameOf(clazz).toLowerCase());
            }
        }
        try {
            field.set(object, object3);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Class primitiveToWrapper(Class clazz) {
        if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        }
        return clazz;
    }

    public static void printFields(Object object) {
        System.out.println();
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object2;
            Field field = fieldArray[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            String string = field.getName();
            try {
                object2 = field.get(object);
            }
            catch (Exception exception) {
                continue;
            }
            System.out.print(" " + string + "=" + object2);
        }
        System.out.println();
    }

    public void copyPublicFields(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            String string = field.getName();
            Object object3 = BeanUtil.getFieldValue(field, object);
            BeanUtil.setField(string, object2, object3);
        }
    }

    public static void setDefaults(Object object, Object object2) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            String string = field.getName();
            Object object3 = BeanUtil.getFieldValue(field, object2);
            if (object3 != null || (object3 = BeanUtil.getProperty(object, string)) == null) continue;
            BeanUtil.setFieldValue(field, object2, object3);
        }
    }

    public static Object getProperty(Object object, String string) {
        Field field;
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.get(string);
        }
        try {
            field = object.getClass().getField(string);
        }
        catch (Exception exception) {
            return null;
        }
        if (field == null) {
            return null;
        }
        return BeanUtil.getFieldValue(field, object);
    }

    public static Object getFieldValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

