/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.type;

import com.ca.siteminder.rpc.output.PrintFormatter;
import com.ca.siteminder.rpc.type.BeanType;
import com.ca.siteminder.rpc.type.BooleanType;
import com.ca.siteminder.rpc.type.CollectionType;
import com.ca.siteminder.rpc.type.DateType;
import com.ca.siteminder.rpc.type.DoubleType;
import com.ca.siteminder.rpc.type.Formatter;
import com.ca.siteminder.rpc.type.IntType;
import com.ca.siteminder.rpc.type.InterfaceType;
import com.ca.siteminder.rpc.type.LongType;
import com.ca.siteminder.rpc.type.MapType;
import com.ca.siteminder.rpc.type.PropertiesType;
import com.ca.siteminder.rpc.type.ServiceType;
import com.ca.siteminder.rpc.type.StringType;
import com.ca.siteminder.rpc.type.Type;
import com.ca.siteminder.rpc.type.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TypeRegistry {
    Map stypes = new HashMap();
    Map ctypes = new HashMap();
    Map callbacks = new HashMap();
    Map services = new HashMap();
    String libName;

    public Map getCtypes() {
        return this.ctypes;
    }

    public void registerRemoteService(Class clazz) {
    }

    public void registerRemoteService(Class clazz, Class clazz2) {
        InterfaceType interfaceType = new InterfaceType(clazz2);
        interfaceType.reg = this;
        this.callbacks.put(clazz, interfaceType);
    }

    public InterfaceType getCallback(Class clazz) {
        return (InterfaceType)this.callbacks.get(clazz);
    }

    public Type getTypeOfObject(Object object) {
        return this.getType(object.getClass());
    }

    private Type dynamicType(Class clazz) {
        Type type = null;
        if (Collection.class.isAssignableFrom(clazz)) {
            type = new CollectionType(ArrayList.class, clazz);
            type.name = "List";
        } else if (Map.class.isAssignableFrom(clazz)) {
            type = new MapType(clazz);
            type.name = "Map";
        }
        if (type != null) {
            this.register(type);
        }
        return type;
    }

    public Type getType(Class clazz) {
        Type type = (Type)this.ctypes.get(clazz);
        if (type == null) {
            type = this.dynamicType(clazz);
        }
        if (type == null) {
            throw new RuntimeException("type for class " + clazz.getName() + " does not exist");
        }
        return type;
    }

    public Type getType(String string) {
        Type type = (Type)this.stypes.get(string);
        if (type == null) {
            throw new RuntimeException("type for name " + string + " does not exist");
        }
        return type;
    }

    public void register(Type type, String string) {
        type.name = string;
        type.reg = this;
        this.stypes.put(string, type);
        this.ctypes.put(type.clazz, type);
        this.ctypes.put(type.getPrimitiveClass(), type);
    }

    public void registerAlias(Class clazz, String string) {
        Type type = this.getType(clazz);
        this.stypes.put(string, type);
    }

    public void register(Type type) {
        String string = type.name;
        this.register(type, string);
    }

    public void registerBean(Class clazz) {
        BeanType beanType = new BeanType(clazz);
        this.register(beanType);
    }

    public void registerBean(Class clazz, String string) {
        BeanType beanType = new BeanType(clazz);
        this.register(beanType, string);
    }

    public void registerInterface(Class clazz) {
        InterfaceType interfaceType = new InterfaceType(clazz);
        this.register(interfaceType);
    }

    public void registerInterface(Class clazz, String string) {
        InterfaceType interfaceType = new InterfaceType(clazz);
        this.register(interfaceType, string);
    }

    public void registerServiceImpl(Class clazz, Class clazz2) {
        this.registerServiceImpl(clazz, clazz2, null);
    }

    public void registerServiceImpl(Class clazz, Class clazz2, Class clazz3) {
        ServiceType serviceType = new ServiceType(clazz, clazz2, clazz3);
        serviceType.reg = this;
        this.services.put(Util.simpleNameOf(clazz2), serviceType);
    }

    public ServiceType getServiceImpl(String string) {
        return (ServiceType)this.services.get(string);
    }

    public void print(Object object) {
        PrintFormatter printFormatter = PrintFormatter.defaultFormatter;
        this.format(printFormatter, object);
        printFormatter.println();
        printFormatter.flush();
    }

    public void format(Formatter formatter, Object object) {
        if (object == null) {
            formatter.error("(null)");
        } else {
            Type type = this.getTypeOfObject(object);
            if (type != null) {
                type.format(object, formatter);
            } else {
                formatter.error("unknown type: " + object.getClass().getName());
            }
        }
    }

    public void setLibraryName(String string) {
        this.libName = string;
    }

    public String getLibraryName() {
        return this.libName;
    }

    public int getVersion() {
        return 1;
    }

    public TypeRegistry(String string) {
        this.libName = string;
        this.register(new IntType());
        this.register(new DoubleType());
        this.register(new LongType());
        this.register(new BooleanType());
        this.register(new StringType());
        this.register(new DateType());
        this.register(new MapType(Map.class));
        this.register(new MapType(HashMap.class));
        this.register(new CollectionType(ArrayList.class, List.class));
        this.register(new CollectionType(ArrayList.class, ArrayList.class));
        this.register(new CollectionType(ArrayList.class, Vector.class));
        this.register(new CollectionType(HashSet.class, Set.class));
        this.register(new CollectionType(HashSet.class, HashSet.class));
        this.register(new PropertiesType());
        this.registerInterface(Object.class);
    }
}

