/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.type;

import com.ca.siteminder.rpc.rpc.ApplicationContext;
import com.ca.siteminder.rpc.type.OutStream;
import com.ca.siteminder.rpc.type.RpcConstants;
import com.ca.siteminder.rpc.type.Type;
import com.ca.siteminder.rpc.type.TypeRegistry;

public class Serializer
implements RpcConstants {
    TypeRegistry reg;
    OutStream out;
    ApplicationContext applicationContext;

    public OutStream getOutStream() {
        return this.out;
    }

    public Serializer(TypeRegistry typeRegistry, OutStream outStream) {
        this.reg = typeRegistry;
        this.out = outStream;
    }

    public Serializer(TypeRegistry typeRegistry) {
        this(typeRegistry, new OutStream());
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getMessages() {
        return this.out.getContent();
    }

    void serializeNullPtr(Type type) {
        String string = "";
        this.out.value(type.getName(), string);
    }

    void serialize(Type type, Object object) {
        if (object == null) {
            this.out.value(type.getName(), "");
        } else {
            type.serialize(object, this);
        }
    }

    public void serialize(Object object) {
        if (object != null) {
            Type type = this.reg.getTypeOfObject(object);
            type.serialize(object, this);
        }
    }

    public void mcall(String string, Object[] objectArray) {
        this.out.startElement("mcall");
        this.out.value("name", string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object == null) {
                    this.out.value("", "");
                    continue;
                }
                this.serialize(this.reg.getTypeOfObject(object), object);
            }
        }
        this.out.endElement();
    }

    public void done() {
        this.out.startElement("done");
        this.out.endElement();
    }

    public void retval(Object object) {
        this.out.startElement("return");
        if (object != null) {
            this.serialize(this.reg.getTypeOfObject(object), object);
        }
        this.out.endElement();
    }

    public void instantiate(Object object) {
        this.out.startElement("inst");
        if (object != null) {
            this.serialize(this.reg.getTypeOfObject(object), object);
        }
        this.out.endElement();
    }

    public void instantiate(String string) {
        this.out.startElement("inst");
        this.out.startElement(string);
        this.out.endElement();
        this.out.endElement();
    }

    public void relogin(String string, String string2) {
        this.out.startElement("relogin");
        this.out.value("name", string);
        this.out.value("pwd", string2);
        this.out.endElement();
    }
}

