/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.type;

import com.ca.siteminder.rpc.type.Deserializer;
import com.ca.siteminder.rpc.type.FieldInfo;
import com.ca.siteminder.rpc.type.Formatter;
import com.ca.siteminder.rpc.type.OutStream;
import com.ca.siteminder.rpc.type.PropInfo;
import com.ca.siteminder.rpc.type.PropertyInfo;
import com.ca.siteminder.rpc.type.Serializer;
import com.ca.siteminder.rpc.type.Tree;
import com.ca.siteminder.rpc.type.Type;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ObjectType
extends Type {
    List fieldList = new ArrayList();
    Map fieldMap = new HashMap();
    public int maxPropNameLength = -1;
    Map signatureMap;
    Map methodMap;

    public Iterator fieldIterator() {
        return this.fieldList.iterator();
    }

    public Map getFieldMap() {
        return this.fieldMap;
    }

    void putProp(PropInfo propInfo) {
        String string = propInfo.fname;
        if (!this.fieldMap.containsKey(string)) {
            this.fieldMap.put(string, propInfo);
            this.fieldList.add(propInfo);
        }
    }

    void putMethod(String string, Method method) {
        this.signatureMap.put(string, method);
        this.methodMap.put(method, string);
    }

    public Method getMethod(String string) {
        Method method;
        if (this.signatureMap == null) {
            this.initMethods();
        }
        if ((method = (Method)this.signatureMap.get(string)) == null) {
            throw new RuntimeException("method " + this.name + '.' + string + " does not exist");
        }
        return method;
    }

    public String getMethodSignature(Method method) {
        String string;
        if (this.methodMap == null) {
            this.initMethods();
        }
        if ((string = (String)this.methodMap.get(method)) == null) {
            throw new RuntimeException("method " + this.name + '.' + string + " does not exist");
        }
        return string;
    }

    public String generateSignature(Method method) {
        return method.getName();
    }

    ObjectType(Class clazz) {
        super(clazz);
    }

    void initMethods() {
        this.signatureMap = new HashMap();
        this.methodMap = new HashMap();
        Method[] methodArray = this.clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (Modifier.isStatic(n) || !Modifier.isPublic(n)) continue;
            String string = this.generateSignature(method);
            this.putMethod(string, method);
        }
    }

    void initFields() {
        Field[] fieldArray = this.clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (Modifier.isStatic(n) || !Modifier.isPublic(n)) continue;
            FieldInfo fieldInfo = new FieldInfo(field);
            this.putProp(fieldInfo);
        }
    }

    void initProperties() {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.clazz);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (clazz == Class.class) continue;
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            if (method == null || method2 == null) continue;
            PropertyInfo propertyInfo = new PropertyInfo(propertyDescriptor);
            this.putProp(propertyInfo);
        }
    }

    public Object create() {
        Object t;
        try {
            t = this.clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        return t;
    }

    public Object deserialize(Tree tree, Deserializer deserializer) {
        Object t;
        try {
            t = this.clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        Tree tree2 = tree.firstChild;
        while (tree2 != null) {
            String string = tree2.tag;
            Tree tree3 = tree2.firstChild;
            PropInfo propInfo = (PropInfo)this.fieldMap.get(string);
            if (propInfo == null) {
                throw new RuntimeException("property " + this.getName() + '.' + string + " does not exist");
            }
            Object object = deserializer.deserialize(tree3);
            propInfo.set(t, object);
            tree2 = tree2.nextSibling;
        }
        return t;
    }

    public void serialize(Object object, Serializer serializer) {
        OutStream outStream = serializer.getOutStream();
        outStream.startElement(this.getName());
        for (PropInfo propInfo : this.fieldList) {
            String string = propInfo.fname;
            outStream.startElement(string);
            Object object2 = propInfo.get(object);
            serializer.serialize(object2);
            outStream.endElement();
        }
        outStream.endElement();
    }

    public PropInfo get(Class clazz) {
        for (PropInfo propInfo : this.fieldList) {
            if (propInfo.fclass != clazz) continue;
            return propInfo;
        }
        return null;
    }

    public int compare(Object object, Object object2) {
        for (PropInfo propInfo : this.fieldList) {
            Object object3 = propInfo.get(object);
            Object object4 = propInfo.get(object2);
            if (object3 == null) {
                return object4 == null ? 0 : -1;
            }
            if (object4 == null) {
                return 1;
            }
            int n = 0;
            if (object3 instanceof Comparable) {
                Comparable comparable = (Comparable)object3;
                n = comparable.compareTo(object4);
            }
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public void format(Object object, Formatter formatter) {
        formatter.startObject(this);
        Iterator iterator = this.fieldList.iterator();
        while (iterator.hasNext()) {
            PropInfo propInfo = (PropInfo)iterator.next();
            Object object2 = propInfo.get(object);
            formatter.startField(this, propInfo.fname);
            this.reg.format(formatter, object2);
            formatter.endField(propInfo.fname, iterator.hasNext());
        }
        formatter.endObject(this);
    }
}

