/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.rpc;

import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.rpc.RpcConnection;
import com.ca.siteminder.rpc.rpc.SystemError;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import netegrity.siteminder.javaagent.AgentAPI;
import netegrity.siteminder.javaagent.Attribute;
import netegrity.siteminder.javaagent.AttributeList;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.ResourceContextDef;
import netegrity.siteminder.javaagent.ServerDef;
import netegrity.siteminder.javaagent.TunnelServiceRequest;

public class TunnelConnection
extends RpcConnection
implements ContextConstants {
    public static final String defaultLibrary = "smtunnelrpc";
    public static final String defaultFunction = "DoWork";
    String library;
    String function;
    public static Map defaults = new HashMap();
    AgentAPI agentapi;
    int maxBufferSize;
    String localHost;
    boolean isAgentApiCreated;
    RuntimeException agentapiException;

    static void putint(String string, int n) {
        defaults.put(string, new Integer(n));
    }

    public TunnelConnection() {
        this(defaultLibrary, defaultFunction);
    }

    public TunnelConnection(String string, String string2) {
        this.library = string;
        this.function = string2;
    }

    public static AgentAPI create(Map map) {
        boolean bl;
        String string = (String)map.get("agentName");
        String string2 = (String)map.get("agentSecret");
        if (string == null) {
            string = "SMTUNNEL";
            string2 = "SMTUNNEL";
        }
        int n = (bl = map.containsKey("ns")) ? Integer.MAX_VALUE : TunnelConnection.getInt(map, "PS_TIMEOUT");
        AgentAPI agentAPI = new AgentAPI();
        ServerDef serverDef = new ServerDef();
        int n2 = TunnelConnection.getInt(map, "PS_AUPORT");
        int n3 = TunnelConnection.getInt(map, "PS_FIPS");
        serverDef.serverIpAddress = (String)map.get("PS_IP");
        serverDef.connectionMin = TunnelConnection.getInt(map, "PS_CONMIN");
        serverDef.connectionMax = TunnelConnection.getInt(map, "PS_CONMAX");
        serverDef.connectionStep = TunnelConnection.getInt(map, "PS_CONSTEP");
        serverDef.timeout = n;
        serverDef.authenticationPort = n2;
        serverDef.authorizationPort = n2;
        serverDef.accountingPort = n2;
        InitDef initDef = new InitDef(string, string2, false, serverDef);
        initDef.setFIPSMode(n3);
        int n4 = agentAPI.init(initDef);
        if (n4 != 0) {
            agentAPI = null;
            String string3 = TunnelConnection.getRetCodeString(n4);
            throw new RuntimeException(string3);
        }
        return agentAPI;
    }

    public void connect(Map map) {
        try {
            this.localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
        this.agentapi = (AgentAPI)map.get("connection");
        if (this.agentapi != null) {
            this.isAgentApiCreated = false;
        } else {
            this.isAgentApiCreated = true;
            try {
                this.agentapi = TunnelConnection.create(map);
            }
            catch (RuntimeException runtimeException) {
                this.agentapiException = runtimeException;
                throw runtimeException;
            }
        }
        this.maxBufferSize = this.agentapi.getMaxTunnelBufSize();
    }

    public void disconnect() {
        if (this.agentapi != null && this.isAgentApiCreated) {
            int n = this.agentapi.unInit();
        }
        this.agentapi = null;
    }

    public byte[] send(byte[] byArray) {
        if (this.agentapi == null) {
            throw this.agentapiException;
        }
        ResourceContextDef resourceContextDef = new ResourceContextDef("", "", "", "");
        String string = "";
        TunnelServiceRequest tunnelServiceRequest = null;
        AttributeList attributeList = null;
        int n = 1;
        String string2 = "";
        short s = 0;
        for (int i = 0; i < 20 && ((n = this.agentapi.tunnel(s, this.localHost, string2, resourceContextDef, tunnelServiceRequest = new TunnelServiceRequest(this.library, this.function, string, byArray), attributeList = new AttributeList())) == -1 || n == -2 || n == -3); ++i) {
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n != 1) {
            byte[] byArray2 = TunnelConnection.getFirstAttribute(attributeList);
            String string3 = TunnelConnection.getRetCodeString(n);
            String string4 = null;
            try {
                string4 = byArray2 == null ? "" : new String(byArray2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            throw new SystemError(string3 + " " + string4);
        }
        return TunnelConnection.getFirstAttribute(attributeList);
    }

    static int getInt(Map map, String string) {
        Integer n;
        Object v = map.get(string);
        if (v == null) {
            n = (Integer)defaults.get(string);
            if (n == null) {
                throw new RuntimeException("no value for " + string);
            }
        } else {
            n = v instanceof Integer ? (Integer)v : new Integer(v.toString());
        }
        return n;
    }

    static byte[] getFirstAttribute(AttributeList attributeList) {
        int n = attributeList.getAttributeCount();
        if (n == 0) {
            return null;
        }
        Attribute attribute = attributeList.getAttributeAt(0);
        return attribute.value;
    }

    static void displayAttributes(AttributeList attributeList, PrintStream printStream) {
        Enumeration enumeration = attributeList.attributes();
        if (!enumeration.hasMoreElements()) {
            printStream.println("AGENTAPI_NONE");
        }
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            String string = "";
            try {
                string = new String(attribute.value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            printStream.println(attribute.id + "\t" + string);
        }
    }

    private static String getRetCodeString(int n) {
        if (n == 1) {
            return "AGENTAPI_YES";
        }
        if (n == 2) {
            return "AGENTAPI_NO";
        }
        if (n == 0) {
            return "AGENTAPI_SUCCESS";
        }
        if (n == -1) {
            return "AGENTAPI_FAILURE";
        }
        if (n == 3) {
            return "AGENTAPI_CHALLENGE";
        }
        if (n == -2) {
            return "AGENTAPI_TIMEOUT";
        }
        if (n == -3) {
            return "AGENTAPI_NOCONNECTION";
        }
        return "CONNECT_FAILURE";
    }

    static {
        TunnelConnection.putint("PS_CONMIN", 1);
        TunnelConnection.putint("PS_CONMAX", 30);
        TunnelConnection.putint("PS_CONSTEP", 1);
        TunnelConnection.putint("PS_TIMEOUT", 15);
        TunnelConnection.putint("PS_AUPORT", 44442);
        TunnelConnection.putint("PS_FIPS", 0);
    }
}

