/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.rpc;

import com.ca.siteminder.rpc.rpc.ApplicationContext;
import com.ca.siteminder.rpc.rpc.CallContext;
import com.ca.siteminder.rpc.rpc.Transport;
import com.ca.siteminder.rpc.type.Deserializer;
import com.ca.siteminder.rpc.type.InterfaceType;
import com.ca.siteminder.rpc.type.ObjectType;
import com.ca.siteminder.rpc.type.RpcConstants;
import com.ca.siteminder.rpc.type.Tree;
import com.ca.siteminder.rpc.type.TypeRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class Dispatcher
implements RpcConstants {
    protected TypeRegistry reg;
    protected Deserializer des;
    protected Transport transport;
    protected Object instance;
    protected ObjectType instanceType;
    ObjectType proxyType;

    abstract void dispatch(Tree var1, CallContext var2);

    protected Dispatcher(TypeRegistry typeRegistry, Transport transport) {
        this.reg = typeRegistry;
        this.transport = transport;
        this.des = new Deserializer(typeRegistry);
    }

    public void SetApplicationContext(ApplicationContext applicationContext) {
        this.des.setApplicationContext(applicationContext);
    }

    protected CallContext newCallContext() {
        ApplicationContext applicationContext = this.des.getApplicationContext();
        CallContext callContext = new CallContext(this, applicationContext, this.reg);
        return callContext;
    }

    public void setProxyInterface(Class clazz) {
        this.proxyType = new InterfaceType(clazz);
        this.proxyType.reg = this.reg;
    }

    abstract Object called(Method var1, Object[] var2);

    public final void setInstance(Object object, ObjectType objectType) {
        this.instance = object;
        this.instanceType = objectType;
    }

    final Object mcall(Tree tree, CallContext callContext) {
        Tree tree2 = tree.firstChild;
        String string = tree2.value;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = tree2.nextSibling;
        while (object != null) {
            Object object2 = ((Tree)object).tag == null || ((Tree)object).tag.length() == 0 ? null : this.des.deserialize((Tree)object);
            arrayList.add(object2);
            object = ((Tree)object).nextSibling;
        }
        object = this.instanceType.getMethod(string);
        callContext.isVoid = ((Method)object).getReturnType() == Void.TYPE;
        try {
            return ((Method)object).invoke(this.instance, arrayList.toArray());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    final void done(CallContext callContext) {
        callContext.isDone = true;
    }

    final void processError(String string, CallContext callContext) {
        Tree tree;
        callContext.inputStream.reset(string);
        while ((tree = callContext.inputStream.nextTree()) != null) {
            this.dispatch(tree, callContext);
        }
    }

    Tree nextTree(boolean bl, CallContext callContext) {
        String string;
        Tree tree = callContext.inputStream.nextTree();
        if (tree == null && (string = this.transport.receive(bl, callContext)) != null) {
            callContext.inputStream.reset(string);
            tree = callContext.inputStream.nextTree();
        }
        return tree;
    }

    public final void process(CallContext callContext) {
        callContext.isDone = false;
        callContext.isBG = false;
        while (!callContext.isDone) {
            Tree tree = this.nextTree(true, callContext);
            this.dispatch(tree, callContext);
        }
    }

    public final void processV2(CallContext callContext) {
        Tree tree;
        callContext.isDone = false;
        callContext.isBG = false;
        while ((tree = this.nextTree(false, callContext)) != null) {
            this.dispatch(tree, callContext);
            if (!callContext.isDone) continue;
            return;
        }
        if (!callContext.isBG) {
            throw new RuntimeException("must be BG");
        }
        while (!callContext.isDone) {
            tree = this.nextTree(false, callContext);
            if (tree == null) {
                callContext.isBG = false;
                tree = this.nextTree(true, callContext);
                if (tree == null) {
                    throw new RuntimeException("tree is NULL");
                }
            }
            this.dispatch(tree, callContext);
            if (callContext.isBG) continue;
            throw new RuntimeException("must still be BG");
        }
    }
}

