/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.output;

import com.ca.siteminder.rpc.type.Formatter;
import com.ca.siteminder.rpc.type.ObjectType;
import com.ca.siteminder.rpc.type.PrimitiveType;
import com.ca.siteminder.rpc.type.PropInfo;
import com.ca.siteminder.rpc.type.Type;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class PrintFormatter
implements Formatter {
    PrintWriter out;
    F values;
    static String LS = System.getProperty("line.separator", "\n");
    static String LST = LS + "\t";
    static F flatF = new F("; ", ":", "(", ")", false);
    static F structF = new F(LST, ":", LST, LS, true);
    public static PrintFormatter defaultFormatter = new PrintFormatter(System.out);

    public void writeFS(boolean bl) {
        if (bl) {
            this.write(this.values.FS);
        }
    }

    public void writeKVS() {
        this.write(this.values.KVS);
    }

    public void startProperties(Type type, int n) {
        this.write(type.getName() + this.values.start);
    }

    public void endProperties(Type type) {
        this.write(this.values.end);
    }

    public void startKey() {
    }

    public void endValue(boolean bl) {
        this.writeFS(bl);
    }

    public void startCollection(Type type, int n) {
        this.write(type.getName() + this.values.start);
    }

    public void endCollection(Type type) {
        this.write(this.values.end);
    }

    public void startElement() {
    }

    public void endElement(boolean bl) {
        this.writeFS(bl);
    }

    public PrintFormatter(PrintWriter printWriter) {
        this.out = printWriter;
        this.values = flatF;
    }

    PrintFormatter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrintFormatter(OutputStream outputStream) {
        this(new PrintWriter(outputStream));
    }

    public PrintFormatter flat() {
        this.values = flatF;
        return this;
    }

    public PrintFormatter structured() {
        this.values = structF;
        return this;
    }

    public void write(String string) {
        this.out.write(string);
    }

    public void flush() {
        this.out.flush();
    }

    public void println() {
        this.out.println();
    }

    public void error(String string) {
        this.out.println(string);
    }

    public void println(String string) {
        this.out.println(string);
    }

    public void print(String string) {
        this.out.print(string);
    }

    public void primitive(PrimitiveType primitiveType, Object object) {
        int n;
        String string;
        String string2 = string = object != null ? object.toString() : "<null>";
        if ((string.startsWith("ODBC://") || string.startsWith("LDAP://")) && (n = string.indexOf(47, 8)) > 0) {
            string = string.substring(n);
        }
        this.write(string);
    }

    public void startObject(ObjectType objectType) {
        this.write(objectType.getName() + this.values.start);
    }

    public void endObject(ObjectType objectType) {
        this.write(this.values.end);
    }

    public void endField(String string, boolean bl) {
        this.writeFS(bl);
    }

    public void startField(ObjectType objectType, String string) {
        int n = string.length();
        int n2 = this.values.maxFieldLength;
        if (n2 > 0 && n > n2) {
            string = string.substring(0, n2 + 1);
            n = n2;
        }
        this.out.write(string);
        if (this.values.structured) {
            int n3 = PrintFormatter.maxFieldNameLength(objectType, n2) + 3 - string.length();
            for (int i = 0; i < n3; ++i) {
                this.out.write(" ");
            }
        } else {
            this.out.write(this.values.KVS);
        }
    }

    static synchronized int maxFieldNameLength(ObjectType objectType, int n) {
        if (n > 0) {
            return n;
        }
        if (objectType.maxPropNameLength >= 0) {
            return objectType.maxPropNameLength;
        }
        n = 0;
        Iterator iterator = objectType.fieldIterator();
        while (iterator.hasNext()) {
            PropInfo propInfo = (PropInfo)iterator.next();
            String string = propInfo.getName();
            int n2 = string.length();
            if (n2 <= n) continue;
            n = n2;
        }
        objectType.maxPropNameLength = n;
        return n;
    }

    static class F {
        String FS;
        String KVS;
        String start;
        String end;
        int maxFieldLength;
        boolean structured;

        F(String string, String string2, String string3, String string4, boolean bl) {
            this.FS = string;
            this.KVS = string2;
            this.start = string3;
            this.end = string4;
            this.structured = bl;
            this.maxFieldLength = 18;
        }
    }
}

