/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupResponseTestData;
import com.netegrity.sdk.policyapi.SmAgentType;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmResponse;
import com.netegrity.sdk.policyapi.SmResponseAttr;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SmResponse_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testGlobalResponse1() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testGlobalResponse1" + this.random);
        smResponse.setDescription("testGlobalResponse1" + this.random);
        smResponse.setAgentType((Object)"Web Agent");
        SmApiResult smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse = new SmResponse();
        SetupResponseTestData.policyapi.getResponse("testGlobalResponse1" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)"Unable to fetch response (INVALID OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to fetch response (NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse.setDescription("testDeleteGlobalResponse");
        smApiResult = SetupResponseTestData.policyapi.modifyResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testGlobalResponse1" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalResponseWithEJBAgentType() throws SmApiException {
        SmAgentType smAgentType = new SmAgentType();
        SmApiResult smApiResult = SetupResponseTestData.policyapi.getAgentType("EJB Agent", smAgentType);
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithEJBAgentType" + this.random);
        smResponse.setDescription("testaddGlobalResponseWithEJBAgentType");
        smResponse.setAgentType((Object)smAgentType);
        smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithEJBAgentType" + this.random);
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalResponseWithAffiliateAgentType() throws SmApiException {
        SmAgentType smAgentType = new SmAgentType();
        SmApiResult smApiResult = SetupResponseTestData.policyapi.getAgentType("Affiliate Agent", smAgentType);
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithAffiliateAgentType" + this.random);
        smResponse.setDescription("testaddGlobalResponseWithAffiliateAgentType");
        smResponse.setAgentType((Object)smAgentType);
        smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object.", (boolean)smResponse.getOid().isValid());
        smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithAffiliateAgentType" + this.random);
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalResponseWithServletAgentType() throws SmApiException {
        SmAgentType smAgentType = new SmAgentType();
        SmApiResult smApiResult = SetupResponseTestData.policyapi.getAgentType("Servlet Agent", smAgentType);
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithServletAgentType" + this.random);
        smResponse.setDescription("testaddGlobalResponseWithServletAgentType");
        smResponse.setAgentType((Object)smAgentType);
        smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testaddGlobalResponseWithServletAgentType" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to fetch global response. (INVALID OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to fetch global response. (NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithServletAgentType" + this.random);
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalResponseWithvariousAttrs() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithvariousAttrs" + this.random);
        smResponse.setDescription("testaddGlobalResponseWithvariousAttrs");
        SmApiResult smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        smApiResult = SetupResponseTestData.policyapi.getResponse("testaddGlobalResponseWithvariousAttrs" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smResponse.getOid().isNull());
        SmResponseAttr smResponseAttr = new SmResponseAttr();
        smResponseAttr.setAgentTypeAttr((Object)"WebAgent-OnReject-Redirect");
        smResponseAttr.setValue("varname=value");
        smResponseAttr.setResponse((Object)smResponse.getOid());
        smApiResult = SetupResponseTestData.policyapi.addResponseAttr(smResponseAttr, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smResponseAttr.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smResponseAttr.getOid().isNull());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testaddGlobalResponseWithvariousAttrs" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        smResponseAttr = new SmResponseAttr();
        smResponseAttr.setAgentTypeAttr((Object)"WebAgent-OnReject-Redirect");
        smResponseAttr.setValue("varname=value");
        smResponseAttr.setResponse((Object)smResponse.getOid());
        smApiResult = SetupResponseTestData.policyapi.addResponseAttr(smResponseAttr, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smResponseAttr.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smResponseAttr.getOid().isNull());
        Hashtable hashtable = new Hashtable();
        SetupResponseTestData.policyapi.getResponseAttrs("testaddGlobalResponseWithvariousAttrs" + this.random, SmObjId.NULL_OID.toString(), hashtable);
        Set set = hashtable.keySet();
        String string = null;
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            string = iterator.next().toString();
        }
        smApiResult = SetupResponseTestData.policyapi.deleteResponseAttr(SmObjId.valueOf(string), SmObjId.NULL_OID.toString());
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        Vector vector = new Vector();
        smApiResult = SetupResponseTestData.policyapi.getResponseAttrs("testaddGlobalResponseWithvariousAttrs" + this.random, SmObjId.NULL_OID.toString(), vector);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testaddGlobalResponseWithvariousAttrs" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object (INVALID OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object (NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponseAttr = new SmResponseAttr();
        smResponseAttr.setAgentTypeAttr((Object)"WebAgent-HTTP-Header-Variable");
        smResponseAttr.setValue("1=<@lib=\"2\" func=\"3\" param=\"4\"@>");
        smResponseAttr.setResponse((Object)smResponse.getOid());
        smApiResult = SetupResponseTestData.policyapi.addResponseAttr(smResponseAttr, true);
        SmResponse_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smResponseAttr.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smResponseAttr.getOid().isNull());
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testaddGlobalResponseWithvariousAttrs" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        smResponseAttr = new SmResponseAttr();
        smResponseAttr.setAgentTypeAttr((Object)"WebAgent-HTTP-Header-Variable");
        smResponseAttr.setValue("1=2");
        smResponseAttr.setResponse((Object)smResponse.getOid());
        smApiResult = SetupResponseTestData.policyapi.addResponseAttr(smResponseAttr, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smResponseAttr.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smResponseAttr.getOid().isNull());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testaddGlobalResponseWithvariousAttrs" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        smResponseAttr = new SmResponseAttr();
        smResponseAttr.setAgentTypeAttr((Object)"WebAgent-HTTP-Header-Variable");
        smResponseAttr.setValue("1=<#dn=\"3\" attr=\"4\"#>");
        smResponseAttr.setResponse((Object)smResponse.getOid());
        smApiResult = SetupResponseTestData.policyapi.addResponseAttr(smResponseAttr, true);
        SmResponse_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smResponseAttr.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smResponseAttr.getOid().isNull());
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smResponse.setName("testaddGlobalResponseWithvariousAttrs" + this.random);
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testmodifyGlobalResponseDescriptionByPassingDomainResponse() throws SmApiException {
        SetupResponseTestData.testDomainResponse.setDescription("Modified description");
        SmApiResult smApiResult = SetupResponseTestData.policyapi.modifyResponse(SetupResponseTestData.testDomainResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testGetNonExistantGlobalResponseObject() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        SmApiResult smApiResult = SetupResponseTestData.policyapi.getResponse("NonExistant" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Able to fetch a non-existant object.", (boolean)smResponse.getOid().isNull());
    }

    public void testdeleteAttributeFromGlobalResponseByPassingAgentOid() throws SmApiException {
        SmApiResult smApiResult = SetupResponseTestData.policyapi.deleteResponseAttr(SetupResponseTestData.agent.getOid(), SmObjId.NULL_OID.toString());
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalResponseWithRadiusAgentType() throws SmApiException {
        SmAgentType smAgentType = new SmAgentType();
        SmResponse smResponse = new SmResponse();
        SmApiResult smApiResult = SetupResponseTestData.policyapi.getAgentType("TeleBit", smAgentType);
        smResponse.setName("testaddGlobalResponseWithRadiusAgentType" + this.random);
        smResponse.setDescription("testaddGlobalResponseWithRadiusAgentType");
        smResponse.setAgentType((Object)smAgentType);
        smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Response with Radius agent type added. (OID VALID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertTrue((String)"Response with Radius agent type added. (OID NOT NULL)", (boolean)smResponse.getOid().isNull());
    }

    public void testmodifyGlobalResponseNametoEmptyString() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testmodifyGlobalResponseNametoEmptyString" + this.random);
        smResponse.setDescription("testmodifyGlobalResponseNametoEmptyString");
        smResponse.setAgentType((Object)"Web Agent");
        SmApiResult smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testmodifyGlobalResponseNametoEmptyString" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertFalse((String)"Unable to fetch response object(NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse.setName("");
        smApiResult = SetupResponseTestData.policyapi.modifyResponse(smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testmodifyGlobalResponseNametoEmptyString" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testmodifyGlobalResponseAgentType() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testmodifyGlobalResponseAgentType" + this.random);
        smResponse.setDescription("testmodifyGlobalResponseAgentType");
        smResponse.setAgentType((Object)"Web Agent");
        SmApiResult smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smResponse.getOid().isNull());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testmodifyGlobalResponseAgentType" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smResponse.getOid().isNull());
        SmAgentType smAgentType = new SmAgentType();
        smApiResult = SetupResponseTestData.policyapi.getAgentType("Affiliate Agent", smAgentType);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse.setAgentType((Object)smAgentType);
        smApiResult = SetupResponseTestData.policyapi.modifyResponse(smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testmodifyGlobalResponseAgentType" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smResponse.getOid().isValid());
        SmResponse_test.assertTrue((String)"Unable to create new object(NULL OID)", (boolean)smResponse.getOid().isNull());
    }

    public void testmodifyGlobalResponseNametoNameContainingAsterisk() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        SetupResponseTestData.policyapi.getResponse("testaddGlobalResponse" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        smResponse.setName("abc*abc" + this.random);
        SmApiResult smApiResult = SetupResponseTestData.policyapi.modifyResponse(smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testmodifyGlobalResponseAgentTypetoAnotherAgentType() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        SmAgentType smAgentType = new SmAgentType();
        SetupResponseTestData.policyapi.getAgentType("Affiliate Agent", smAgentType);
        SetupResponseTestData.policyapi.getResponse("testaddGlobalResponse" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        smResponse.setAgentType((Object)smAgentType);
        SmApiResult smApiResult = SetupResponseTestData.policyapi.modifyResponse(smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testchangeDomainOfGlobalResponsetoLocalDomain() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        smResponse.setName("testchangeDomainOfGlobalResponsetoLocalDomain" + this.random);
        smResponse.setDescription("testchangeDomainOfGlobalResponsetoLocalDomain");
        smResponse.setAgentType((Object)"Web Agent");
        SmApiResult smApiResult = SetupResponseTestData.policyapi.addResponse(smResponse, true);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmResponse_test.assertTrue((String)"Unable to create new object.", (boolean)smResponse.getOid().isValid());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testchangeDomainOfGlobalResponsetoLocalDomain" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse.setDomain((Object)SetupResponseTestData.domain);
        smApiResult = SetupResponseTestData.policyapi.modifyResponse(smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testchangeDomainOfGlobalResponsetoLocalDomain" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponse = new SmResponse();
        smApiResult = SetupResponseTestData.policyapi.getResponse("testchangeDomainOfGlobalResponsetoLocalDomain" + this.random, SmObjId.NULL_OID.toString(), smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testchangeDomainOflocalResponsetoGlobalDomain() throws SmApiException {
        SetupResponseTestData.testDomainResponse.setDomain((Object)SmObjId.NULL_OID);
        SmApiResult smApiResult = SetupResponseTestData.policyapi.modifyResponse(SetupResponseTestData.testDomainResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testDeleteNonExistantGlobalResponse() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        smResponse.setName("NonExistant" + this.random);
        SmApiResult smApiResult = SetupResponseTestData.policyapi.deleteResponse(smResponse);
        SmResponse_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmResponse_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SmResponse_test.class);
        return new SetupResponseTestData((Test)testSuite);
    }
}

