/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.func_test.SetupPolicyTestData;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmPolicy;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SmPolicy_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testaddGlobalPolicyWithName() throws SmApiException {
        SmPolicy smPolicy = new SmPolicy();
        smPolicy.setName("testaddGlobalPolicyWithName" + this.random);
        SmApiResult smApiResult = SetupPolicyTestData.policyapi.addPolicy(smPolicy, true);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smPolicy.getOid().isNull());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddGlobalPolicyWithName" + this.random, SmObjId.NULL_OID.toString(), smPolicy);
        SmPolicy_test.assertEquals((String)"Domain of the policy is not null", (boolean)smPolicy.getDomain().isNull(), (boolean)true);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to fetch the policy (Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to fetch the policy (NULL OID)", (boolean)smPolicy.getOid().isNull());
        smPolicy.setDescription("Modifying gpolicy");
        smApiResult = SetupPolicyTestData.policyapi.modifyPolicy(smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddGlobalPolicyWithName" + this.random, SmObjId.NULL_OID.toString(), smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to fetch the policy (Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to fetch the policy (NULL OID)", (boolean)smPolicy.getOid().isNull());
        SmPolicy_test.assertEquals((String)"Global Policy's description has not been modified", (String)"Modifying gpolicy", (String)smPolicy.getDescription());
        smApiResult = SetupPolicyTestData.policyapi.deletePolicy(smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddGlobalPolicyWithName" + this.random, SmObjId.NULL_OID.toString(), smPolicy);
        SmPolicy_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddGlobalPolicyWithNameAndLocalDomain() throws SmApiException {
        try {
            SmPolicy smPolicy = new SmPolicy();
            smPolicy.setName("testaddGlobalPolicyWithNameAndLocalDomain" + this.random);
            smPolicy.setDomain((Object)SetupPolicyTestData.domain);
            SmApiResult smApiResult = SetupPolicyTestData.policyapi.addPolicy(smPolicy, true);
            SmPolicy_test.fail((String)"Expected exception Incorrect parameters passed to the API call. didn't occur");
        }
        catch (SmApiException smApiException) {
            SmPolicy_test.assertEquals((String)"Incorrect parameters passed to the API call.", (String)smApiException.getMessage(), (String)"Incorrect parameters passed to the API call.");
        }
    }

    public void testLocalPolicyWithName() throws SmApiException {
        SmPolicy smPolicy = new SmPolicy();
        smPolicy.setName("testaddLocalPolicyWithName" + this.random);
        smPolicy.setDomain((Object)SetupPolicyTestData.domain);
        SmApiResult smApiResult = SetupPolicyTestData.policyapi.addPolicy(smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to create new object(Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to create new object(NULL OID)", (boolean)smPolicy.getOid().isNull());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddLocalPolicyWithName" + this.random, SetupPolicyTestData.domain.getName(), smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to fetch object(Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to fetch object(NULL OID)", (boolean)smPolicy.getOid().isNull());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddLocalPolicyWithName" + this.random, SmObjId.NULL_OID.toString(), smPolicy);
        SmPolicy_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddLocalPolicyWithName" + this.random, SetupPolicyTestData.domain.getName(), smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to fetch object(Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to fetch object(NULL OID)", (boolean)smPolicy.getOid().isNull());
        smPolicy.setDescription("modifying description of local policy");
        smApiResult = SetupPolicyTestData.policyapi.modifyPolicy(smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddLocalPolicyWithName" + this.random, SetupPolicyTestData.domain.getName(), smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to fetch the policy (Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to fetch the policy (NULL OID)", (boolean)smPolicy.getOid().isNull());
        SmPolicy_test.assertEquals((String)"Domain Policy's description has not been modified", (String)"modifying description of local policy", (String)smPolicy.getDescription());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddLocalPolicyWithName" + this.random, SetupPolicyTestData.domain.getName(), smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to fetch object(Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to fetch object(NULL OID)", (boolean)smPolicy.getOid().isNull());
        smPolicy.setDomain((Object)SmObjId.NULL_OID);
        smApiResult = SetupPolicyTestData.policyapi.modifyPolicy(smPolicy);
        SmPolicy_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddLocalPolicyWithName" + this.random, SetupPolicyTestData.domain.getName(), smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmPolicy_test.assertTrue((String)"Unable to fetch object(Invalid OID)", (boolean)smPolicy.getOid().isValid());
        SmPolicy_test.assertFalse((String)"Unable to fetch object(NULL OID)", (boolean)smPolicy.getOid().isNull());
        smApiResult = SetupPolicyTestData.policyapi.deletePolicy(smPolicy);
        SmPolicy_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smPolicy = new SmPolicy();
        smApiResult = SetupPolicyTestData.policyapi.getPolicy("testaddLocalPolicyWithName" + this.random, SetupPolicyTestData.domain.getName(), smPolicy);
        SmPolicy_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testaddLocalPolicyWithNameWithGlobalDomain() throws SmApiException {
        try {
            SmPolicy smPolicy = new SmPolicy();
            smPolicy.setName("testaddLocalPolicyWithNameWithGlobalDomain" + this.random);
            SmApiResult smApiResult = SetupPolicyTestData.policyapi.addPolicy(smPolicy);
            SmPolicy_test.fail((String)"Expected exception Incorrect parameters passed to the API call. didn't occur");
        }
        catch (SmApiException smApiException) {
            SmPolicy_test.assertEquals((String)"Incorrect parameters passed to the API call.", (String)smApiException.getMessage(), (String)"Incorrect parameters passed to the API call.");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmPolicy_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SmPolicy_test.class);
        return new SetupPolicyTestData((Test)testSuite);
    }
}

