/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.policyapi.SmAgent;
import com.netegrity.sdk.policyapi.SmAgentGroup;
import com.netegrity.sdk.policyapi.SmDomain;
import com.netegrity.sdk.policyapi.SmObject;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmRule;
import junit.framework.Test;

class SetupRuleTestData
extends SetupConnection {
    public static SmAgent agent;
    public static SmAgent ejbAgent;
    public static SmAgent radagent;
    public static SmAgentGroup aggroup;
    public static SmDomain domain;
    public static SmRealm realm;
    public static SmRule rule;

    SetupRuleTestData(Test test) {
        super(test);
    }

    protected void setUp() {
        this.Connect();
        this.CreateObjects();
    }

    private void CreateObjects() {
        long l = System.currentTimeMillis();
        agent = new SmAgent();
        agent.setName("agent" + l);
        ejbAgent = new SmAgent();
        ejbAgent.setName("ejbagent" + l);
        ejbAgent.setAgentType((Object)"EJB Agent");
        radagent = new SmAgent();
        radagent.setName("radagent" + l);
        radagent.setAgentType((Object)"3Com");
        aggroup = new SmAgentGroup();
        aggroup.setName("aggroup" + l);
        domain = new SmDomain();
        domain.setName("domain" + l);
        realm = new SmRealm();
        realm.setName("realm" + l);
        realm.setResourceFilter("*");
        realm.setDomain((Object)domain);
        realm.setAgent((Object)agent.getOid());
        realm.setAgentType((Object)"Web Agent");
        rule = new SmRule();
        rule.setName("rule" + l);
        rule.setDomain((Object)domain);
        rule.setRealm((Object)realm);
        rule.setAgentType((Object)"Web Agent");
        try {
            policyapi.addAgent(agent);
            policyapi.addAgent(ejbAgent);
            policyapi.addAgent(radagent);
            policyapi.addGroup("", (SmObject)aggroup);
            policyapi.addDomain(domain);
            realm.setAgent((Object)agent);
            policyapi.addRealm(realm);
            policyapi.addRule(rule);
        }
        catch (SmApiException smApiException) {
            // empty catch block
        }
    }

    protected void tearDown() throws SmApiException {
        policyapi.deleteDomain(domain.getName());
        policyapi.deleteAgent(agent.getName());
        policyapi.deleteAgent(ejbAgent.getName());
        policyapi.deleteAgent(radagent.getName());
        super.tearDown();
    }
}

