/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.policyapi.SmAgent;
import com.netegrity.sdk.policyapi.SmDomain;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmPolicy;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmResponse;
import com.netegrity.sdk.policyapi.SmRule;
import junit.framework.Test;

class SetupPolicyLinkTestData
extends SetupConnection {
    public static SmAgent agent;
    public static SmDomain domain;
    public static SmRealm realm;
    public static SmResponse globalResponse;
    public static SmResponse localResponse;
    public static SmResponse testDomainResponse;
    public static SmRule localRule;
    public static SmRule globalRule;
    public static SmPolicy localPolicy;
    public static SmPolicy globalPolicy;

    SetupPolicyLinkTestData(Test test) {
        super(test);
    }

    protected void setUp() {
        this.Connect();
        try {
            Thread.sleep(0L);
            this.CreateObjects();
            Thread.sleep(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void CreateObjects() {
        long l = System.currentTimeMillis();
        agent = new SmAgent();
        agent.setName("agent" + l);
        domain = new SmDomain();
        domain.setName("domain" + l);
        realm = new SmRealm();
        realm.setName("localRealm" + l);
        realm.setResourceFilter("*");
        realm.setDomain((Object)domain);
        realm.setAgent((Object)agent.getOid());
        realm.setAgentType((Object)"Web Agent");
        testDomainResponse = new SmResponse();
        testDomainResponse.setName("testDomainResponse" + l);
        testDomainResponse.setDescription("testDomainResponse" + l);
        testDomainResponse.setAgentType((Object)"Web Agent");
        testDomainResponse.setDomain((Object)domain);
        localRule = new SmRule();
        localRule.setName("localRule" + l);
        localRule.setAction("Get");
        try {
            policyapi.addAgent(agent);
            policyapi.addDomain(domain);
            realm.setAgent((Object)agent);
            policyapi.addRealm(realm);
            policyapi.addResponse(testDomainResponse);
            localRule.setDomain((Object)domain);
            localRule.setRealm((Object)realm);
            policyapi.addRule(localRule);
            globalRule = new SmRule();
            globalRule.setName("globalRule" + l);
            globalRule.setDomain((Object)SmObjId.NULL_OID);
            globalRule.setRealm((Object)SmObjId.NULL_OID);
            globalRule.setAgent((Object)agent.getOid());
            globalRule.setAction("OnAuthAccept");
            policyapi.addRule(globalRule, true);
            globalResponse = new SmResponse();
            globalResponse.setName("globalResponse" + l);
            globalResponse.setDomain((Object)SmObjId.NULL_OID);
            globalResponse.setAgentType((Object)"Web Agent");
            policyapi.addResponse(globalResponse, true);
            localResponse = new SmResponse();
            localResponse.setName("localResponse" + l);
            localResponse.setDomain((Object)domain);
            localResponse.setAgentType((Object)"Web Agent");
            policyapi.addResponse(localResponse);
            localPolicy = new SmPolicy();
            localPolicy.setName("localPolicy" + l);
            localPolicy.setDomain((Object)domain);
            policyapi.addPolicy(localPolicy);
            globalPolicy = new SmPolicy();
            globalPolicy.setName("globalPolicy" + l);
            globalPolicy.setDomain((Object)SmObjId.NULL_OID);
            policyapi.addPolicy(globalPolicy, true);
        }
        catch (SmApiException smApiException) {
            // empty catch block
        }
    }

    protected void tearDown() throws SmApiException {
        policyapi.deleteDomain(domain.getName());
        policyapi.deleteAgent(agent.getName());
        policyapi.deleteRule(globalRule);
        policyapi.deleteResponse(globalResponse);
        policyapi.deletePolicy(globalPolicy);
        super.tearDown();
    }
}

