/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.func_test;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmProperty;
import com.netegrity.sdk.func_test.SetupConnection;
import com.netegrity.sdk.func_test.SetupResponseTestData;
import com.netegrity.sdk.policyapi.SmAgentConfig;
import com.netegrity.sdk.policyapi.SmAgentType;
import com.netegrity.sdk.policyapi.SmAgentTypeAttr;
import com.netegrity.sdk.policyapi.SmAuthAzMap;
import com.netegrity.sdk.policyapi.SmDomain;
import com.netegrity.sdk.policyapi.SmHostConfig;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmObject;
import com.netegrity.sdk.policyapi.SmResponse;
import com.netegrity.sdk.policyapi.SmResponseAttr;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DashboardIssues_test
extends TestCase {
    long random = System.currentTimeMillis();

    public void testDashboardIssue22() throws SmApiException {
        SmAgentConfig smAgentConfig = new SmAgentConfig();
        smAgentConfig.setName("AgentConfig" + this.random);
        smAgentConfig.setDescription("Testing agent config Dashboard issue #22");
        SmProperty[] smPropertyArray = new SmProperty[4];
        Character c = new Character('\u0003');
        String string = "SIGMA" + c + "ADMIN" + c + "UI";
        smPropertyArray[0] = new SmProperty("DefaultAgentName", string, 0);
        smPropertyArray[1] = new SmProperty("TraceFile", "no", 1);
        smPropertyArray[2] = new SmProperty("LogFileSize", "100", 0);
        smAgentConfig.setAgentConfigProperties(smPropertyArray);
        SmApiResult smApiResult = SetupResponseTestData.policyapi.addAgentConfig(smAgentConfig);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create Agent Config with properties. (INVALID OID)", (boolean)smAgentConfig.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create Agent Config with properties. (NULL OID)", (boolean)smAgentConfig.getOid().isNull());
        SmAgentConfig smAgentConfig2 = new SmAgentConfig();
        smApiResult = SetupResponseTestData.policyapi.getAgentConfig("AgentConfig" + this.random, smAgentConfig2);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to fetch Agent Config with properties. (INVALID OID)", (boolean)smAgentConfig2.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to fetch Agent Config with properties. (NULL OID)", (boolean)smAgentConfig2.getOid().isNull());
        SmProperty[] smPropertyArray2 = new SmProperty[4];
        smAgentConfig2.getAgentConfigProperties(smPropertyArray2);
        for (int i = 0; i < 3; ++i) {
            SmProperty smProperty = new SmProperty();
            smProperty = smPropertyArray2[i];
            if (smProperty.getName().equals("TraceFile")) {
                DashboardIssues_test.assertEquals((String)"Property TraceFile value not set. ", (String)"no", (String)smProperty.getValue());
                DashboardIssues_test.assertEquals((String)"Property TraceFile type not set. ", (int)1, (int)smProperty.getType());
                continue;
            }
            if (smProperty.getName().equals("AnnotationID")) {
                DashboardIssues_test.assertEquals((String)"Property AnnotationID value not set. ", (String)"", (String)smProperty.getValue());
                DashboardIssues_test.assertEquals((String)"Property AnnotationID type not set. ", (int)0, (int)smProperty.getType());
                continue;
            }
            if (smProperty.getName().equals("DefaultAgentName")) {
                DashboardIssues_test.assertEquals((String)"Property DefaultAgentName value not set.", (String)"SIGMA\u0003ADMIN\u0003UI", (String)smProperty.getValue());
                DashboardIssues_test.assertEquals((String)"Property DefaultAgentName type not set.", (int)0, (int)smProperty.getType());
                continue;
            }
            if (!smProperty.getName().equals("LogFileSize")) continue;
            DashboardIssues_test.assertEquals((String)"Property LogFileSize value not set.", (String)"100", (String)smProperty.getValue());
            DashboardIssues_test.assertEquals((String)"Property LogFileSize type not set.", (int)0, (int)smProperty.getType());
        }
        smApiResult = SetupResponseTestData.policyapi.deleteAgentConfig("AgentConfig" + this.random);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smAgentConfig2 = new SmAgentConfig();
        smApiResult = SetupResponseTestData.policyapi.getAgentConfig("AgentConfig" + this.random, smAgentConfig2);
        DashboardIssues_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testDashboardIssue27() throws SmApiException {
        SmUserDirectory smUserDirectory = new SmUserDirectory();
        smUserDirectory.setName("testSampleUserdir" + this.random);
        smUserDirectory.setNamespace("LDAP:");
        smUserDirectory.setServer("127.0.0.1");
        SmApiResult smApiResult = SetupConnection.policyapi.addUserDirectory(smUserDirectory);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create user directory (INVALID OID).", (boolean)smUserDirectory.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create user directory (NULL OID).", (boolean)smUserDirectory.getOid().isNull());
        smUserDirectory = new SmUserDirectory();
        SetupConnection.policyapi.getUserDirectory("testSampleUserdir" + this.random, smUserDirectory);
        SmAuthAzMap smAuthAzMap = new SmAuthAzMap();
        smAuthAzMap.setAuthUserDir((Object)smUserDirectory.getOid());
        smAuthAzMap.setAzUserDir((Object)smUserDirectory.getOid());
        smAuthAzMap.setAuthAzType(2);
        smApiResult = SetupConnection.policyapi.addAuthAzMap(smAuthAzMap);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create AuthAzMap. (INVALID OID)", (boolean)smAuthAzMap.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create AuthAzMap. (NULL OID)", (boolean)smAuthAzMap.getOid().isNull());
        Vector vector = new Vector();
        smApiResult = SetupResponseTestData.policyapi.getGlobalObjectNames("AuthAzMaps", vector);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupResponseTestData.policyapi.deleteAuthAzMap(smAuthAzMap.getOid());
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteUserDirectory("testSampleUserdir" + this.random);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testDashboardIssue28() throws SmApiException {
        String[] stringArray = new String[]{"Authenticate"};
        SmAgentType smAgentType = new SmAgentType();
        smAgentType.setName("agenttype" + this.random);
        smAgentType.setDescription("Testing Dashboard issue28.");
        smAgentType.setAgentType(0);
        smAgentType.setResourceType(0);
        smAgentType.setActions(stringArray);
        smAgentType.setRfcId(1);
        smAgentType.setAgentTypeSpecific(2);
        SmApiResult smApiResult = SetupConnection.policyapi.addAgentType(smAgentType);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create Agent Type. (INVALID OID)", (boolean)smAgentType.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create Agent Type. (NULL OID)", (boolean)smAgentType.getOid().isNull());
        smAgentType = new SmAgentType();
        smApiResult = SetupConnection.policyapi.getAgentType("agenttype" + this.random, smAgentType);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        SmAgentTypeAttr smAgentTypeAttr = new SmAgentTypeAttr();
        smAgentTypeAttr.setName("agentTypeAttr" + this.random);
        smAgentTypeAttr.setDescription("Testing Dashboard issue28.");
        smAgentTypeAttr.setAgentType(smAgentType);
        smAgentTypeAttr.setId(15);
        smAgentTypeAttr.setDataType(1);
        smAgentTypeAttr.setRadiusType(0);
        int[] nArray = new int[]{1, 2, 1, 2, 2, 2};
        smAgentTypeAttr.setRadiusBehavior(nArray);
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        hashtable.put(new Integer(1), "value1");
        smAgentTypeAttr.setValues(hashtable);
        smApiResult = SetupConnection.policyapi.addAgentTypeAttr(smAgentTypeAttr);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create Agent Type attribute. (INVALID OID)", (boolean)smAgentTypeAttr.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create Agent Type attribute. (NULL OID)", (boolean)smAgentTypeAttr.getOid().isNull());
        smApiResult = SetupConnection.policyapi.getAgentTypeAttr("agentTypeAttr" + this.random, smAgentTypeAttr);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        hashtable = new Hashtable();
        hashtable.put(new Integer(1), "value1");
        hashtable.put(new Integer(2), "value2");
        hashtable.put(new Integer(3), "value3");
        smAgentTypeAttr.setValues(hashtable);
        smApiResult = SetupConnection.policyapi.modifyAgentTypeAttr(smAgentTypeAttr);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteAgentType("agenttype" + this.random);
        smAgentType = new SmAgentType();
        smApiResult = SetupConnection.policyapi.getAgentType("agenttype" + this.random, smAgentType);
        DashboardIssues_test.assertFalse((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to delete Agent Type. (NULL OID)", (boolean)smAgentType.getOid().isNull());
    }

    public void testDashboardIssue28respAttr() throws SmApiException {
        SmDomain smDomain = new SmDomain();
        smDomain.setName("domain" + this.random);
        SmApiResult smApiResult = SetupConnection.policyapi.addDomain(smDomain);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create domain. (INVALID OID)", (boolean)smDomain.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create domain. (NULL OID)", (boolean)smDomain.getOid().isNull());
        SmResponse smResponse = new SmResponse();
        smResponse.setName("domainResponse" + this.random);
        smResponse.setDescription("Testing Dashboard Issue28");
        smResponse.setAgentType((Object)"Web Agent");
        smResponse.setDomain((Object)smDomain);
        smApiResult = SetupConnection.policyapi.addResponse(smResponse);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create response. (INVALID OID)", (boolean)smResponse.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create response. (NULL OID)", (boolean)smResponse.getOid().isNull());
        SmResponseAttr smResponseAttr = new SmResponseAttr();
        smResponseAttr.setName("responseAttr" + this.random);
        smResponseAttr.setAgentTypeAttr((Object)"WebAgent-HTTP-Header-Variable");
        smResponseAttr.setType(4);
        smResponseAttr.setDomain((Object)smDomain);
        smResponseAttr.setResponse((Object)smResponse);
        smResponseAttr.setTTL(60);
        smResponseAttr.setValue("varName = varValue");
        SetupConnection.policyapi.addResponseAttr(smResponseAttr);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create response attr. (INVALID OID)", (boolean)smResponseAttr.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create response attr. (NULL OID)", (boolean)smResponseAttr.getOid().isNull());
        Hashtable hashtable = new Hashtable();
        smApiResult = SetupConnection.policyapi.getResponseAttrs("domainResponse" + this.random, "domain" + this.random, hashtable);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        Set set = hashtable.keySet();
        String string = null;
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            string = iterator.next().toString();
        }
        SmResponseAttr smResponseAttr2 = new SmResponseAttr();
        smApiResult = SetupConnection.policyapi.getObject(string, (SmObject)smResponseAttr2);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponseAttr2.setValue("varName = MODIFIEDvarValue");
        smApiResult = SetupConnection.policyapi.modifyResponseAttr(smResponseAttr2);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteResponse(smResponse);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteDomain(smDomain.getName());
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testDashboardIssue28GlobalrespAttr() throws SmApiException {
        SmResponse smResponse = new SmResponse();
        smResponse.setName("globalResponse" + this.random);
        smResponse.setDescription("Testing Dashboard Issue28");
        smResponse.setAgentType((Object)"Web Agent");
        SmApiResult smApiResult = SetupConnection.policyapi.addResponse(smResponse, true);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create response. (INVALID OID)", (boolean)smResponse.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create response. (NULL OID)", (boolean)smResponse.getOid().isNull());
        SmResponseAttr smResponseAttr = new SmResponseAttr();
        smResponseAttr.setName("responseAttr" + this.random);
        smResponseAttr.setAgentTypeAttr((Object)"WebAgent-HTTP-Header-Variable");
        smResponseAttr.setType(4);
        smResponseAttr.setResponse((Object)smResponse);
        smResponseAttr.setTTL(60);
        smResponseAttr.setValue("varName = varValue");
        SetupConnection.policyapi.addResponseAttr(smResponseAttr, true);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create response attr. (INVALID OID)", (boolean)smResponseAttr.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create response attr. (NULL OID)", (boolean)smResponseAttr.getOid().isNull());
        Hashtable hashtable = new Hashtable();
        smApiResult = SetupConnection.policyapi.getResponseAttrs("globalResponse" + this.random, SmObjId.NULL_OID.toString(), hashtable);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        Set set = hashtable.keySet();
        String string = null;
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            string = iterator.next().toString();
        }
        SmResponseAttr smResponseAttr2 = new SmResponseAttr();
        smApiResult = SetupConnection.policyapi.getObject(string, (SmObject)smResponseAttr2);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smResponseAttr2.setValue("varName = MODIFIEDvarValue");
        smApiResult = SetupConnection.policyapi.modifyResponseAttr(smResponseAttr2);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        smApiResult = SetupConnection.policyapi.deleteResponse(smResponse);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testDashboardIssue31a() throws SmApiException {
        SmHostConfig smHostConfig = new SmHostConfig();
        String string = "127.0.0.1,44442;127.0.0.1,44441:127.0.0.1,44443";
        smHostConfig.setName("hostconfigWithoutServer" + this.random);
        smHostConfig.setFailoverThreshold(75);
        smHostConfig.setEnableFailOver(1);
        smHostConfig.setClusters(string);
        smHostConfig.setMaxSocketPerPort(20);
        smHostConfig.setMinSocketPerPort(2);
        smHostConfig.setNewSocketStep(2);
        smHostConfig.setRequestTimeout(60);
        smHostConfig.setDescription("Testing dashboard issue31");
        SmApiResult smApiResult = SetupConnection.policyapi.addHostConfig(smHostConfig);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create host config object. (INVALID OID)", (boolean)smHostConfig.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create host config object. (NULL OID)", (boolean)smHostConfig.getOid().isNull());
        smHostConfig = new SmHostConfig();
        smApiResult = SetupConnection.policyapi.getHostConfig("hostconfigWithoutServer" + this.random, smHostConfig);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to fetch host config object. (INVALID OID)", (boolean)smHostConfig.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to fetch host config object. (NULL OID)", (boolean)smHostConfig.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteHostConfig("hostconfigWithoutServer" + this.random);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public void testDashboardIssue31b() throws SmApiException {
        SmHostConfig smHostConfig = new SmHostConfig();
        String string = "127.0.0.1,44442;127.0.0.1,44441:127.0.0.1,44443";
        String string2 = "127.0.0.1,44442,44441,44443;127.0.0.1,44442,444441,44443";
        smHostConfig.setName("hostconfigWithServer" + this.random);
        smHostConfig.setFailoverThreshold(75);
        smHostConfig.setEnableFailOver(1);
        smHostConfig.setClusters(string);
        smHostConfig.setServers(string2);
        smHostConfig.setMaxSocketPerPort(20);
        smHostConfig.setMinSocketPerPort(2);
        smHostConfig.setNewSocketStep(2);
        smHostConfig.setRequestTimeout(60);
        smHostConfig.setDescription("Testing dashboard issue31");
        SmApiResult smApiResult = SetupConnection.policyapi.addHostConfig(smHostConfig);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to create host config object. (INVALID OID)", (boolean)smHostConfig.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to create host config object. (NULL OID)", (boolean)smHostConfig.getOid().isNull());
        smHostConfig = new SmHostConfig();
        smApiResult = SetupConnection.policyapi.getHostConfig("hostconfigWithServer" + this.random, smHostConfig);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
        DashboardIssues_test.assertTrue((String)"Unable to fetch host config object. (INVALID OID)", (boolean)smHostConfig.getOid().isValid());
        DashboardIssues_test.assertFalse((String)"Unable to fetch host config object. (NULL OID)", (boolean)smHostConfig.getOid().isNull());
        smApiResult = SetupConnection.policyapi.deleteHostConfig("hostconfigWithServer" + this.random);
        DashboardIssues_test.assertTrue((String)smApiResult.getMessage(), (boolean)smApiResult.isSuccess());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DashboardIssues_test.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(DashboardIssues_test.class);
        return new SetupConnection((Test)testSuite);
    }
}

