/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.DHPrivateKey;
import com.rsa.crypto.DHPublicKey;
import com.rsa.crypto.DomainParams;
import com.rsa.crypto.ECParams;
import com.rsa.crypto.ECPrivateKey;
import com.rsa.crypto.ECPublicKey;
import com.rsa.crypto.InvalidKeyException;
import com.rsa.crypto.KeyAgreement;
import com.rsa.crypto.KeyPair;
import com.rsa.crypto.KeyPairGenerator;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.PQGParams;
import com.rsa.crypto.PrivateKey;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.SecureRandom;
import com.rsa.cryptoj.c.bj;
import com.rsa.cryptoj.c.bp;
import com.rsa.cryptoj.c.ca;
import com.rsa.cryptoj.c.ce;
import com.rsa.cryptoj.c.cf;
import com.rsa.cryptoj.c.cj;
import com.rsa.cryptoj.c.cl;
import com.rsa.cryptoj.c.cu;
import com.rsa.cryptoj.c.dc;
import com.rsa.cryptoj.c.dn;
import com.rsa.cryptoj.c.dp;
import com.rsa.cryptoj.c.dt;
import com.rsa.cryptoj.c.eb;
import com.rsa.cryptoj.c.ej;
import com.rsa.cryptoj.c.et;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.a;
import java.util.Arrays;

public final class JSAFE_KeyAgree
extends JSAFE_Object {
    private static final long serialVersionUID = -8376703800168183266L;
    protected static final int a = 0;
    protected static final int b = 1;
    protected static final int c = 2;
    protected static final int d = 3;
    private static final String h = "Improper method call order.";
    private static final String i = "Random number generator not set.";
    private static final String j = "Parameters have not been set.";
    private static final String k = "Private value is null.";
    private static final int l = 1;
    private KeyAgreement m;
    private final CryptoModule n;
    private final String o;
    private int p;
    private PrivateKey q;
    private PublicKey r;
    private PublicKey s;
    private DomainParams t;
    private SecureRandom u;

    private JSAFE_KeyAgree(CryptoModule cryptoModule, KeyAgreement keyAgreement, DomainParams domainParams) {
        this(cryptoModule, keyAgreement);
        this.t = domainParams;
    }

    private JSAFE_KeyAgree(CryptoModule cryptoModule, KeyAgreement keyAgreement) {
        this.n = cryptoModule;
        this.m = keyAgreement;
        this.o = this.m.getAlg();
    }

    public static JSAFE_KeyAgree getInstance(byte[] byArray, int n2, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_KeyAgree.a(byArray, n2, string, ce.a());
    }

    public static JSAFE_KeyAgree getInstance(byte[] byArray, int n2, String string, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_KeyAgree.a(byArray, n2, string, fIPS140Context.a());
    }

    public static JSAFE_KeyAgree getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_KeyAgree.a(string, string2, ce.a());
    }

    public static JSAFE_KeyAgree getInstance(String string, String string2, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_KeyAgree.a(string, string2, fIPS140Context.a());
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws JSAFE_UnimplementedException {
        return eb.a(byArray, n2);
    }

    private static JSAFE_KeyAgree a(byte[] byArray, int n2, String string, cf cf2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        ca[] caArray;
        for (ca ca2 : caArray = JSAFE_KeyAgree.a(string)) {
            try {
                cj cj2 = cl.a(cf2, ca2);
                eb eb2 = eb.a(byArray, n2, cj2);
                return new JSAFE_KeyAgree(cj2, cj2.newKeyAgreement(eb2.a()), eb2.f());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (bj bj2) {
                // empty catch block
            }
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices");
    }

    private static JSAFE_KeyAgree a(String string, String string2, cf cf2) throws JSAFE_UnimplementedException {
        if (string == null || string2 == null) {
            throw new JSAFE_UnimplementedException("A JSAFE_KeyAgree object of " + string + " is not available on any of the devices. (" + string2 + ")");
        }
        ca[] caArray = JSAFE_KeyAgree.a(string2);
        String string3 = dt.a(string);
        for (ca ca2 : caArray) {
            try {
                cj cj2 = cl.a(cf2, ca2);
                return new JSAFE_KeyAgree(cj2, cj2.newKeyAgreement(string3));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (bj bj2) {
                // empty catch block
            }
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices");
    }

    @Override
    public void clearSensitiveData() {
        this.t = null;
        dn.a.a(this.m);
        dn.a.a(this.q);
        dn.a.a(this.r);
        dn.a.a(this.s);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JSAFE_KeyAgree jSAFE_KeyAgree = (JSAFE_KeyAgree)super.clone();
        jSAFE_KeyAgree.m = (KeyAgreement)this.m.clone();
        jSAFE_KeyAgree.q = (PrivateKey)dc.a(this.q);
        jSAFE_KeyAgree.r = (PublicKey)dc.a(this.r);
        jSAFE_KeyAgree.s = (PublicKey)dc.a(this.s);
        jSAFE_KeyAgree.t = this.t;
        jSAFE_KeyAgree.u = this.u == null ? null : this.u.newInstance();
        return jSAFE_KeyAgree;
    }

    public JSAFE_PublicKey generateMyPublicValue() throws JSAFE_InvalidUseException {
        if (this.p != 1) {
            throw new JSAFE_InvalidUseException(h);
        }
        this.a(this.t, this.u);
        this.a();
        this.p = 2;
        return ej.a(this.r, this.n);
    }

    private void a(DomainParams domainParams, SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        if (domainParams == null) {
            throw new JSAFE_InvalidUseException("Params should not be null.");
        }
        if (this.q != null) {
            this.q.clearSensitiveData();
        }
        if (this.r != null) {
            this.r.clearSensitiveData();
        }
        String string = this.b() ? "EC" : "DH";
        try {
            KeyPairGenerator keyPairGenerator = this.n.newKeyPairGenerator(string);
            keyPairGenerator.initialize(domainParams, secureRandom);
            KeyPair keyPair = keyPairGenerator.generate();
            this.q = keyPair.getPrivate();
            this.r = keyPair.getPublic();
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException);
        }
    }

    public byte[] generateSharedSecret() throws JSAFE_InvalidUseException {
        if (this.p < 1) {
            throw new JSAFE_InvalidUseException("KeyAgreement has not been initialized.");
        }
        if (this.p >= 3) {
            throw new JSAFE_InvalidUseException(h);
        }
        if (this.s == null) {
            throw new JSAFE_InvalidUseException("Public key of target must be given.");
        }
        this.m.doPhase(this.s, true);
        this.p = 3;
        return this.m.getSecret();
    }

    public int generateSharedSecret(byte[] byArray, int n2) throws JSAFE_InvalidUseException {
        if (this.p < 2 || this.p >= 3) {
            throw new JSAFE_InvalidUseException(h);
        }
        byte[] byArray2 = this.generateSharedSecret();
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    public byte[] generateSharedSecret(JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        if (this.p != 1) {
            throw new JSAFE_InvalidUseException(h);
        }
        if (jSAFE_PublicKey == null || jSAFE_PublicKey.f() == null) {
            throw new JSAFE_InvalidKeyException("PublicKey must not be null");
        }
        PublicKey publicKey = jSAFE_PublicKey.a(this.n);
        try {
            this.m.doPhase(publicKey, true);
        }
        finally {
            publicKey.clearSensitiveData();
        }
        this.p = 3;
        return this.m.getSecret();
    }

    public int generateSharedSecret(JSAFE_PublicKey jSAFE_PublicKey, byte[] byArray, int n2) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        if (this.p != 1) {
            throw new JSAFE_InvalidUseException(h);
        }
        byte[] byArray2 = this.generateSharedSecret(jSAFE_PublicKey);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    public JSAFE_KeyPair getBlankKeyPair() {
        String string = this.o;
        if (string.startsWith("EC")) {
            string = "EC";
        }
        return JSAFE_KeyPair.a(this.n, dt.b(string));
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        if (this.t == null) {
            return eb.a(this.o, new byte[0][]);
        }
        if (this.b()) {
            return bp.a((ECParams)this.t);
        }
        return bp.a((PQGParams)this.t);
    }

    public String getDevice() {
        return this.n.getDeviceType();
    }

    public String[] getDeviceList() {
        Object[] objectArray = new String[1];
        Arrays.fill(objectArray, this.getDevice());
        return objectArray;
    }

    public String getKeyAgreeAlgorithm() {
        return this.o;
    }

    public int getOutputSize() {
        if (this.t == null) {
            return 0;
        }
        if (this.b()) {
            return (((ECParams)this.t).getFieldSize() + 7) / 8 * 2 + 1;
        }
        return (((PQGParams)this.t).getP().getBitLength() + 7) / 8;
    }

    public byte[] getPrivateValue() {
        if (this.q == null) {
            return new byte[0];
        }
        if (this.b()) {
            return ((ECPrivateKey)this.q).getD().toOctetString();
        }
        return ((DHPrivateKey)this.q).getX().toOctetString();
    }

    public int getPrivateValue(byte[] byArray, int n2) {
        byte[] byArray2 = this.getPrivateValue();
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    public JSAFE_PrivateKey getPrivateValueAsKey() throws JSAFE_InvalidUseException {
        if (this.q == null) {
            throw new JSAFE_InvalidUseException(k);
        }
        return ej.a(this.q, this.n);
    }

    public JSAFE_Parameters getSharedParameters() throws JSAFE_InvalidUseException {
        if (this.t == null) {
            throw new JSAFE_InvalidUseException(j);
        }
        try {
            return et.a(this.t, this.n, this.o);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new JSAFE_InvalidUseException(jSAFE_UnimplementedException);
        }
    }

    public void keyAgreeInit(JSAFE_Parameters jSAFE_Parameters, JSAFE_PrivateKey jSAFE_PrivateKey, java.security.SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        if (jSAFE_Parameters == null) {
            throw new JSAFE_InvalidUseException(j);
        }
        if (jSAFE_Parameters.getAlgorithm().indexOf(this.o) == -1 && this.o.indexOf(jSAFE_Parameters.getAlgorithm()) == -1) {
            throw new JSAFE_InvalidParameterException("Invalid " + this.o + " parameters.");
        }
        if (jSAFE_PrivateKey == null) {
            throw new JSAFE_InvalidKeyException("Invalid " + this.o + " private key.");
        }
        this.a(jSAFE_Parameters, jSAFE_PrivateKey);
        this.u = com.rsa.jsafe.a.b(secureRandom);
        this.a();
        this.p = 1;
    }

    public void keyAgreeInit(JSAFE_Parameters jSAFE_Parameters, JSAFE_PublicKey jSAFE_PublicKey, java.security.SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException(i);
        }
        if (jSAFE_Parameters == null) {
            throw new JSAFE_InvalidUseException(j);
        }
        this.b(jSAFE_Parameters.getAlgorithm());
        if (jSAFE_PublicKey == null || jSAFE_PublicKey.f() == null) {
            throw new JSAFE_InvalidKeyException("Invalid " + this.o + " public key.");
        }
        this.a(jSAFE_Parameters, jSAFE_PublicKey);
        this.u = com.rsa.jsafe.a.b(secureRandom);
        this.p = 1;
    }

    private void b(String string) throws JSAFE_InvalidParameterException {
        if (this.o.indexOf(string) == -1) {
            throw new JSAFE_InvalidParameterException("Invalid " + this.o + " parameters.");
        }
    }

    public void keyAgreeInit(JSAFE_Parameters jSAFE_Parameters, java.security.SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException(i);
        }
        if (jSAFE_Parameters == null || jSAFE_Parameters.d() == null) {
            throw new JSAFE_InvalidUseException(j);
        }
        if (jSAFE_Parameters.getAlgorithm().indexOf(this.o) == -1 && this.o.indexOf(jSAFE_Parameters.getAlgorithm()) == -1) {
            throw new JSAFE_InvalidParameterException("Invalid " + this.o + " parameters.");
        }
        this.u = com.rsa.jsafe.a.b(secureRandom);
        this.t = jSAFE_Parameters.d();
        this.p = 1;
    }

    public void keyAgreeInit(JSAFE_PrivateKey jSAFE_PrivateKey, java.security.SecureRandom secureRandom) throws JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException(i);
        }
        if (jSAFE_PrivateKey == null || jSAFE_PrivateKey.d() == null) {
            throw new JSAFE_InvalidKeyException("Invalid " + this.o + " private key.");
        }
        if (this.t == null && !jSAFE_PrivateKey.c()) {
            throw new JSAFE_InvalidUseException(j);
        }
        if (this.s != null) {
            this.s.clearSensitiveData();
        }
        if (this.q != null) {
            this.q.clearSensitiveData();
        }
        this.u = com.rsa.jsafe.a.b(secureRandom);
        if (jSAFE_PrivateKey.c()) {
            this.q = jSAFE_PrivateKey.a(this.n);
            this.t = this.b() ? ((ECPrivateKey)this.q).getParams() : ((DHPrivateKey)this.q).getParams();
        } else {
            this.q = this.a(this.t, jSAFE_PrivateKey.d());
        }
        this.a();
        this.p = 1;
    }

    public void keyAgreeInit(JSAFE_PublicKey jSAFE_PublicKey, java.security.SecureRandom secureRandom) throws JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException(i);
        }
        if (this.s != null) {
            this.s.clearSensitiveData();
        }
        if (jSAFE_PublicKey == null) {
            throw new JSAFE_InvalidKeyException("Invalid public key.");
        }
        if (!jSAFE_PublicKey.c() && this.t == null) {
            throw new JSAFE_InvalidUseException(j);
        }
        if (!jSAFE_PublicKey.c()) {
            this.s = this.a(this.t, jSAFE_PublicKey.f());
        } else {
            this.s = jSAFE_PublicKey.a(this.n);
            this.t = jSAFE_PublicKey.d();
        }
        this.u = com.rsa.jsafe.a.b(secureRandom);
        this.p = 1;
    }

    public void keyAgreeInit(java.security.SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        if (this.t == null) {
            throw new JSAFE_InvalidUseException(j);
        }
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException(i);
        }
        this.u = com.rsa.jsafe.a.b(secureRandom);
        this.p = 1;
    }

    public byte[] keyAgreePhase1() throws JSAFE_InvalidUseException {
        if (this.p != 1) {
            throw new JSAFE_InvalidUseException(h);
        }
        this.a(this.t, this.u);
        this.a();
        this.p = 2;
        if (this.o.indexOf("EC") != -1) {
            return ((ECPublicKey)this.r).getPublicPoint().getEncoded();
        }
        return ((DHPublicKey)this.r).getY().toOctetString();
    }

    private void a() throws JSAFE_InvalidUseException {
        try {
            this.m.init(this.q);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JSAFE_InvalidUseException("Could not initialize " + invalidKeyException.getMessage());
        }
    }

    public int keyAgreePhase1(byte[] byArray, int n2) throws JSAFE_InvalidUseException {
        byte[] byArray2 = this.keyAgreePhase1();
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    public byte[] keyAgreePhase2(byte[] byArray, int n2, int n3) throws JSAFE_InvalidUseException {
        if (this.t == null) {
            throw new JSAFE_InvalidUseException("Parameters should not be null.");
        }
        this.s = this.a(this.t, byArray, n2, n3);
        this.m.doPhase(this.s, true);
        this.p = 3;
        return this.m.getSecret();
    }

    public int keyAgreePhase2(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws JSAFE_InvalidUseException {
        if (this.p != 2) {
            throw new JSAFE_InvalidUseException(h);
        }
        byte[] byArray3 = this.keyAgreePhase2(byArray, n2, n3);
        if (byArray3.length <= byArray2.length - n4) {
            System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
            return byArray3.length;
        }
        throw new JSAFE_InvalidUseException("sharedSecret output buffer is too small.");
    }

    public void keyAgreeReInit() throws JSAFE_InvalidUseException {
        if (this.p < 1) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        this.s = null;
        if (this.q != null) {
            this.a();
        }
        this.p = 1;
    }

    private boolean b() {
        return this.o.startsWith("EC");
    }

    private PrivateKey a(DomainParams domainParams, PrivateKey privateKey) {
        if (this.b()) {
            return this.n.getKeyBuilder().newECPrivateKey(((ECPrivateKey)privateKey).getD().toOctetString(), (ECParams)domainParams);
        }
        return this.n.getKeyBuilder().newDHPrivateKey(((DHPrivateKey)privateKey).getX().toOctetString(), (PQGParams)domainParams);
    }

    private PublicKey a(DomainParams domainParams, PublicKey publicKey) {
        if (this.b()) {
            return this.n.getKeyBuilder().newECPublicKey(((ECPublicKey)publicKey).getPublicPoint().getX(), ((ECPublicKey)publicKey).getPublicPoint().getY(), (ECParams)domainParams);
        }
        return this.n.getKeyBuilder().newDHPublicKey(((DHPublicKey)publicKey).getY().toOctetString(), (PQGParams)domainParams);
    }

    private PublicKey a(DomainParams domainParams, byte[] byArray, int n2, int n3) {
        if (this.b()) {
            byte[][] byArray2 = dp.e(byArray, n2, n3);
            return this.n.getKeyBuilder().newECPublicKey(byArray2[0], byArray2[1], (ECParams)domainParams);
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        return this.n.getKeyBuilder().newDHPublicKey(byArray3, (PQGParams)domainParams);
    }

    private void a(JSAFE_Parameters jSAFE_Parameters, JSAFE_PrivateKey jSAFE_PrivateKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        if (this.q != null) {
            this.q.clearSensitiveData();
        }
        if (this.b()) {
            ECParams eCParams;
            ECParams eCParams2 = (ECParams)jSAFE_Parameters.d();
            if (!cu.a(eCParams2, eCParams = (ECParams)jSAFE_PrivateKey.f())) {
                throw new JSAFE_InvalidKeyException("System parameters and key parameters don't match.");
            }
            this.q = jSAFE_PrivateKey.a(this.n);
            this.t = ((ECPrivateKey)this.q).getParams();
        } else {
            if (jSAFE_Parameters.d() == null && !jSAFE_PrivateKey.c()) {
                throw new JSAFE_InvalidUseException("Neither parameters nor key contain domain parameters.");
            }
            PQGParams pQGParams = (PQGParams)jSAFE_Parameters.d();
            PQGParams pQGParams2 = (PQGParams)jSAFE_PrivateKey.f();
            if (pQGParams == null || cu.a(pQGParams, pQGParams2)) {
                this.q = jSAFE_PrivateKey.a(this.n);
                this.t = pQGParams2;
            } else {
                this.q = this.a((DomainParams)pQGParams, jSAFE_PrivateKey.d());
            }
        }
    }

    private void a(JSAFE_Parameters jSAFE_Parameters, JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_InvalidKeyException {
        if (this.s != null) {
            this.s.clearSensitiveData();
        }
        if (this.b()) {
            ECParams eCParams;
            ECParams eCParams2 = (ECParams)jSAFE_Parameters.d();
            if (!cu.a(eCParams2, eCParams = (ECParams)jSAFE_PublicKey.d())) {
                throw new JSAFE_InvalidKeyException("System parameters and key parameters don't match.");
            }
            this.s = jSAFE_PublicKey.a(this.n);
            this.t = ((ECPublicKey)this.s).getParams();
        } else {
            if (jSAFE_Parameters.d() == null && !jSAFE_PublicKey.c()) {
                throw new JSAFE_InvalidKeyException("Neither parameters nor key contain domain parameters.");
            }
            PQGParams pQGParams = (PQGParams)jSAFE_Parameters.d();
            PQGParams pQGParams2 = (PQGParams)jSAFE_PublicKey.d();
            DHPublicKey dHPublicKey = (DHPublicKey)jSAFE_PublicKey.f();
            this.s = this.n.getKeyBuilder().newDHPublicKey(dHPublicKey.getY().toOctetString(), (PQGParams)this.t);
            this.s = pQGParams == null || cu.a(pQGParams, pQGParams2) ? jSAFE_PublicKey.a(this.n) : this.n.getKeyBuilder().newDHPublicKey(dHPublicKey.getY().toOctetString(), (PQGParams)this.t);
        }
    }
}

