/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.alg;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.InvalidKeyException;
import com.rsa.crypto.PrivateKey;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.RSAPrivateKey;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.Signature;
import com.rsa.crypto.SignatureException;
import com.rsa.crypto.ncm.alg.SecureRandomWrapper;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEAsymmetricKey;
import com.rsa.crypto.ncm.ccme.CCMECryptoContext;
import com.rsa.crypto.ncm.ccme.CCMECryptoObject;
import com.rsa.crypto.ncm.ccme.CCMEException;
import com.rsa.crypto.ncm.log.NativeCryptoObjectEvent;
import com.rsa.cryptoj.c.bz;
import java.util.Arrays;

public abstract class AbstractSignature
extends CCMECryptoObject
implements Signature {
    static final String a = "Signature has not been initialized for verifying";
    static final String b = "Signature has not been initialized for signing";
    static final String c = "Signature has not been initialized";
    final String d;
    final a e;
    boolean f = true;
    CCMEAsymmetricKey g;
    boolean h;
    private int i;
    private int j;
    private CCMECryptoObject k;

    AbstractSignature(b b2, String string, String string2, a a2) {
        super(b2);
        this.d = string2;
        this.e = a2;
    }

    void a(int n2, int n3) {
        this.i = n2;
        this.j = n3;
        this.a();
    }

    private void a() {
        boolean bl2 = !this.isPKCS11Object() || this.f;
        boolean bl3 = !this.isPKCS11Object() || !this.f;
        this.createObjectNative(this.cryptoModule.b(), this.cryptoModule.e(), this.i, this.j, bl2, bl3);
    }

    @Override
    public String getAlg() {
        if (this.e == com.rsa.crypto.ncm.alg.AbstractSignature$a.e) {
            return this.d + "/RSAPSS/MGF1/" + this.d;
        }
        return this.d + '/' + this.e.g;
    }

    @Override
    public int getSignatureSize() {
        if (this.f) {
            return this.d();
        }
        return 0;
    }

    @Override
    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!this.getAlg().contains(privateKey.getAlg())) {
            throw new InvalidKeyException("Expected " + this.getAlg() + " actual " + privateKey.getAlg());
        }
        if (!this.f && this.isPKCS11Object()) {
            this.freeObject();
        }
        this.f = true;
        CCMEAsymmetricKey cCMEAsymmetricKey = (CCMEAsymmetricKey)((Object)privateKey);
        this.a(cCMEAsymmetricKey);
    }

    @Override
    public final void initSign(PrivateKey privateKey, AlgorithmParams algorithmParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initSign(privateKey);
        this.a(algorithmParams);
    }

    @Override
    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a(secureRandom);
        this.initSign(privateKey);
    }

    @Override
    public final void initSign(PrivateKey privateKey, AlgorithmParams algorithmParams, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initSign(privateKey, secureRandom);
        this.a(algorithmParams);
    }

    private void a(SecureRandom secureRandom) {
        if (secureRandom == null || this.isPKCS11Object()) {
            return;
        }
        SecureRandomWrapper secureRandomWrapper = null;
        if (this.k != null && this.k instanceof SecureRandomWrapper) {
            secureRandomWrapper = (SecureRandomWrapper)this.k;
        }
        if (secureRandom != this.k && (secureRandomWrapper == null || secureRandom != secureRandomWrapper.a)) {
            this.k = null;
            if (secureRandomWrapper != null) {
                secureRandomWrapper.clearSensitiveData();
            }
            this.k = secureRandom instanceof CCMECryptoObject ? (CCMECryptoObject)((Object)secureRandom) : new SecureRandomWrapper(this.cryptoModule, secureRandom);
        }
    }

    @Override
    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!this.getAlg().contains(publicKey.getAlg())) {
            throw new InvalidKeyException("Expected " + this.getAlg() + " actual " + publicKey.getAlg());
        }
        if (this.f && this.isPKCS11Object()) {
            this.freeObject();
        }
        if (this.f && this.k != null) {
            this.freeObject();
        }
        this.f = false;
        CCMEAsymmetricKey cCMEAsymmetricKey = (CCMEAsymmetricKey)((Object)publicKey);
        this.a(cCMEAsymmetricKey);
    }

    @Override
    public final void initVerify(PublicKey publicKey, AlgorithmParams algorithmParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initVerify(publicKey);
        this.a(algorithmParams);
    }

    public void a(CCMEAsymmetricKey cCMEAsymmetricKey) throws InvalidKeyException {
        if (cCMEAsymmetricKey.getCryptoModule().a() != this.cryptoModule.a()) {
            throw new InvalidKeyException("Signature and Key are for different devices");
        }
        this.c();
        this.g = (CCMEAsymmetricKey)cCMEAsymmetricKey.clone();
        if (this.isHandleNull()) {
            this.a();
        }
        boolean bl2 = this.e == com.rsa.crypto.ncm.alg.AbstractSignature$a.a || this.e == com.rsa.crypto.ncm.alg.AbstractSignature$a.b;
        try {
            this.initNative(this.f, this.g, this.k, bl2);
        }
        catch (CCMEException cCMEException) {
            this.a(cCMEException);
            throw cCMEException;
        }
        this.h = true;
        if (bz.a()) {
            bz.b().objectCreated(new NativeCryptoObjectEvent("Native", "Signature", this.getAlg(), this.getImplementationName()));
        }
    }

    private void a(CCMEException cCMEException) {
        switch (cCMEException.getErrorCode()) {
            case 10008: {
                throw new InvalidKeyException("Incorrect key type supplied [" + cCMEException.getMessage() + "]");
            }
        }
    }

    private void a(AlgorithmParams algorithmParams) throws InvalidAlgorithmParameterException {
        Integer n2;
        if (algorithmParams == null) {
            return;
        }
        if (!(algorithmParams instanceof AlgInputParams)) {
            throw new InvalidAlgorithmParameterException("Parameters object invalid for algorithm");
        }
        AlgInputParams algInputParams = (AlgInputParams)algorithmParams;
        if (this.e == com.rsa.crypto.ncm.alg.AbstractSignature$a.e) {
            n2 = (Integer)algInputParams.get("tfOption");
            if (n2 != null && n2 != 1) {
                throw new InvalidAlgorithmParameterException("Invalid tfOption parameter (" + n2 + "). Native RSAPSS requires tfOption == 1");
            }
            byte[] byArray = (byte[])algInputParams.get("salt");
            if (byArray != null) {
                throw new InvalidAlgorithmParameterException("Native RSAPSS does not support user-specified salt");
            }
            Integer n3 = (Integer)algInputParams.get("saltLen");
            if (n3 != null) {
                this.setRSAPSSSaltLen(n3);
            }
        }
        if (this.e.g.contains("RSA") && (n2 = (Integer)algInputParams.get("blinding")) != null) {
            if (n2 > 1) {
                n2 = 1;
            }
            if (this.g instanceof RSAPrivateKey && ((RSAPrivateKey)((Object)this.g)).hasCRTInfo()) {
                this.setRSABlindingLevel(n2);
            }
        }
    }

    @Override
    public void reInit(AlgorithmParams algorithmParams) {
        if (!this.h) {
            throw new IllegalStateException(c);
        }
        this.initNative(this.f, this.g, null, false);
        this.a(algorithmParams);
    }

    @Override
    public final byte[] sign() throws SignatureException {
        if (!this.h || !this.f) {
            throw new IllegalStateException(b);
        }
        byte[] byArray = new byte[this.d()];
        int n2 = this.sign(byArray, 0);
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            Arrays.fill(byArray, (byte)0);
            return byArray2;
        }
        return byArray;
    }

    @Override
    public final int sign(byte[] byArray, int n2) throws SignatureException {
        if (!this.h || !this.f) {
            throw new IllegalStateException(b);
        }
        try {
            return this.a(byArray, n2);
        }
        catch (CCMEException cCMEException) {
            this.b(cCMEException);
            throw cCMEException;
        }
    }

    int a(byte[] byArray, int n2) throws SignatureException {
        try {
            return this.signFinalNative(byArray, n2);
        }
        catch (CCMEException cCMEException) {
            if (cCMEException.getMessage().contains("BUFFER_TOO_SMALL")) {
                throw new SignatureException(cCMEException.getMessage());
            }
            throw cCMEException;
        }
    }

    @Override
    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public final void update(byte[] byArray, int n2, int n3) throws SignatureException {
        if (!this.h) {
            throw new IllegalStateException(c);
        }
        this.a(byArray, n2, n3);
    }

    void a(byte[] byArray, int n2, int n3) throws SignatureException {
        this.updateNative(this.f, byArray, n2, n3);
    }

    @Override
    public final boolean verify(byte[] byArray) throws SignatureException {
        return this.verify(byArray, 0, byArray.length);
    }

    @Override
    public final boolean verify(byte[] byArray, int n2, int n3) throws SignatureException {
        if (!this.h || this.f) {
            throw new SignatureException(a);
        }
        try {
            return this.b(byArray, n2, n3);
        }
        catch (CCMEException cCMEException) {
            this.b(cCMEException);
            throw cCMEException;
        }
    }

    boolean b(byte[] byArray, int n2, int n3) throws SignatureException {
        return this.verifyFinalNative(byArray, n2, n3);
    }

    private void b(CCMEException cCMEException) {
        switch (cCMEException.getErrorCode()) {
            case 10013: {
                throw new SignatureException("Signature has not been initialized [" + cCMEException.getMessage() + "]");
            }
            case 10001: {
                throw new SignatureException("Incorrect key type supplied [" + cCMEException.getMessage() + "]");
            }
            case 10023: {
                throw new SignatureException("Bad signature data length [" + cCMEException.getMessage() + "]");
            }
            case 10018: {
                throw new SignatureException("Bad signature data [" + cCMEException.getMessage() + "]");
            }
            case 10022: {
                throw new SignatureException("Bad signature data [" + cCMEException.getMessage() + "]");
            }
        }
    }

    @Override
    public void clearSensitiveData() {
        this.h = false;
        try {
            this.b();
        }
        finally {
            try {
                this.c();
            }
            finally {
                super.clearSensitiveData();
            }
        }
    }

    private void b() {
        if (this.k != null) {
            try {
                if (this.k instanceof SecureRandomWrapper) {
                    this.k.clearSensitiveData();
                }
            }
            finally {
                this.k = null;
            }
        }
    }

    private void c() {
        if (this.g != null) {
            this.g.clearSensitiveData();
            this.g = null;
        }
    }

    @Override
    public Object clone() {
        throw new CryptoException("This functionality is not supported by the native module.");
    }

    private int d() throws CCMEException {
        if (this.isPKCS11Object()) {
            return 1024;
        }
        return this.getSignatureLenNative();
    }

    native void createObjectNative(CCMECryptoContext var1, byte[] var2, int var3, int var4, boolean var5, boolean var6) throws CCMEException;

    private native void initNative(boolean var1, CCMEAsymmetricKey var2, CCMECryptoObject var3, boolean var4) throws CCMEException;

    private native void setRSAPSSSaltLen(int var1) throws CCMEException;

    private native void setRSABlindingLevel(int var1) throws CCMEException;

    private native int getSignatureLenNative() throws CCMEException;

    private native void updateNative(boolean var1, byte[] var2, int var3, int var4) throws CCMEException;

    private native int signFinalNative(byte[] var1, int var2) throws CCMEException;

    private native boolean verifyFinalNative(byte[] var1, int var2, int var3) throws CCMEException;

    public static enum a {
        a("DSA", "DSA"),
        b("ECDSA", "ECDSA"),
        c("RSA", "RSA_PKCS1", "RSA_PKCS1_RAW"),
        d("X931RSA", "RSA_X931"),
        e("RSAPSS", "RSA_PSS"),
        f("RawRSA", null, "RSA");

        final String g;
        final String h;
        final String i;

        private a(String string2, String string3) {
            this(string2, string3, string3);
        }

        private a(String string2, String string3, String string4) {
            this.g = string2;
            this.h = string3;
            this.i = string4;
        }
    }
}

