/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.Security;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalRule;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Workspace;
import com.ca.siteminder.sdk.adminapi.ca.xps.WorkspaceEntry;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceWithGlobalPolicyManager
extends TestBase {
    static String name;
    static Session session2;
    static PolicyData policyData2;
    static Security security2;
    static Administrator admin2;
    static Workspace workspace;
    static Grant grant;
    static Agent agent;
    static GlobalPolicy policy;
    static GlobalRule rule;

    static <T extends XPSObject> void createWorkspacedObject(XPSObject xPSObject, IClass<T> iClass) {
        int n = policyData2.search(iClass).size();
        STIUtil.createObject(session2, policyData2, xPSObject);
        String string = xPSObject.getXid();
        GenericObject genericObject = xPSObject.castToGenericObject();
        GenericObject genericObject2 = genericObject.getParent();
        if (genericObject2 == null) {
            InternalTesting.invalidate((XPSObject)workspace);
            List list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
            for (WorkspaceEntry workspaceEntry : list) {
                XPSObject xPSObject2 = workspaceEntry.getMember();
                if (!string.equals(xPSObject2.getXid())) continue;
                return;
            }
            WorkspaceWithGlobalPolicyManager.fail((String)("workspace does not contain " + string));
        }
        InternalTesting.fetchIgnoreCache(string, session2);
        int n2 = policyData2.search(iClass).size();
        WorkspaceWithGlobalPolicyManager.assertEquals((String)"sz", (int)(n + 1), (int)n2);
    }

    @TestBase.STI(value=1)
    public void wssetup() {
        name = "WorkspaceWithGlobalPolicyManager_" + SetupConnection.random;
        workspace = SecuritySetup.makeWorkspace(name);
        admin2 = SecuritySetup.admin2;
        String string = "CA.XPS::SecurityCategory@!Global Policy Administration";
        SecurityCategory securityCategory = SecuritySetup.makeSecurityCategory(string);
        grant = SecuritySetup.makeGrant(admin2, securityCategory);
        grant.setRightsMask(Integer.valueOf(Security.convertRights((String)"M")));
        this.createObject((XPSObject)grant);
        this.createObject((XPSObject)workspace);
        agent = SetupConnection.builder.doAgentSetUp(name);
        WorkspaceEntry workspaceEntry = SecuritySetup.makeWorkspaceEntry(workspace);
        workspaceEntry.setMember((XPSObject)agent);
        this.createObject((XPSObject)workspaceEntry);
        admin2.setWorkspaces(Collections.singletonList(workspace));
        this.updateObject((XPSObject)admin2);
        session2 = SecuritySetup.session2;
        session2.connect();
        security2 = session2.getSecurity();
        policyData2 = session2.getPolicyData();
        security2.setWorkspace(workspace);
    }

    @TestBase.STI(value=2)
    public void fetchGlobalDomain() {
        String string = "CA.SM::Domain@03-7bdf31f2-44d7-4d7b-a8f5-5de2eaa0b634";
        policyData2.fetchObject(string);
    }

    @TestBase.STI(value=3)
    public void createGlobalPolicy() {
        policy = ObjectBuilder.makeGlobalPolicy(name, policyData2);
        WorkspaceWithGlobalPolicyManager.createWorkspacedObject((XPSObject)policy, GlobalPolicy.ddclass);
    }

    @TestBase.STI(value=4)
    public void updateGlobalPolicy() {
        STIUtil.updateObject(session2, policyData2, (XPSObject)policy);
    }

    @TestBase.STI(value=5)
    public void updateGlobalDomain() {
        Domain domain = policy.getParent();
        STIUtil.failUpdate(policyData2, (XPSObject)domain, "rights");
    }

    @TestBase.STI(value=6)
    public void deleteGlobalPolicy() {
        STIUtil.deleteObject(session2, policyData2, (XPSObject)policy);
    }

    @TestBase.STI(value=7)
    public void testCreateGlobalRule() {
        rule = ObjectBuilder.makeGlobalRule(name, agent);
        WorkspaceWithGlobalPolicyManager.createWorkspacedObject((XPSObject)rule, GlobalRule.ddclass);
    }

    @TestBase.STI(value=8)
    public void resetCategory() {
        String string = "CA.XPS::SecurityCategory@!Policy Administration";
        SecurityCategory securityCategory = SecuritySetup.makeSecurityCategory(string);
        grant.setSecurityCategory(securityCategory);
        this.updateObject((XPSObject)grant);
    }

    @TestBase.STI(value=9)
    public void failDeleteGlobalRule() {
        STIUtil.failDelete(policyData2, (XPSObject)rule, "rights");
    }

    @TestBase.STI(value=10)
    public void failCreateGlobalRule() {
        rule = ObjectBuilder.makeGlobalRule(name + "_1", agent);
        STIUtil.failCreate(policyData2, (XPSObject)rule, "rights");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WorkspaceWithGlobalPolicyManager.suite());
    }

    public static Test suite() {
        return new SecuritySetup(WorkspaceWithGlobalPolicyManager.class);
    }
}

