/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentGroup;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecurityBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;

public class DomainManagerTest
extends SecurityBase {
    static String[] masks = new String[]{"V", "M"};
    String strUserDir1;
    String strUserDir2;
    String strUserDir3;
    String strUserDir4;
    String strAgent11;
    String strAgent12;
    String strAgent21;
    String strAgent22;
    String strAgent31;
    String strAgent32;
    String strAgent41;
    String strAgent42;
    String strDomain1;
    String strDomain2;
    String strDomain3;
    String strDomain4;
    String strRealm1;
    String strRealm2;
    String strRealm3;
    String strRealm4;
    String strRule1;
    String strRule2;
    String strRule3;
    String strRule4;
    String strResponse1;
    String strResponse2;
    String strResponse3;
    String strResponse4;
    String strPolicy1;
    String strPolicy2;
    String strPolicy3;
    String strPolicy4;
    String strAgentGroup1;
    String strAgentGroup2;
    String strAgentGroup3;
    static String[] methods = new String[]{"testDomain", "testRealm"};

    public String randomize(String string) {
        return string + "_" + SetupConnection.random;
    }

    public void randomize() {
        ++SetupConnection.random;
        this.strUserDir1 = this.randomize("tdmuserdir1");
        this.strAgent11 = this.randomize("tdmagent11");
        this.strAgent12 = this.randomize("tdmagent12");
        this.strDomain1 = this.randomize("tdmdomain1");
        this.strRealm1 = this.randomize("tdmrealm1");
        this.strRule1 = this.randomize("tdmrule1");
        this.strResponse1 = this.randomize("tdmresponse1");
        this.strPolicy1 = this.randomize("tdmpolicy1");
        this.strAgentGroup1 = this.randomize("tdmagentgroup1");
        ++SetupConnection.random;
        this.strUserDir2 = this.randomize("tdmuserdir2");
        this.strAgent21 = this.randomize("tdmagent21");
        this.strAgent22 = this.randomize("tdmagent22");
        this.strDomain2 = this.randomize("tdmdomain2");
        this.strRealm2 = this.randomize("tdmrealm2");
        this.strRule2 = this.randomize("tdmrule2");
        this.strResponse2 = this.randomize("tdmresponse2");
        this.strPolicy2 = this.randomize("tdmpolicy2");
        this.strAgentGroup2 = this.randomize("tdmagentgroup2");
        ++SetupConnection.random;
        this.strUserDir3 = this.randomize("tdmuserdir3");
        this.strAgent31 = this.randomize("tdmagent31");
        this.strAgent32 = this.randomize("tdmagent32");
        this.strDomain3 = this.randomize("tdmdomain3");
        this.strRealm3 = this.randomize("tdmrealm3");
        this.strRule3 = this.randomize("tdmrule");
        this.strResponse3 = this.randomize("tdmresponse3");
        this.strPolicy3 = this.randomize("tdmpolicy3");
        this.strAgentGroup3 = this.randomize("tdmagentgroup3");
    }

    public void createObjects() {
        this.randomize();
        seccat = (SecurityCategory)SetupConnection.policyData.fetchObject(SecuritySetup.currentSecurityCategory);
        SetupConnection.session.begin();
        SetupConnection.builder.doDomainSetUp(this.strUserDir1, this.strAgent11, this.strAgent12, this.strDomain1, this.strRealm1, this.strRule1, this.strResponse1, this.strPolicy1);
        SetupConnection.builder.doDomainSetUp(this.strUserDir2, this.strAgent21, this.strAgent22, this.strDomain2, this.strRealm2, this.strRule2, this.strResponse2, this.strPolicy2);
        this.createObject((XPSObject)this.makeAgentGroup(this.strAgentGroup1));
        this.createObject((XPSObject)this.makeAgentGroup(this.strAgentGroup2));
        SetupConnection.session.commit();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createObjects();
        this.clearScope();
    }

    void runSuite(String string) {
        this.doSetup(string);
        this.testRule();
        this.testRealm();
        this.testDomain();
        this.testAgent();
        this.testUserDirectory();
        this.testAgentGroup();
    }

    public void testDomain() {
        Domain domain = ObjectBuilder.makeDomain(this.strDomain3, null);
        this.tryCreate(Domain.ddclass, (XPSObject)domain);
        Domain domain2 = (Domain)SetupConnection.fetchByName(Domain.ddclass, this.strDomain1);
        domain2.setDesc("update" + domain2.getDesc());
        this.tryUpdate(Domain.ddclass, (XPSObject)domain2);
        this.trySearchByName(Domain.ddclass, this.strDomain2);
    }

    public void testRule() {
        Realm realm = (Realm)SetupConnection.fetchByName(Realm.ddclass, this.strRealm2);
        Rule rule = ObjectBuilder.makeRule(this.strRule3, realm);
        this.tryCreate(Rule.ddclass, (XPSObject)rule);
        Rule rule2 = (Rule)SetupConnection.fetchByName(Rule.ddclass, this.strRule1);
        rule2.setDesc("update" + rule2.getDesc());
        this.tryUpdate(Rule.ddclass, (XPSObject)rule2);
        this.tryDelete(Rule.ddclass, (XPSObject)rule2);
    }

    public void testRealm() {
        Agent agent = ObjectBuilder.makeAgent(this.strAgent31);
        this.createObject((XPSObject)agent);
        AuthScheme authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, "Basic");
        Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, this.strDomain2);
        Realm realm = ObjectBuilder.makeRealm(this.strRealm3, agent, authScheme, domain);
        this.tryCreate(Realm.ddclass, (XPSObject)realm);
        Realm realm2 = (Realm)SetupConnection.fetchByName(Realm.ddclass, this.strRealm1);
        realm2.setDesc("update" + realm2.getDesc());
        this.tryUpdate(Realm.ddclass, (XPSObject)realm2);
        this.tryDelete(Realm.ddclass, (XPSObject)realm2);
        this.trySearchByName(Realm.ddclass, this.strRealm2);
    }

    public void testAgent() {
        Agent agent = ObjectBuilder.makeAgent(this.strAgent32);
        this.tryCreate(Agent.ddclass, (XPSObject)agent);
        Agent agent2 = (Agent)SetupConnection.fetchByName(Agent.ddclass, this.strAgent11.toLowerCase());
        agent2.setDesc("update" + agent2.getDesc());
        this.tryUpdate(Agent.ddclass, (XPSObject)agent2);
        this.tryDelete(Agent.ddclass, (XPSObject)agent2);
        this.trySearchByName(Agent.ddclass, this.strAgent21.toLowerCase());
    }

    public void testUserDirectory() {
        UserDirectory userDirectory = ObjectBuilder.makeUserDirectory(this.strUserDir3);
        this.tryCreate(UserDirectory.ddclass, (XPSObject)userDirectory);
        UserDirectory userDirectory2 = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, this.strUserDir1);
        userDirectory2.setDesc("update" + userDirectory2.getDesc());
        this.tryUpdate(UserDirectory.ddclass, (XPSObject)userDirectory2);
        this.tryDelete(UserDirectory.ddclass, (XPSObject)userDirectory2);
        this.trySearchByName(UserDirectory.ddclass, this.strUserDir2);
    }

    public void testAgentGroup() {
        AgentGroup agentGroup = this.makeAgentGroup(this.strAgentGroup3);
        this.tryCreate(AgentGroup.ddclass, (XPSObject)agentGroup);
        AgentGroup agentGroup2 = (AgentGroup)SetupConnection.fetchByName(AgentGroup.ddclass, this.strAgentGroup1);
        agentGroup2.setDesc("update" + agentGroup2.getDesc());
        this.tryUpdate(AgentGroup.ddclass, (XPSObject)agentGroup2);
        this.tryDelete(AgentGroup.ddclass, (XPSObject)agentGroup2);
        this.trySearchByName(AgentGroup.ddclass, this.strAgentGroup2);
    }

    @TestBase.STI(value=1)
    public void test_v() throws XPSException {
        SecuritySetup.connect2();
        this.runSuite(masks[0]);
    }

    @TestBase.STI(value=2)
    public void test_m() throws XPSException {
        this.runSuite(masks[1]);
    }

    @TestBase.STI(value=3)
    public void test_v_scope_domain1() throws XPSException {
        Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, this.strDomain1);
        this.addScope((XPSObject)domain);
        this.runSuite(masks[0]);
    }

    @TestBase.STI(value=4)
    public void test_v_scope_domain2() throws XPSException {
        Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, this.strDomain2);
        this.addScope((XPSObject)domain);
        this.runSuite(masks[0]);
    }

    @TestBase.STI(value=5)
    public void test_m_scope_domain1() throws XPSException {
        Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, this.strDomain1);
        this.addScope((XPSObject)domain);
        this.runSuite(masks[1]);
    }

    @TestBase.STI(value=6)
    public void test_m_scope_domain2() throws XPSException {
        Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, this.strDomain2);
        this.addScope((XPSObject)domain);
        this.runSuite(masks[1]);
    }

    private AgentGroup makeAgentGroup(String string) throws XPSException {
        AgentGroup agentGroup = (AgentGroup)SetupConnection.policyData.newObject((IClass)AgentGroup.ddclass);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        Agent agent = (Agent)SetupConnection.fetchByName(Agent.ddclass, this.strAgent21.toLowerCase());
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        arrayList.add(agent);
        if (string != null) {
            agentGroup.setName(string);
        }
        agentGroup.setDesc("Security JUnit Sample AgentGroup");
        agentGroup.setAgentType(agentType);
        agentGroup.setAgents(arrayList);
        return agentGroup;
    }

    public static Test suite() {
        return new SecuritySetup(DomainManagerTest.class);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DomainManagerTest.suite());
    }
}

