/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.Security;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Workspace;
import com.ca.siteminder.sdk.adminapi.ca.xps.WorkspaceEntry;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AdminAdministrationTest
extends TestBase {
    static String name;
    static PolicyData policyData2;
    static Security security2;
    static Domain domainx;
    static Domain domain;
    static Domain newDomain;
    static Administrator admin2;
    static Workspace workspace;
    static WorkspaceEntry entry;
    static Grant domainGrant;
    static Grant adminGrant;
    static Workspace ws2;

    @TestBase.STI(value=1)
    public void smoke() throws Exception {
        name = "WorkspaceTest_" + SetupConnection.random;
        workspace = SecuritySetup.makeWorkspace(name);
        entry = SecuritySetup.makeWorkspaceEntry(workspace);
        domain = ObjectBuilder.makeDomain(name, null);
        entry.setMember((XPSObject)domain);
        admin2 = SecuritySetup.admin2;
        admin2.setWorkspaces(Collections.singletonList(workspace));
        domainGrant = SecuritySetup.makeGrant(admin2, null);
        domainGrant.setRightsMask(Integer.valueOf(Security.convertRights((String)"M")));
        SecurityCategory securityCategory = SecuritySetup.makeSecurityCategory("CA.XPS::SecurityCategory@!Admin Administration");
        adminGrant = SecuritySetup.makeGrant(admin2, securityCategory);
        adminGrant.setRightsMask(Integer.valueOf(Security.convertRights((String)"M")));
        domainx = ObjectBuilder.makeDomain(name + "x", null);
        this.createObject((XPSObject)domainGrant);
        this.createObject((XPSObject)adminGrant);
        this.createObject((XPSObject)domain);
        this.createObject((XPSObject)domainx);
        this.createObject((XPSObject)workspace);
        this.createObject((XPSObject)entry);
        this.updateObject((XPSObject)admin2);
        SecuritySetup.session2.connect();
        security2 = SecuritySetup.session2.getSecurity();
        policyData2 = SecuritySetup.session2.getPolicyData();
        Administrator administrator = security2.getAdmin();
        AdminAdministrationTest.assertEquals((String)"WorkSpace Admin XID and Server Admin XID must match", (String)admin2.getXid(), (String)administrator.getXid());
        List list = administrator.getWorkspaces();
        AdminAdministrationTest.assertSize("wslist", list, 1);
        Workspace workspace = (Workspace)list.get(0);
        AdminAdministrationTest.assertEquals((String)"Workspace and serverWorkspace XID must match", (String)AdminAdministrationTest.workspace.getXid(), (String)workspace.getXid());
        security2.setWorkspace(AdminAdministrationTest.workspace);
    }

    @TestBase.STI(value=2)
    public void nestedWorkspace() {
        Workspace workspace = SecuritySetup.makeWorkspace(name + "_ws2");
        this.createObject((XPSObject)workspace);
        Domain domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
        domain.setName(name + "_d2");
        this.createObject((XPSObject)domain);
        WorkspaceEntry workspaceEntry = SecuritySetup.makeWorkspaceEntry(workspace);
        workspaceEntry.setMember((XPSObject)domain);
        this.createObject((XPSObject)workspaceEntry);
        WorkspaceEntry workspaceEntry2 = SecuritySetup.makeWorkspaceEntry(AdminAdministrationTest.workspace);
        workspaceEntry2.setMember((XPSObject)workspace);
        this.createObject((XPSObject)workspaceEntry2);
        Workspace workspace2 = (Workspace)policyData2.fetchObject(workspace.getXid());
        List list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
        AdminAdministrationTest.assertSize("entries", list, 1);
        WorkspaceEntry workspaceEntry3 = (WorkspaceEntry)list.get(0);
        policyData2.updateObject((XPSObject)workspaceEntry3);
        policyData2.updateObject((XPSObject)domain);
        policyData2.deleteObject((XPSObject)workspace);
        STIUtil.failUpdate(policyData2, (XPSObject)domain, "Insufficient rights");
        this.deleteObject((XPSObject)domain);
    }

    @TestBase.STI(value=3)
    public void scopedAdminDelegation() {
        ws2 = (Workspace)policyData2.newObject((IClass)Workspace.ddclass);
        ws2.setName(name + "_ws2");
        policyData2.createObject((XPSObject)ws2);
        List list = policyData2.search((IClass)Workspace.ddclass);
        AdminAdministrationTest.assertSize("wslist", list, 2);
        Domain domain = (Domain)policyData2.newObject((IClass)Domain.ddclass);
        domain.setName(name + "_d2");
        policyData2.createObject((XPSObject)domain);
        WorkspaceEntry workspaceEntry = (WorkspaceEntry)policyData2.newObject((IClass)WorkspaceEntry.ddclass);
        workspaceEntry.setParent(ws2);
        workspaceEntry.setMember((XPSObject)domain);
        policyData2.createObject((XPSObject)workspaceEntry);
        List list2 = policyData2.search((IClass)WorkspaceEntry.ddclass);
        AdminAdministrationTest.assertSize("elist", list2, 4);
        policyData2.deleteObject((XPSObject)domain);
        list2 = policyData2.search((IClass)WorkspaceEntry.ddclass);
        AdminAdministrationTest.assertSize("elist", list2, 2);
    }

    @TestBase.STI(value=4)
    public void scopedAdminDelegationGrant() {
        Administrator administrator = security2.newAdministrator();
        String string = "newAdmin_" + SetupConnection.random;
        administrator.setName(string);
        administrator.setUserPath(string);
        policyData2.createObject((XPSObject)administrator);
        Grant grant = SecuritySetup.makeGrant(administrator, null);
        policyData2.createObject((XPSObject)grant);
        List list = security2.getWorkspaceClosure(workspace);
        AdminAdministrationTest.assertSize("missingObjects", list, 0);
        policyData2.deleteObject((XPSObject)administrator);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AdminAdministrationTest.suite());
    }

    public static Test suite() {
        return new SecuritySetup(AdminAdministrationTest.class);
    }
}

