/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.rolesexp;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapitest.RoleExpSetup;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseAuth;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RoleExpTestGroup3
extends TestBaseAuth {
    private static String strExpression1 = "#Expression1";
    private static String strExpression2 = "#Expression2";

    @TestBase.STI(value=1)
    public void test34_vaLIKE_vwxyz_WildCard() throws XPSException {
        expSetup.updateRole("(\"va\" LIKE \"[vwxyz]?\")");
        this.processScenario(true);
    }

    @TestBase.STI(value=2)
    public void test35_aLIKE_abcde_Asterisk() throws XPSException {
        expSetup.updateRole("(\"a\" LIKE \"[abcde]*\")");
        this.processScenario(true);
    }

    @TestBase.STI(value=3)
    public void test36_aabbccddeeLIKE_abcde_Asterisk() throws XPSException {
        expSetup.updateRole("(\"aabbccddee\" LIKE \"[abcde]*\" )");
        this.processScenario(true);
    }

    @TestBase.STI(value=4)
    public void test37_abcdefLIKE_abcde_Asterisk() throws XPSException {
        expSetup.updateRole("(\"abcdef\" LIKE \"[abcde]*\")");
        this.processScenario(true);
    }

    @TestBase.STI(value=5)
    public void test38_abcLIKE_abcde_Asterisk() throws XPSException {
        expSetup.updateRole("(\"abc\" LIKE \"[abcde]*\" )");
        this.processScenario(true);
    }

    @TestBase.STI(value=6)
    public void test39_123Hypen456Hypen7890_LIKE1() throws XPSException {
        expSetup.updateRole("(\"123-456-7890\" LIKE \"[0-9][0-9][0-9]\\-[0-9][0-9][0-9]\\-[0-9][0-9][0-9][0-9]\")");
        this.processScenario(true);
    }

    @TestBase.STI(value=7)
    public void test40_123Hypen456Hypen7890_LIKE2() throws XPSException {
        expSetup.updateRole("(\"123-456-7890\" LIKE \"[0-9][0-9][0-9]\\-[0-9][0-4][0-4]\\-[0-9][0-9][0-9][0-9]\" )");
        this.processScenario(false);
    }

    @TestBase.STI(value=8)
    public void test41_1bcHypen456Hypen7890_LIKE3() throws XPSException {
        expSetup.updateRole("(\"1bc-456-7890\" LIKE \"[0-9][a-z][a-z]\\-[0-9][0-9][0-9]\\-[0-9][0-9][0-9][0-9]\")");
        this.processScenario(true);
    }

    @TestBase.STI(value=9)
    public void test42_1BCHypen456Hypen7890_LIKE4() throws XPSException {
        expSetup.updateRole("(\"1BC-456-7890\" LIKE \"[0-9][a-z][a-z]\\-[0-9][0-9][0-9]\\-[0-9][0-9][0-9][0-9]\" )");
        this.processScenario(false);
    }

    @TestBase.STI(value=10)
    public void test43_SAMPLE_ONE_TWOINTERSECTSAMPLE_one() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "(\"SAMPLE^ONE^TWO\" INTERSECT \"SAMPLE^one\")");
        expSetup.createOrModifyExpression(strExpression2, "\"SAMPLE\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=11)
    public void test44_SAMPLE_ONE_TWO_NoCase_INTERSECTSAMPLE_one() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "\"SAMPLE^ONE^TWO\" ~INTERSECT \"SAMPLE^one\"");
        expSetup.createOrModifyExpression(strExpression2, "\"SAMPLE^ONE\"");
        expSetup.updateRole("(" + strExpression1 + " ~= " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=12)
    public void test45_SAMPLE_ONE_TWO_SAMPLE_UNIONTHREE_TWO() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "(\"SAMPLE^ONE^TWO\" UNION \"THREE^TWO\")");
        expSetup.createOrModifyExpression(strExpression2, "\"ONE^SAMPLE^THREE^TWO\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=13)
    public void test46_SAMPLE_ONE_TWO_SAMPLE_UNIONTHREE_two() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "(\"SAMPLE^ONE^TWO^SAMPLE\" UNION \"THREE^two\")");
        expSetup.createOrModifyExpression(strExpression2, "\"ONE^SAMPLE^THREE^TWO^two\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=14)
    public void test47_SAMPLE_ONE_TWO_SAMPLE_NoCase_UNIONTHREE_two() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "(\"SAMPLE^ONE^TWO^SAMPLE\" ~UNION \"THREE^two\")");
        expSetup.createOrModifyExpression(strExpression2, "\"ONE^SAMPLE^THREE^TWO\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=15)
    public void test48_NOTSAMPLE_ENDS_WITHE() throws XPSException {
        expSetup.updateRole("(NOT(\"SAMPLE\" ENDS_WITH \"E\") )");
        this.processScenario(false);
    }

    @TestBase.STI(value=16)
    public void test49_NOTSAMPLE_ENDS_WITHe() throws XPSException {
        expSetup.updateRole("(NOT(\"SAMPLE\" ENDS_WITH \"e\"))");
        this.processScenario(true);
    }

    @TestBase.STI(value=17)
    public void test50_NOTSAMPLE_NoCase_ENDS_WITHe() throws XPSException {
        expSetup.updateRole("(NOT(\"SAMPLE\" ~ENDS_WITH \"e\") )");
        this.processScenario(false);
    }

    @TestBase.STI(value=18)
    public void test51_100_LT_102ANDSAMPLE_NoCase_EQ_sample() throws XPSException {
        expSetup.updateRole("((100 < 102) AND (\"SAMPLE\" ~= \"sample\"))");
        this.processScenario(true);
    }

    @TestBase.STI(value=19)
    public void test52_100_GT_102ORSAMPLE_NoCase_EQ_sample() throws XPSException {
        expSetup.updateRole("((100 > 102) OR (\"SAMPLE\" ~= \"sample\"))");
        this.processScenario(true);
    }

    @TestBase.STI(value=20)
    public void test53_100_LT_102ANDSAMPLE_EQ_sample() throws XPSException {
        expSetup.updateRole("((100 < 102) AND (\"SAMPLE\" = \"sample\") )");
        this.processScenario(false);
    }

    @TestBase.STI(value=21)
    public void test54_100_GT_102ORSAMPLE_EQ_sample() throws XPSException {
        expSetup.updateRole("((100 > 102) OR (\"SAMPLE\" = \"sample\"))");
        this.processScenario(false);
    }

    @TestBase.STI(value=22)
    public void test55_SAMPLE_EQ_sample_WildCardYES_NO() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "(\"SAMPLE\" =\"sample\" ? \"YES\" : \"NO\")");
        expSetup.createOrModifyExpression(strExpression2, "\"NO\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=23)
    public void test56_SAMPLE_NoCase_EQ_sample_WildCardYES_NO() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "(\"SAMPLE\" ~=\"sample\" ? \"YES\" : \"NO\")");
        expSetup.createOrModifyExpression(strExpression2, "\"YES\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=24)
    public void test57_One_TWO_THREE_FOUR_FIVE_3() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "\"One^TWO^THREE^FOUR^FIVE\"[3]");
        expSetup.createOrModifyExpression(strExpression2, "\"FOUR\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    @TestBase.STI(value=25)
    public void test58_One_TWO_THREE_FOUR_FIVE_0() throws XPSException {
        expSetup.createOrModifyExpression(strExpression1, "(\"One^TWO^THREE^FOUR^FIVE\"[0])");
        expSetup.createOrModifyExpression(strExpression2, "\"One\"");
        expSetup.updateRole("(" + strExpression1 + " = " + strExpression2 + ")");
        this.processScenario(true);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RoleExpTestGroup3.suite());
    }

    public static Test suite() {
        return new RoleExpSetup(RoleExpTestGroup3.class, RoleExpSetup.AuthSchemeType.Basic, RoleExpSetup.SetupType.Basic);
    }
}

