/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.Xlate;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;

public class XlateTest
extends TestBase {
    @TestBase.STI(value=1)
    public void smoke() {
        Xlate xlate = SetupConnection.session.getXlate("en", "us", "smoke");
        String string = xlate.getMessage("k1");
        XlateTest.assertContains(string, "en-us/smoke k1");
    }

    @TestBase.STI(value=2)
    public void param() {
        Xlate xlate = SetupConnection.session.getXlate("en", "us", "smoke");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("xxx");
        String string = xlate.getMessage("a%0b", arrayList);
        XlateTest.assertEquals((String)"Incorrect message from XLate", (String)string, (String)"en/smoke axxxb");
    }

    @TestBase.STI(value=3)
    public void params() {
        Xlate xlate = SetupConnection.session.getXlate("en", "us", "smoke");
        this.run(xlate, "a%1b", "a%1b", new String[0]);
        this.run(xlate, "a%1b", "a%1b", "x");
        this.run(xlate, "a%1b", "ayb", "x", "y");
        this.run(xlate, "a%1b", "ayb", "x", "y", "z");
        this.run(xlate, "a%%%2%0b%9", "a%%2xb%9", "x");
        this.run(xlate, "a%%%2%0b%9", "a%%2xb%9", "x", "y");
        this.run(xlate, "a%%%2%0b%9", "a%zxb%9", "x", "y", "z");
    }

    void run(Xlate xlate, String string, String string2, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray) {
            arrayList.add(string3);
        }
        String string4 = xlate.getMessage(string, arrayList);
        XlateTest.assertContains(string4, string2);
    }

    @TestBase.STI(value=4)
    public void wrongApplication() {
        Xlate xlate = SetupConnection.session.getXlate("en", "us", "wrong");
        String string = xlate.getMessage("k1");
        XlateTest.assertEquals((String)"An empty message expected", (String)string, (String)"");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)XlateTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(XlateTest.class);
    }
}

