/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent4x;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class CastTest
extends TestBase {
    @TestBase.STI(value=1)
    public void toBaseclass() {
        Agent agent = (Agent)SetupConnection.policyData.newObject((IClass)Agent4x.ddclass);
        Agent agent2 = (Agent)agent.castTo(Agent.ddclass);
        CastTest.assertTrue((String)"Agent class is not an instance of Agent4x class", (boolean)agent2.isInstanceOf((IClass)Agent4x.ddclass));
    }

    @TestBase.STI(value=2)
    public void toSubclass() {
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        String string = "agent" + SetupConnection.random;
        Agent agent = ObjectBuilder.makeAgent(string);
        CastTest.assertFalse((String)"Web Agent Class must not be an instance of Agent4x", (boolean)agent.isInstanceOf((IClass)Agent4x.ddclass));
        Agent4x agent4x = (Agent4x)agent.castTo(Agent4x.ddclass);
        CastTest.assertTrue((String)"Agent4x object must be an instance of Agent4x class", (boolean)agent4x.isInstanceOf((IClass)Agent4x.ddclass));
        String string2 = "firewall";
        String string3 = "127.0.0.1";
        agent4x.setIpAddr(string3);
        agent4x.setSecret(string2);
        this.createObject((XPSObject)agent4x);
        Agent agent2 = (Agent)InternalTesting.fetchIgnoreCache(agent4x.getXid(), SetupConnection.session);
        CastTest.assertTrue((String)"fromServer must be an instance of Agent4x", (boolean)agent2.isInstanceOf((IClass)Agent4x.ddclass));
        Agent4x agent4x2 = (Agent4x)agent2.castTo(Agent4x.ddclass);
        CastTest.assertTrue((boolean)agent4x2.hasSecret());
        CastTest.assertEquals((String)"Agent ip must match", (String)agent4x2.getIpAddr(), (String)string3);
        agent4x.clearIpAddr();
        agent4x.clearSecret();
        this.updateObject((XPSObject)agent4x);
        agent = (Agent)InternalTesting.fetchIgnoreCache(agent4x.getXid(), SetupConnection.session);
        CastTest.assertFalse((String)"a4x XID object is not an instance of Agent4x class", (boolean)agent.isInstanceOf((IClass)Agent4x.ddclass));
    }

    @TestBase.STI(value=3)
    public void toGenericObject() {
        Agent agent = (Agent)SetupConnection.policyData.newObject((IClass)Agent.ddclass);
        GenericObject genericObject = (GenericObject)agent.castTo(GenericObject.class);
        Agent agent2 = (Agent)genericObject.castTo(Agent.ddclass);
        CastTest.assertTrue((String)"Agent object must match with Generic object", (boolean)agent.equals((Object)genericObject));
        CastTest.assertTrue((String)"Agent object must match with Generic object type-casted to Agent object", (boolean)agent.equals((Object)agent2));
    }

    @TestBase.STI(value=4)
    public void wrongCast() {
        Agent agent = (Agent)SetupConnection.policyData.newObject((IClass)Agent.ddclass);
        CastTest.assertFalse((String)"Agent class must not match with Policy class", (boolean)agent.isInstanceOf((IClass)Policy.ddclass));
        try {
            agent.castTo(Policy.ddclass);
            CastTest.fail((String)"Agent object casted to Policy class successfully.");
        }
        catch (XPSException xPSException) {
            CastTest.assertTrue((String)"Exception must contain \"cast\"", (boolean)xPSException.getTag().contains("cast"));
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CastTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(CastTest.class);
    }
}

