/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.Directory;
import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.User;
import com.ca.siteminder.sdk.adminapi.ValidatePasswordResponse;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;

public class UserTestAdminWithReadRights
extends TestBaseDMS {
    private static Session newAdminSession;
    private static Directory dir1;
    static User pwdUser;
    static User dsbUser;
    static User grpUser;

    public void setUpSuite() {
        super.setUpSuite();
        UserTestAdminWithReadRights.breakdown(SetupConnection.session);
        EnumSet<Admin.Rights> enumSet = EnumSet.noneOf(Admin.Rights.class);
        EnumSet<Administrator.Flags> enumSet2 = EnumSet.noneOf(Administrator.Flags.class);
        UserTestAdminWithReadRights.createNewAdmin(SetupConnection.session, "CA.XPS::SecurityCategory@!Directory Administration", enumSet, enumSet2, null);
        String string = UserTestAdminWithReadRights.getSpec(SetupConnection.session);
        newAdminSession = UserTestAdminWithReadRights.login(SetupConnection.session, string);
        try {
            UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, udName);
            dir1 = newAdminSession.getDirectoryManager().getDirectory(userDirectory.getXid());
        }
        catch (Exception exception) {
            throw new XPSException(exception.getMessage());
        }
        if (dir1 == null) {
            throw new XPSException("Cannot create user directory");
        }
        dsbUser = dir1.fetchUser(fullUserDsbDN);
        grpUser = dir1.fetchUser(fullUserGrpDN);
        pwdUser = dir1.fetchUser(fullUserPwdDN);
    }

    @TestBase.STI(value=1)
    public void testDisable() throws XPSException {
        try {
            if (dsbUser.enable(1)) {
                UserTestAdminWithReadRights.fail((String)"User disabled with Admin having Read-Only rights");
            }
        }
        catch (ServerException serverException) {
            UserTestAdminWithReadRights.assertEquals((String)"Exception tag must match with user.enable", (String)serverException.getTag(), (String)"user.enable");
        }
    }

    @TestBase.STI(value=2)
    public void testEnable() throws XPSException {
        try {
            if (dsbUser.enable(0)) {
                UserTestAdminWithReadRights.fail((String)"User enabled using Admin with Read-only rights");
            }
        }
        catch (ServerException serverException) {
            UserTestAdminWithReadRights.assertEquals((String)"Exception tag must match with user.enable", (String)serverException.getTag(), (String)"user.enable");
        }
    }

    @TestBase.STI(value=3)
    public void testGetGroups() throws XPSException {
        String string = SetupConnection.properties.get("USERDIR_NAMESPACE");
        if (!string.equalsIgnoreCase("ODBC:")) {
            UserTestAdminWithReadRights.skip("Raised RTC defect 138702 to see why this is consistently failing for " + string);
        }
        List list = null;
        list = grpUser.getGroups(true);
        UserTestAdminWithReadRights.assertSize("list", list, 2);
    }

    @TestBase.STI(value=4)
    public void testIsInGroup() throws XPSException {
        String string = SetupConnection.properties.get("USERDIR_NAMESPACE");
        if (!string.equalsIgnoreCase("ODBC:")) {
            UserTestAdminWithReadRights.skip("Raised RTC defect 138702 to see why this is consistently failing for " + string);
        }
        List list = grpUser.getGroups(true);
        UserTestAdminWithReadRights.assertNotEmpty("list", list);
        boolean bl = grpUser.isInGroup(((ResultEntry)list.get(0)).getDN());
        UserTestAdminWithReadRights.assertTrue((boolean)bl);
    }

    @TestBase.STI(value=5)
    public void testIsInGroup_InvalidGroup() throws XPSException {
        boolean bl = grpUser.isInGroup("jnjrehfuhhnn");
        UserTestAdminWithReadRights.assertFalse((boolean)bl);
    }

    @TestBase.STI(value=6)
    public void testSetPasswordMustChange() throws XPSException {
        try {
            pwdUser.setPasswordMustChange();
            pwdUser.enable(0);
            UserTestAdminWithReadRights.fail((String)"An Admin with READ only rights must not be allowed to invoke this method");
        }
        catch (ServerException serverException) {
            UserTestAdminWithReadRights.assertContains(serverException.getTag(), "MustChange");
        }
    }

    @TestBase.STI(value=7)
    public void testValidatePassword() throws XPSException {
        try {
            pwdUser.enable(0);
            pwdUser.validatePassword("TestPassword1234&Abc", false, false);
            UserTestAdminWithReadRights.fail((String)"validated bad password");
        }
        catch (ServerException serverException) {
            // empty catch block
        }
    }

    @TestBase.STI(value=8)
    public void testGetAttributes() throws XPSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(testAttr);
        Map map = pwdUser.getAttributes(arrayList);
        UserTestAdminWithReadRights.assertNotEmpty("user.getAttributes() returned null ", map);
        List list = (List)map.get(testAttr);
        UserTestAdminWithReadRights.assertNotEmpty("fetch password-attribute value resulted in null ", list);
    }

    @TestBase.STI(value=9)
    public void testSetAttributes() throws XPSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(testAttr);
        Map map = pwdUser.getAttributes(arrayList);
        UserTestAdminWithReadRights.assertNotEmpty("user.getAttributes() returned null ", map);
        List list = (List)map.get(testAttr);
        list.set(0, "2");
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put(pwdDataAttr, list);
        int n = pwdUser.setAttributes(hashMap);
        UserTestAdminWithReadRights.assertEquals((String)"setAttributes returned 0", (int)0, (int)n);
    }

    @TestBase.STI(value=10)
    public void testValidateNewPassword() throws XPSException {
        ValidatePasswordResponse validatePasswordResponse = pwdUser.validateNewPassword("Password1", "Password2", false, false);
        UserTestAdminWithReadRights.assertTrue((String)"Validate password failed", (boolean)validatePasswordResponse.isValid());
    }

    @TestBase.STI(value=11)
    public void testChangePassword_NotRequireOldPassword() throws XPSException {
        try {
            pwdUser.changePassword("", "NewPassword11", true);
            UserTestAdminWithReadRights.fail((String)"changePassword failed when NotRequireOldPassword set to TRUE.");
        }
        catch (ServerException serverException) {
            UserTestAdminWithReadRights.assertEquals((String)"Exception tag must match with user.changePassword", (String)serverException.getTag(), (String)"user.changePassword");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UserTestAdminWithReadRights.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(UserTestAdminWithReadRights.class);
    }
}

