/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Expression;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class DirectoryTestFilter
extends TestBaseDMS {
    @TestBase.STI(value=1)
    public void testSearchFilter_ClauseEquals() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.EQUAL, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertSize("directory.search result", list, 1);
        DirectoryTestFilter.assertContains(((ResultEntry)list.get(0)).getDN(), userSearchName);
    }

    @TestBase.STI(value=2)
    public void testSearchFilter_ClauseNOTEquals() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.NOTEQUAL, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string.equals(userSearchName));
        }
    }

    @TestBase.STI(value=3)
    public void testSearchFilter_ClauseGreater() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.GREATER, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((string.compareTo(userSearchName) > 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=4)
    public void testSearchFilter_ClauseNotGreater() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.NOTGREATER, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((string.compareTo(userSearchName) > 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=5)
    public void testSearchFilter_ClauseLess() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.LESS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((string.compareTo(userSearchName) < 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=6)
    public void testSearchFilter_ClauseNotLess() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.NOTLESS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((string.compareTo(userSearchName) < 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=7)
    public void testSearchFilter_ClauseBeginsWith() throws XPSException {
        String string = userSearchName.substring(0, 1);
        Clause clause = new Clause(uid, Clause.Operator.BEGINSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((boolean)string2.toLowerCase().startsWith(string.toLowerCase()));
        }
    }

    @TestBase.STI(value=8)
    public void testSearchFilter_ClauseNotBeginsWith() throws XPSException {
        String string = userSearchName.substring(0, 1);
        Clause clause = new Clause(uid, Clause.Operator.NOTBEGINSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string2.toLowerCase().startsWith(string));
        }
    }

    @TestBase.STI(value=9)
    public void testSearchFilter_ClauseEndsWith() throws XPSException {
        String string = userSearchName.substring(userSearchName.length() - 1, userSearchName.length());
        Clause clause = new Clause(uid, Clause.Operator.ENDSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((boolean)string2.toLowerCase().endsWith(string));
        }
    }

    @TestBase.STI(value=10)
    public void testSearchFilter_ClauseNotEndsWith() throws XPSException {
        String string = userSearchName.substring(userSearchName.length() - 1, userSearchName.length());
        Clause clause = new Clause(uid, Clause.Operator.NOTENDSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string2.toLowerCase().endsWith(string));
        }
    }

    @TestBase.STI(value=11)
    public void testSearchFilter_ClauseContains() throws XPSException {
        String string = userSearchName.substring(userSearchName.length() / 2, userSearchName.length() / 2 + 1);
        Clause clause = new Clause(uid, Clause.Operator.CONTAINS, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((boolean)string2.toLowerCase().contains(string));
        }
    }

    @TestBase.STI(value=12)
    public void testSearchFilter_ClauseNotContains() throws XPSException {
        String string = userSearchName.substring(userSearchName.length() / 2, userSearchName.length() / 2 + 1);
        Clause clause = new Clause(uid, Clause.Operator.NOTCONTAINS, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search() returned null ", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string2.toLowerCase().contains(string));
        }
    }

    @TestBase.STI(value=13)
    public void testSearchFilter_ClauseEquals_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        Clause clause = new Clause(uid, Clause.Operator.EQUAL, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertSize("directory.search result", list, 1);
        DirectoryTestFilter.assertContains(((ResultEntry)list.get(0)).getDN(), userSearchName);
    }

    @TestBase.STI(value=14)
    public void testSearchFilter_ClauseNOTEquals_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        Clause clause = new Clause(uid, Clause.Operator.NOTEQUAL, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string.equals(userSearchName));
        }
    }

    @TestBase.STI(value=15)
    public void testSearchFilter_ClauseGreater_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        Clause clause = new Clause(uid, Clause.Operator.GREATER, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((string.compareTo(userSearchName) > 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=16)
    public void testSearchFilter_ClauseNotGreater_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        Clause clause = new Clause(uid, Clause.Operator.NOTGREATER, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((string.compareTo(userSearchName) > 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=17)
    public void testSearchFilter_ClauseLess_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        Clause clause = new Clause(uid, Clause.Operator.LESS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((string.compareTo(userSearchName) < 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=18)
    public void testSearchFilter_ClauseNotLess_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        Clause clause = new Clause(uid, Clause.Operator.NOTLESS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((string.compareTo(userSearchName) < 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=19)
    public void testSearchFilter_ClauseBeginsWith_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        String string = userSearchName.substring(0, 1);
        Clause clause = new Clause(uid, Clause.Operator.BEGINSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((boolean)string2.toLowerCase().startsWith(string.toLowerCase()));
        }
    }

    @TestBase.STI(value=20)
    public void testSearchFilter_ClauseNotBeginsWith_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        String string = userSearchName.substring(0, 1);
        Clause clause = new Clause(uid, Clause.Operator.NOTBEGINSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string2.toLowerCase().startsWith(string));
        }
    }

    @TestBase.STI(value=21)
    public void testSearchFilter_ClauseEndsWith_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        String string = userSearchName.substring(userSearchName.length() - 1, userSearchName.length());
        Clause clause = new Clause(uid, Clause.Operator.ENDSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((boolean)string2.toLowerCase().endsWith(string));
        }
    }

    @TestBase.STI(value=22)
    public void testSearchFilter_ClauseNotEndsWith_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        String string = userSearchName.substring(userSearchName.length() - 1, userSearchName.length());
        Clause clause = new Clause(uid, Clause.Operator.NOTENDSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string2.toLowerCase().endsWith(string));
        }
    }

    @TestBase.STI(value=23)
    public void testSearchFilter_ClauseContains_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        String string = userSearchName.substring(userSearchName.length() / 2, userSearchName.length() / 2 + 1);
        Clause clause = new Clause(uid, Clause.Operator.CONTAINS, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search()", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((boolean)string2.toLowerCase().contains(string));
        }
    }

    @TestBase.STI(value=24)
    public void testSearchFilter_ClauseNotContains_GetValues() throws XPSException {
        searchOptions.setGetValuesFlag(true);
        String string = userSearchName.substring(userSearchName.length() / 2, userSearchName.length() / 2 + 1);
        Clause clause = new Clause(uid, Clause.Operator.NOTCONTAINS, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotEmpty("directory.search() returned null ", list);
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((boolean)string2.toLowerCase().contains(string));
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DirectoryTestFilter.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(DirectoryTestFilter.class);
    }

    public void setUpSuite() {
        super.setUpSuite();
    }
}

